/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about a cluster support token. <p> The cluster support token indicates the current usage of a cluster managed by Cloudera Manager. The cluster support token is an ASCII encoded string of 32 characters. It is unique to each cluster.")
public class ApiClusterSupportToken {
    @SerializedName(value="clusterName")
    private String clusterName = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="clusterSupportToken")
    private String clusterSupportToken = null;

    public ApiClusterSupportToken clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @ApiModelProperty(value="The name of the cluster. <p> Immutable since API v6. <p> Prior to API v6, will contain the display name of the cluster.")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ApiClusterSupportToken displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The display name of the cluster that is shown in the UI. <p> Available since API v6.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiClusterSupportToken clusterSupportToken(String clusterSupportToken) {
        this.clusterSupportToken = clusterSupportToken;
        return this;
    }

    @ApiModelProperty(value="The unique support token for a cluster. <p> Available since API v43.")
    public String getClusterSupportToken() {
        return this.clusterSupportToken;
    }

    public void setClusterSupportToken(String clusterSupportToken) {
        this.clusterSupportToken = clusterSupportToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterSupportToken apiClusterSupportToken = (ApiClusterSupportToken)o;
        return Objects.equals(this.clusterName, apiClusterSupportToken.clusterName) && Objects.equals(this.displayName, apiClusterSupportToken.displayName) && Objects.equals(this.clusterSupportToken, apiClusterSupportToken.clusterSupportToken);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.displayName, this.clusterSupportToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterSupportToken {\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    clusterSupportToken: ").append(this.toIndentedString(this.clusterSupportToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

