/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletRequest;

public class RequestBodyUtils {
    public static String getRequestBodyParameter(ServletRequest request, String parameter) throws IOException {
        return RequestBodyUtils.getRequestBodyParameter(request, parameter, false);
    }

    public static String getRequestBodyParameter(ServletRequest request, String parameter, boolean decode) throws IOException {
        return RequestBodyUtils.getRequestBodyParameter((InputStream)request.getInputStream(), parameter, decode);
    }

    public static String getRequestBodyParameter(InputStream inputStream, String parameter) throws IOException {
        return RequestBodyUtils.getRequestBodyParameter(inputStream, parameter, false);
    }

    public static String getRequestBodyParameter(InputStream inputStream, String parameter, boolean decode) throws IOException {
        return RequestBodyUtils.getRequestBodyParameter(new InputStreamReader(inputStream, StandardCharsets.UTF_8), parameter, decode);
    }

    public static String getRequestBodyParameter(Reader reader, String parameter) throws IOException {
        return RequestBodyUtils.getRequestBodyParameter(reader, parameter, false);
    }

    public static String getRequestBodyParameter(Reader reader, String parameter, boolean decode) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder requestBodyBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            requestBodyBuilder.append(line);
        }
        String requestBodyString = decode ? URLDecoder.decode(requestBodyBuilder.toString(), StandardCharsets.UTF_8.name()) : requestBodyBuilder.toString();
        return RequestBodyUtils.getRequestBodyParameter(requestBodyString, parameter);
    }

    public static String getRequestBodyParameter(String requestBodyString, String parameter) {
        if (requestBodyString != null) {
            String[] requestBodyParams;
            for (String requestBodyParam : requestBodyParams = requestBodyString.split("&")) {
                String[] keyValue = requestBodyParam.split("=", 2);
                if (!parameter.equals(keyValue[0])) continue;
                return keyValue[1];
            }
        }
        return null;
    }
}

