/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.plang;

import java.util.List;
import org.apache.knox.gateway.plang.ArityException;

public interface Arity {
    public static final Arity UNARY = Arity.of(1);
    public static final Arity BINARY = Arity.of(2);

    public void check(String var1, List<?> var2);

    public static Arity of(int count) {
        return (methodName, params) -> {
            if (params.size() != count) {
                throw new ArityException(methodName, count, params.size());
            }
        };
    }

    public static Arity min(int count) {
        return (methodName, params) -> {
            if (params.size() < count) {
                throw new ArityException("wrong number of arguments in call to '" + methodName + "'. Expected at least " + count + " got " + params.size() + ".");
            }
        };
    }

    public static Arity even() {
        return (methodName, params) -> {
            if (params.size() % 2 != 0) {
                throw new ArityException("wrong number of arguments in call to '" + methodName + "'. Expected even number of arguments, got " + params.size() + ".");
            }
        };
    }

    public static Arity between(int min, int max) {
        return (methodName, params) -> {
            if (params.size() < min || params.size() > max) {
                throw new ArityException("wrong number of arguments in call to '" + methodName + "'. Expected at least " + min + ", at max " + max + " arguments, got " + params.size() + ".");
            }
        };
    }
}

