/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class FilterAggregateTransposeRule
extends RelOptRule {
    public static final FilterAggregateTransposeRule INSTANCE = new FilterAggregateTransposeRule(Filter.class, RelFactories.LOGICAL_BUILDER, Aggregate.class);

    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelBuilderFactory builderFactory, Class<? extends Aggregate> aggregateClass) {
        this(FilterAggregateTransposeRule.operand(filterClass, FilterAggregateTransposeRule.operand(aggregateClass, FilterAggregateTransposeRule.any()), new RelOptRuleOperand[0]), builderFactory);
    }

    protected FilterAggregateTransposeRule(RelOptRuleOperand operand, RelBuilderFactory builderFactory) {
        super(operand, builderFactory, null);
    }

    @Deprecated
    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Aggregate> aggregateClass) {
        this(filterClass, RelBuilder.proto(Contexts.of((Object)filterFactory)), aggregateClass);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        Aggregate aggRel = (Aggregate)call.rel(1);
        List<RexNode> conditions = RelOptUtil.conjunctions(filterRel.getCondition());
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = aggRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        int j = 0;
        for (int i : aggRel.getGroupSet()) {
            adjustments[j] = i - j;
            ++j;
        }
        ArrayList<RexNode> pushedConditions = Lists.newArrayList();
        ArrayList<RexNode> remainingConditions = Lists.newArrayList();
        for (RexNode condition : conditions) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(condition);
            if (this.canPush(aggRel, rCols)) {
                pushedConditions.add(condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, aggRel.getInput(0).getRowType().getFieldList(), adjustments)));
                continue;
            }
            remainingConditions.add(condition);
        }
        RelBuilder builder = call.builder();
        RelNode rel = builder.push(aggRel.getInput()).filter(pushedConditions).build();
        if (rel == aggRel.getInput(0)) {
            return;
        }
        rel = aggRel.copy(aggRel.getTraitSet(), ImmutableList.of(rel));
        rel = builder.push(rel).filter(remainingConditions).build();
        call.transformTo(rel);
    }

    private boolean canPush(Aggregate aggregate, ImmutableBitSet rCols) {
        ImmutableBitSet groupKeys = ImmutableBitSet.range(0, aggregate.getGroupSet().cardinality());
        if (!groupKeys.contains(rCols)) {
            return false;
        }
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            for (ImmutableBitSet groupingSet : aggregate.getGroupSets()) {
                if (groupingSet.contains(rCols)) continue;
                return false;
            }
        }
        return true;
    }
}

