/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.metrics.NoopMetricCollector;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.kylin.cache.memcached.MemcachedMetrics;
import org.apache.kylin.common.KylinConfig;

public class MemcachedConnectionFactory
extends SpyObject
implements ConnectionFactory {
    private ConnectionFactory underlying;
    private Map<String, String> metricsConfig = KylinConfig.getInstanceFromEnv().getKylinMetricsConf();

    public MemcachedConnectionFactory(ConnectionFactory underlying) {
        this.underlying = underlying;
    }

    @Override
    public MetricType enableMetrics() {
        String metricType = this.metricsConfig.get("memcached.metricstype");
        return metricType == null ? DefaultConnectionFactory.DEFAULT_METRIC_TYPE : MetricType.valueOf(metricType.toUpperCase(Locale.ROOT));
    }

    @Override
    public MetricCollector getMetricCollector() {
        String enableMetrics = this.metricsConfig.get("memcached.enabled");
        if (this.enableMetrics().equals((Object)MetricType.OFF) || enableMetrics == null || "false".equalsIgnoreCase(enableMetrics)) {
            this.getLogger().debug("Memcached metrics collection disabled.");
            return new NoopMetricCollector();
        }
        this.getLogger().info("Memcached metrics collection enabled (Profile " + (Object)((Object)this.enableMetrics()) + ").");
        return new MemcachedMetrics();
    }

    @Override
    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return this.underlying.createConnection(addrs);
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        return this.underlying.createMemcachedNode(sa, c, bufSize);
    }

    @Override
    public BlockingQueue<Operation> createOperationQueue() {
        return this.underlying.createOperationQueue();
    }

    @Override
    public BlockingQueue<Operation> createReadOperationQueue() {
        return this.underlying.createReadOperationQueue();
    }

    @Override
    public BlockingQueue<Operation> createWriteOperationQueue() {
        return this.underlying.createWriteOperationQueue();
    }

    @Override
    public long getOpQueueMaxBlockTime() {
        return this.underlying.getOpQueueMaxBlockTime();
    }

    @Override
    public ExecutorService getListenerExecutorService() {
        return this.underlying.getListenerExecutorService();
    }

    @Override
    public boolean isDefaultExecutorService() {
        return this.underlying.isDefaultExecutorService();
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return this.underlying.createLocator(nodes);
    }

    @Override
    public OperationFactory getOperationFactory() {
        return this.underlying.getOperationFactory();
    }

    @Override
    public long getOperationTimeout() {
        return this.underlying.getOperationTimeout();
    }

    @Override
    public boolean isDaemon() {
        return this.underlying.isDaemon();
    }

    @Override
    public boolean useNagleAlgorithm() {
        return this.underlying.useNagleAlgorithm();
    }

    @Override
    public Collection<ConnectionObserver> getInitialObservers() {
        return this.underlying.getInitialObservers();
    }

    @Override
    public FailureMode getFailureMode() {
        return this.underlying.getFailureMode();
    }

    @Override
    public Transcoder<Object> getDefaultTranscoder() {
        return this.underlying.getDefaultTranscoder();
    }

    @Override
    public boolean shouldOptimize() {
        return this.underlying.shouldOptimize();
    }

    @Override
    public int getReadBufSize() {
        return this.underlying.getReadBufSize();
    }

    @Override
    public HashAlgorithm getHashAlg() {
        return this.underlying.getHashAlg();
    }

    @Override
    public long getMaxReconnectDelay() {
        return this.underlying.getMaxReconnectDelay();
    }

    @Override
    public AuthDescriptor getAuthDescriptor() {
        return this.underlying.getAuthDescriptor();
    }

    @Override
    public int getTimeoutExceptionThreshold() {
        return this.underlying.getTimeoutExceptionThreshold();
    }

    @Override
    public long getAuthWaitTime() {
        return this.underlying.getAuthWaitTime();
    }
}

