/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.SourceManager;

public class SnapshotCLI {
    public static void main(String[] args) throws IOException {
        if ("rebuild".equals(args[0])) {
            SnapshotCLI.rebuild(args[1], args[2], args[3]);
        }
    }

    private static void rebuild(String table, String overwriteUUID, String project) throws IOException {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        TableMetadataManager metaMgr = TableMetadataManager.getInstance(conf);
        SnapshotManager snapshotMgr = SnapshotManager.getInstance(conf);
        TableDesc tableDesc = metaMgr.getTableDesc(table, project);
        if (tableDesc == null) {
            throw new IllegalArgumentException("Not table found by " + table);
        }
        if (tableDesc.isView()) {
            throw new IllegalArgumentException("Build snapshot of hive view '" + table + "' not supported.");
        }
        SnapshotTable snapshot = snapshotMgr.rebuildSnapshot(SourceManager.createReadableTable(tableDesc, null), tableDesc, overwriteUUID);
        System.out.println("resource path updated: " + snapshot.getResourcePath());
    }
}

