/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;

public class ConvergeCuboidDataPartitioner
extends Partitioner<Text, Text>
implements Configurable {
    private static final HashFunction hashFunc = Hashing.murmur3_128();
    private Configuration conf;
    private boolean enableSharding;
    private long baseCuboidID;
    private int numReduceBaseCuboid;

    public int getPartition(Text key, Text value, int numReduceTasks) {
        long hash = hashFunc.hashBytes(key.getBytes()).asLong();
        long cuboidID = RowKeySplitter.getCuboidId(key.getBytes(), this.enableSharding);
        if (cuboidID == this.baseCuboidID) {
            return ConvergeCuboidDataPartitioner.getRemainder(hash, this.numReduceBaseCuboid);
        }
        return this.numReduceBaseCuboid + ConvergeCuboidDataPartitioner.getRemainder(hash, numReduceTasks - this.numReduceBaseCuboid);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String partiParam = conf.get("converge.cuboid.partition.param");
        String[] params = partiParam.split(",");
        Preconditions.checkArgument(params.length >= 3);
        this.enableSharding = Boolean.parseBoolean(params[0]);
        this.baseCuboidID = Long.parseLong(params[1]);
        this.numReduceBaseCuboid = Integer.parseInt(params[2]);
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static int getRemainder(long val, int base) {
        int rem = (int)val % base;
        return rem >= 0 ? rem : rem + base;
    }
}

