/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.MergeDictionaryMapper;
import org.apache.kylin.engine.mr.steps.MergeDictionaryReducer;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeDictionaryJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(MergeDictionaryJob.class);
    public static final Option OPTION_MERGE_SEGMENT_IDS;
    public static final Option OPTION_OUTPUT_PATH_DICT;
    public static final Option OPTION_OUTPUT_PATH_STAT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        try {
            Options options = new Options();
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_META_URL);
            options.addOption(OPTION_MERGE_SEGMENT_IDS);
            options.addOption(OPTION_OUTPUT_PATH_DICT);
            options.addOption(OPTION_OUTPUT_PATH_STAT);
            this.parseOptions(options, args);
            String segmentId = this.getOptionValue(OPTION_SEGMENT_ID);
            String segmentIds = this.getOptionValue(OPTION_MERGE_SEGMENT_IDS);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            String metaUrl = this.getOptionValue(OPTION_META_URL);
            String dictOutputPath = this.getOptionValue(OPTION_OUTPUT_PATH_DICT);
            String statOutputPath = this.getOptionValue(OPTION_OUTPUT_PATH_STAT);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeDesc cubeDesc = cube.getDescriptor();
            CubeSegment segment = cube.getSegmentById(segmentId);
            Segments<CubeSegment> mergingSeg = cube.getMergingSegments(segment);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.job.getConfiguration().set("cubename", cubeName);
            this.job.getConfiguration().set(OPTION_META_URL.getOpt(), metaUrl);
            this.job.getConfiguration().set(OPTION_SEGMENT_ID.getOpt(), segmentId);
            this.job.getConfiguration().set(OPTION_MERGE_SEGMENT_IDS.getOpt(), segmentIds);
            this.job.getConfiguration().set(OPTION_OUTPUT_PATH_STAT.getOpt(), statOutputPath);
            this.job.getConfiguration().set("num.map.tasks", String.valueOf(cubeDesc.getAllColumnsNeedDictionaryBuilt().size() + 1));
            this.job.setNumReduceTasks(1);
            this.setJobClasspath(this.job, cube.getConfig());
            this.attachSegmentsMetadataWithDict(mergingSeg, metaUrl);
            HadoopUtil.deletePath(this.job.getConfiguration(), new Path(dictOutputPath));
            this.job.setMapperClass(MergeDictionaryMapper.class);
            this.job.setReducerClass(MergeDictionaryReducer.class);
            this.job.setMapOutputKeyClass(IntWritable.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.setInputFormatClass(IndexArrInputFormat.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            SequenceFileOutputFormat.setOutputCompressionType((Job)this.job, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
            SequenceFileOutputFormat.setOutputPath((Job)this.job, (Path)new Path(dictOutputPath));
            logger.info("Starting: " + this.job.getJobName());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    static {
        OptionBuilder.withArgName((String)"segmentIds");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Merging Cube Segment Ids");
        OPTION_MERGE_SEGMENT_IDS = OptionBuilder.create((String)"segmentIds");
        OptionBuilder.withArgName((String)"dictOutputPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"merged dictionary resource path");
        OPTION_OUTPUT_PATH_DICT = OptionBuilder.create((String)"dictOutputPath");
        OptionBuilder.withArgName((String)"statOutputPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"merged statistics resource path");
        OPTION_OUTPUT_PATH_STAT = OptionBuilder.create((String)"statOutputPath");
    }

    static class IntInputSplit
    extends InputSplit
    implements Writable {
        private int index;

        public IntInputSplit() {
        }

        public IntInputSplit(int index) {
            this.index = index;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.index);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.index = dataInput.readInt();
        }

        public long getLength() throws IOException, InterruptedException {
            return 1L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public int getIndex() {
            return this.index;
        }
    }

    static class IndexArrInputFormat
    extends InputFormat<IntWritable, NullWritable> {
        IndexArrInputFormat() {
        }

        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            int numMapTasks = jobContext.getConfiguration().getInt("num.map.tasks", 0);
            ArrayList<InputSplit> inputSplits = Lists.newArrayListWithCapacity(numMapTasks);
            for (int i = 0; i < numMapTasks; ++i) {
                inputSplits.add(new IntInputSplit(i));
            }
            return inputSplits;
        }

        public RecordReader<IntWritable, NullWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return new RecordReader<IntWritable, NullWritable>(){
                private int index;
                private IntWritable key;
                private NullWritable value;

                public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                    IntInputSplit intInputSplit = (IntInputSplit)inputSplit;
                    this.index = intInputSplit.getIndex();
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    if (this.key == null) {
                        this.key = new IntWritable(this.index);
                        this.value = NullWritable.get();
                        return true;
                    }
                    return false;
                }

                public IntWritable getCurrentKey() throws IOException, InterruptedException {
                    return this.key;
                }

                public NullWritable getCurrentValue() throws IOException, InterruptedException {
                    return this.value;
                }

                public float getProgress() throws IOException, InterruptedException {
                    return 1.0f;
                }

                public void close() throws IOException {
                }
            };
        }
    }
}

