/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.dict.ShrunkenDictionary;
import org.apache.kylin.dict.ShrunkenDictionaryBuilder;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.BatchCubingJobBuilder2;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.BaseCuboidBuilder;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.NDCuboidBuilder;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.spark.KylinSparkJobListener;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCubingByLayer
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(SparkCubingByLayer.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_OUTPUT_PATH;
    public static final Option OPTION_INPUT_TABLE;
    public static final Option OPTION_INPUT_PATH;
    public static final Option OPTION_SHRUNK_INPUT_PATH;
    private Options options = new Options();
    private static final Iterable<Tuple2<ByteArray, Object[]>> EMTPY_ITERATOR;

    public SparkCubingByLayer() {
        this.options.addOption(OPTION_INPUT_TABLE);
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_OUTPUT_PATH);
        this.options.addOption(OPTION_SHRUNK_INPUT_PATH);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        BaseCuboidReducerFunction2 baseCuboidReducerFunction;
        JavaPairRDD encodedBaseRDD;
        String metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        String hiveTable = optionsHelper.getOptionValue(OPTION_INPUT_TABLE);
        String inputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH);
        String shrunkInputPath = optionsHelper.getOptionValue(OPTION_SHRUNK_INPUT_PATH);
        logger.info("shrunkInputPath is {}", (Object)shrunkInputPath);
        Class[] kryoClassArray = new Class[]{Class.forName("scala.reflect.ClassTag$$anon$1")};
        SparkConf conf = new SparkConf().setAppName("Cubing for:" + cubeName + " segment " + segmentId);
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.set("spark.kryo.registrator", "org.apache.kylin.engine.spark.KylinKryoRegistrator");
        conf.set("spark.kryo.registrationRequired", "true").registerKryoClasses(kryoClassArray);
        KylinSparkJobListener jobListener = new KylinSparkJobListener();
        JavaSparkContext sc = new JavaSparkContext(conf);
        sc.sc().addSparkListener((SparkListenerInterface)jobListener);
        HadoopUtil.deletePath(sc.hadoopConfiguration(), new Path(outputPath));
        SparkUtil.modifySparkHadoopConfiguration(sc.sc(), AbstractHadoopJob.loadKylinConfigFromHdfs(new SerializableConfiguration(sc.hadoopConfiguration()), metaUrl));
        if (shrunkInputPath != null) {
            sc.hadoopConfiguration().set("shrunkenDictPath", shrunkInputPath);
        }
        SerializableConfiguration sConf = new SerializableConfiguration(sc.hadoopConfiguration());
        KylinConfig envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
        CubeInstance cubeInstance = CubeManager.getInstance(envConfig).getCube(cubeName);
        CubeDesc cubeDesc = cubeInstance.getDescriptor();
        CubeSegment cubeSegment = cubeInstance.getSegmentById(segmentId);
        logger.info("RDD input path: {}", (Object)inputPath);
        logger.info("RDD Output path: {}", (Object)outputPath);
        Job job = Job.getInstance((Configuration)sConf.get());
        SparkUtil.setHadoopConfForCuboid(job, cubeSegment, metaUrl);
        int countMeasureIndex = 0;
        for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
            if (measureDesc.getFunction().isCount()) break;
            ++countMeasureIndex;
        }
        CubeStatsReader cubeStatsReader = new CubeStatsReader(cubeSegment, envConfig);
        boolean[] needAggr = new boolean[cubeDesc.getMeasures().size()];
        boolean allNormalMeasure = true;
        for (int i = 0; i < cubeDesc.getMeasures().size(); ++i) {
            needAggr[i] = !cubeDesc.getMeasures().get(i).getFunction().getMeasureType().onlyAggrInBaseCuboid();
            allNormalMeasure = allNormalMeasure && needAggr[i];
        }
        logger.info("All measure are normal (agg on all cuboids) ? : " + allNormalMeasure);
        StorageLevel storageLevel = StorageLevel.fromString((String)envConfig.getSparkStorageLevel());
        boolean isSequenceFile = "SEQUENCEFILE".equalsIgnoreCase(envConfig.getFlatTableStorageFormat());
        logger.info("isShrunkenDictFromGlobalEnabled  {}  shrunkInputPath is {}", (Object)cubeDesc.isShrunkenDictFromGlobalEnabled(), (Object)shrunkInputPath);
        JavaRDD recordInputRDD = null;
        if (cubeDesc.isShrunkenDictFromGlobalEnabled() && shrunkInputPath != null) {
            recordInputRDD = SparkUtil.hiveRecordInputRDD(isSequenceFile, sc, inputPath, hiveTable).cache();
            recordInputRDD.foreachPartition((VoidFunction)new CreateShrunkenDictionary(cubeName, segmentId, metaUrl, sConf));
            encodedBaseRDD = recordInputRDD.mapToPair((PairFunction)new EncodeBaseCuboid(cubeName, segmentId, metaUrl, sConf));
        } else {
            encodedBaseRDD = SparkUtil.hiveRecordInputRDD(isSequenceFile, sc, inputPath, hiveTable).mapToPair((PairFunction)new EncodeBaseCuboid(cubeName, segmentId, metaUrl, sConf));
        }
        Long totalCount = 0L;
        if (envConfig.isSparkSanityCheckEnabled()) {
            totalCount = encodedBaseRDD.count();
        }
        BaseCuboidReducerFunction2 reducerFunction2 = baseCuboidReducerFunction = new BaseCuboidReducerFunction2(cubeName, metaUrl, sConf);
        if (!allNormalMeasure) {
            reducerFunction2 = new CuboidReducerFunction2(cubeName, metaUrl, sConf, needAggr);
        }
        int totalLevels = cubeSegment.getCuboidScheduler().getBuildLevel();
        JavaPairRDD[] allRDDs = new JavaPairRDD[totalLevels + 1];
        int level = 0;
        int partition = SparkUtil.estimateLayerPartitionNum(level, cubeStatsReader, envConfig);
        allRDDs[0] = encodedBaseRDD.reduceByKey((Function2)baseCuboidReducerFunction, partition).persist(storageLevel);
        this.saveToHDFS((JavaPairRDD<ByteArray, Object[]>)allRDDs[0], metaUrl, cubeName, cubeSegment, outputPath, 0, job, envConfig);
        if (recordInputRDD != null) {
            recordInputRDD.unpersist();
        }
        CuboidFlatMap flatMapFunction = new CuboidFlatMap(cubeName, segmentId, metaUrl, sConf);
        for (level = 1; level <= totalLevels; ++level) {
            partition = SparkUtil.estimateLayerPartitionNum(level, cubeStatsReader, envConfig);
            allRDDs[level] = allRDDs[level - 1].flatMapToPair((PairFlatMapFunction)flatMapFunction).reduceByKey((Function2)reducerFunction2, partition).persist(storageLevel);
            if (envConfig.isSparkSanityCheckEnabled()) {
                this.sanityCheck((JavaPairRDD<ByteArray, Object[]>)allRDDs[level], totalCount, level, cubeStatsReader, countMeasureIndex);
            }
            this.saveToHDFS((JavaPairRDD<ByteArray, Object[]>)allRDDs[level], metaUrl, cubeName, cubeSegment, outputPath, level, job, envConfig);
            allRDDs[level - 1].unpersist(false);
        }
        allRDDs[totalLevels].unpersist(false);
        logger.info("Finished on calculating all level cuboids.");
        logger.info("HDFS: Number of bytes written=" + jobListener.metrics.getBytesWritten());
    }

    protected JavaPairRDD<ByteArray, Object[]> prepareOutput(JavaPairRDD<ByteArray, Object[]> rdd, KylinConfig config, CubeSegment segment, int level) {
        return rdd;
    }

    protected void saveToHDFS(JavaPairRDD<ByteArray, Object[]> rdd, final String metaUrl, final String cubeName, CubeSegment cubeSeg, String hdfsBaseLocation, int level, Job job, KylinConfig kylinConfig) throws Exception {
        String cuboidOutputPath = BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(hdfsBaseLocation, level);
        final SerializableConfiguration sConf = new SerializableConfiguration(job.getConfiguration());
        IMROutput2.IMROutputFormat outputFormat = MRUtil.getBatchCubingOutputSide2(cubeSeg).getOutputFormat();
        outputFormat.configureJobOutput(job, cuboidOutputPath, cubeSeg, cubeSeg.getCuboidScheduler(), level);
        this.prepareOutput(rdd, kylinConfig, cubeSeg, level).mapToPair((PairFunction)new PairFunction<Tuple2<ByteArray, Object[]>, Text, Text>(){
            private volatile transient boolean initialized = false;
            BufferedMeasureCodec codec;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public Tuple2<Text, Text> call(Tuple2<ByteArray, Object[]> tuple2) throws Exception {
                block12: {
                    if (this.initialized) break;
                    Class<SparkCubingByLayer> clazz = SparkCubingByLayer.class;
                    // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingByLayer.class
                    if (!this.initialized) {
                        Throwable throwable;
                        KylinConfig.SetAndUnsetThreadLocalConfig autoUnset;
                        block13: {
                            KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
                            autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kylinConfig);
                            throwable = null;
                            CubeDesc desc = CubeDescManager.getInstance(kylinConfig).getCubeDesc(cubeName);
                            this.codec = new BufferedMeasureCodec(desc.getMeasures());
                            this.initialized = true;
                            if (autoUnset == null) break block12;
                            if (throwable == null) break block13;
                            try {
                                autoUnset.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block12;
                        }
                        autoUnset.close();
                        break block12;
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (autoUnset == null) throw throwable4;
                                if (throwable == null) {
                                    autoUnset.close();
                                    throw throwable4;
                                }
                                try {
                                    autoUnset.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                    }
                }
                // MONITOREXIT : clazz
                ByteBuffer valueBuf = this.codec.encode((Object[])tuple2._2());
                Text textResult = new Text();
                textResult.set(valueBuf.array(), 0, valueBuf.position());
                return new Tuple2((Object)new Text(((ByteArray)tuple2._1()).array()), (Object)textResult);
            }
        }).saveAsNewAPIHadoopDataset(job.getConfiguration());
        logger.info("Persisting RDD for level " + level + " into " + cuboidOutputPath);
    }

    protected void sanityCheck(JavaPairRDD<ByteArray, Object[]> rdd, Long totalCount, int thisLevel, CubeStatsReader cubeStatsReader, int countMeasureIndex) {
        int thisCuboidNum = cubeStatsReader.getCuboidsByLayer(thisLevel).size();
        Long count2 = this.getRDDCountSum(rdd, countMeasureIndex);
        if (count2 != totalCount * (long)thisCuboidNum) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Sanity check failed, level %s, total count(*) is %s; cuboid number %s", thisLevel, count2, thisCuboidNum));
        }
        logger.info("sanity check success for level " + thisLevel + ", count(*) is " + count2 / (long)thisCuboidNum);
    }

    private Long getRDDCountSum(JavaPairRDD<ByteArray, Object[]> rdd, final int countMeasureIndex) {
        final ByteArray ONE = new ByteArray();
        Long count = (Long)((Tuple2)rdd.mapValues((Function)new Function<Object[], Long>(){

            public Long call(Object[] objects) throws Exception {
                return (Long)objects[countMeasureIndex];
            }
        }).reduce((Function2)new Function2<Tuple2<ByteArray, Long>, Tuple2<ByteArray, Long>, Tuple2<ByteArray, Long>>(){

            public Tuple2<ByteArray, Long> call(Tuple2<ByteArray, Long> longTuple2, Tuple2<ByteArray, Long> longTuple22) throws Exception {
                return new Tuple2((Object)ONE, (Object)((Long)longTuple2._2() + (Long)longTuple22._2()));
            }
        }))._2();
        return count;
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segmentId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"hiveTable");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Hive Intermediate Table");
        OPTION_INPUT_TABLE = OptionBuilder.create((String)"hiveTable");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Hive Intermediate Table PATH");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"shrunkenDictPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"shrunken Dictionary Path");
        OPTION_SHRUNK_INPUT_PATH = OptionBuilder.create((String)"shrunkenDictPath");
        EMTPY_ITERATOR = new ArrayList<Tuple2<ByteArray, Object[]>>(0);
    }

    public static class CreateShrunkenDictionary
    implements VoidFunction<Iterator<String[]>> {
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private SerializableConfiguration scof;
        private CubeSegment cubeSeg;
        private List<TblColRef> globalColumns;
        private int[] globalColumnIndex;
        private List<Set<String>> globalColumnValues;
        private volatile transient boolean initialized = false;
        private String splitKey;

        public CreateShrunkenDictionary(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.scof = conf;
            this.segmentId = segmentId;
            this.metaUrl = metaUrl;
        }

        public void init() {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.scof, this.metaUrl);
            CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            this.cubeSeg = cubeInstance.getSegmentById(this.segmentId);
            CubeJoinedFlatTableEnrich intermediateTableDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc(this.cubeSeg), cubeDesc);
            this.globalColumns = cubeDesc.getAllGlobalDictColumnsNeedBuilt();
            this.globalColumnIndex = new int[this.globalColumns.size()];
            this.globalColumnValues = Lists.newArrayListWithExpectedSize(this.globalColumns.size());
            this.splitKey = String.valueOf(TaskContext.getPartitionId());
            for (int i = 0; i < this.globalColumns.size(); ++i) {
                int columnIndexOnFlatTbl;
                TblColRef colRef = this.globalColumns.get(i);
                this.globalColumnIndex[i] = columnIndexOnFlatTbl = intermediateTableDesc.getColumnIndex(colRef);
                this.globalColumnValues.add(Sets.newHashSet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void call(Iterator<String[]> iter) throws Exception {
            int i;
            ShrunkenDictionary.StringValueSerializer strValueSerializer;
            Map<TblColRef, Dictionary<String>> globalDictionaryMap;
            Path outputDirBase;
            FileSystem fs;
            if (!this.initialized) {
                Class<CreateShrunkenDictionary> clazz = CreateShrunkenDictionary.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingByLayer$CreateShrunkenDictionary.class
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
                // MONITOREXIT : clazz
            }
            block11: while (true) {
                if (!iter.hasNext()) {
                    fs = FileSystem.get((Configuration)this.scof.get());
                    outputDirBase = new Path(this.scof.get().get("shrunkenDictPath"));
                    globalDictionaryMap = this.cubeSeg.buildGlobalDictionaryMap(this.globalColumns.size());
                    strValueSerializer = new ShrunkenDictionary.StringValueSerializer();
                    i = 0;
                    break;
                }
                String[] rowArray = iter.next();
                int i2 = 0;
                while (true) {
                    if (i2 >= this.globalColumnIndex.length) continue block11;
                    String fieldValue = rowArray[this.globalColumnIndex[i2]];
                    if (fieldValue != null) {
                        this.globalColumnValues.get(i2).add(fieldValue);
                    }
                    ++i2;
                }
                break;
            }
            while (i < this.globalColumns.size()) {
                ArrayList<String> colDistinctValues = Lists.newArrayList((Iterable)this.globalColumnValues.get(i));
                if (colDistinctValues.size() != 0) {
                    Collections.sort(colDistinctValues);
                    ShrunkenDictionaryBuilder<String> dictBuilder = new ShrunkenDictionaryBuilder<String>(globalDictionaryMap.get(this.globalColumns.get(i)));
                    for (String colValue : colDistinctValues) {
                        dictBuilder.addValue(colValue);
                    }
                    ShrunkenDictionary<String> shrunkenDict = dictBuilder.build(strValueSerializer);
                    Path colDictDir = new Path(outputDirBase, this.globalColumns.get(i).getIdentity());
                    if (!fs.exists(colDictDir)) {
                        fs.mkdirs(colDictDir);
                    }
                    Path shrunkenDictPath = new Path(colDictDir, this.splitKey);
                    try (FSDataOutputStream dos = fs.create(shrunkenDictPath);){
                        logger.info("Write Shrunken dictionary to {} success", (Object)shrunkenDictPath);
                        ((Dictionary)shrunkenDict).write((DataOutput)dos);
                    }
                }
                ++i;
            }
        }
    }

    public static class CuboidFlatMap
    implements PairFlatMapFunction<Tuple2<ByteArray, Object[]>, ByteArray, Object[]> {
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private CubeSegment cubeSegment;
        private CubeDesc cubeDesc;
        private NDCuboidBuilder ndCuboidBuilder;
        private RowKeySplitter rowKeySplitter;
        private volatile transient boolean initialized = false;
        private SerializableConfiguration conf;

        public CuboidFlatMap(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void init() {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                this.cubeSegment = cubeInstance.getSegmentById(this.segmentId);
                this.cubeDesc = cubeInstance.getDescriptor();
                this.ndCuboidBuilder = new NDCuboidBuilder(this.cubeSegment, new RowKeyEncoderProvider(this.cubeSegment));
                this.rowKeySplitter = new RowKeySplitter(this.cubeSegment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Iterator<Tuple2<ByteArray, Object[]>> call(Tuple2<ByteArray, Object[]> tuple2) throws Exception {
            if (!this.initialized) {
                Class<SparkCubingByLayer> clazz = SparkCubingByLayer.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingByLayer.class
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
                // MONITOREXIT : clazz
            }
            byte[] key = ((ByteArray)tuple2._1()).array();
            long cuboidId = this.rowKeySplitter.parseCuboid(key);
            List<Long> myChildren = this.cubeSegment.getCuboidScheduler().getSpanningCuboid(cuboidId);
            if (myChildren == null) return EMTPY_ITERATOR.iterator();
            if (myChildren.size() == 0) {
                return EMTPY_ITERATOR.iterator();
            }
            this.rowKeySplitter.split(key);
            Cuboid parentCuboid = Cuboid.findForMandatory(this.cubeDesc, cuboidId);
            ArrayList<Tuple2> tuples = new ArrayList<Tuple2>(myChildren.size());
            Iterator<Long> iterator = myChildren.iterator();
            while (iterator.hasNext()) {
                Long child = iterator.next();
                Cuboid childCuboid = Cuboid.findForMandatory(this.cubeDesc, child);
                ByteArray result = this.ndCuboidBuilder.buildKey2(parentCuboid, childCuboid, this.rowKeySplitter.getSplitBuffers());
                tuples.add(new Tuple2((Object)result, tuple2._2()));
            }
            return tuples.iterator();
        }
    }

    public static class CuboidReducerFunction2
    extends BaseCuboidReducerFunction2 {
        private boolean[] needAggr;

        public CuboidReducerFunction2(String cubeName, String metaUrl, SerializableConfiguration conf, boolean[] needAggr) {
            super(cubeName, metaUrl, conf);
            this.needAggr = needAggr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public Object[] call(Object[] input1, Object[] input2) throws Exception {
            if (!this.initialized) {
                Class<SparkCubingByLayer> clazz = SparkCubingByLayer.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingByLayer.class
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
                // MONITOREXIT : clazz
            }
            Object[] result = new Object[this.measureNum];
            this.aggregators.aggregate(input1, input2, result, this.needAggr);
            return result;
        }
    }

    public static class BaseCuboidReducerFunction2
    implements Function2<Object[], Object[], Object[]> {
        protected String cubeName;
        protected String metaUrl;
        protected CubeDesc cubeDesc;
        protected int measureNum;
        protected MeasureAggregators aggregators;
        protected volatile transient boolean initialized = false;
        protected SerializableConfiguration conf;

        public BaseCuboidReducerFunction2(String cubeName, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void init() {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                this.cubeDesc = cubeInstance.getDescriptor();
                this.aggregators = new MeasureAggregators(this.cubeDesc.getMeasures());
                this.measureNum = this.cubeDesc.getMeasures().size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Object[] call(Object[] input1, Object[] input2) throws Exception {
            if (!this.initialized) {
                Class<SparkCubingByLayer> clazz = SparkCubingByLayer.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingByLayer.class
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
                // MONITOREXIT : clazz
            }
            Object[] result = new Object[this.measureNum];
            this.aggregators.aggregate(input1, input2, result);
            return result;
        }
    }

    public static class EncodeBaseCuboid
    implements PairFunction<String[], ByteArray, Object[]> {
        private volatile transient boolean initialized = false;
        private BaseCuboidBuilder baseCuboidBuilder = null;
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private SerializableConfiguration conf;

        public EncodeBaseCuboid(String cubeName, String segmentId, String metaurl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.metaUrl = metaurl;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Tuple2<ByteArray, Object[]> call(String[] rowArray) throws Exception {
            block14: {
                if (this.initialized) break;
                Class<SparkCubingByLayer> clazz = SparkCubingByLayer.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingByLayer.class
                if (!this.initialized) {
                    Throwable throwable;
                    KylinConfig.SetAndUnsetThreadLocalConfig autoUnset;
                    block15: {
                        KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
                        autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);
                        throwable = null;
                        CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                        CubeDesc cubeDesc = cubeInstance.getDescriptor();
                        CubeSegment cubeSegment = cubeInstance.getSegmentById(this.segmentId);
                        CubeJoinedFlatTableEnrich interDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc(cubeSegment), cubeDesc);
                        long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
                        Cuboid baseCuboid = Cuboid.findForMandatory(cubeDesc, baseCuboidId);
                        String splitKey = String.valueOf(TaskContext.getPartitionId());
                        try {
                            this.baseCuboidBuilder = new BaseCuboidBuilder(kConfig, cubeDesc, cubeSegment, interDesc, AbstractRowKeyEncoder.createInstance(cubeSegment, baseCuboid), MeasureIngester.create(cubeDesc.getMeasures()), SparkUtil.getDictionaryMap(cubeSegment, splitKey, this.conf.get()));
                        }
                        catch (IOException e) {
                            logger.error("Fail to get shrunk dict");
                            e.printStackTrace();
                        }
                        this.initialized = true;
                        if (autoUnset == null) break block14;
                        if (throwable == null) break block15;
                        try {
                            autoUnset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block14;
                    }
                    autoUnset.close();
                    break block14;
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (autoUnset == null) throw throwable4;
                            if (throwable == null) {
                                autoUnset.close();
                                throw throwable4;
                            }
                            try {
                                autoUnset.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                }
            }
            // MONITOREXIT : clazz
            this.baseCuboidBuilder.resetAggrs();
            byte[] rowKey = this.baseCuboidBuilder.buildKey(rowArray);
            Object[] result = this.baseCuboidBuilder.buildValueObjects(rowArray);
            return new Tuple2((Object)new ByteArray(rowKey), (Object)result);
        }
    }
}

