/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTFunctionScanner
implements IGTScanner {
    private static final Logger logger = LoggerFactory.getLogger(GTFunctionScanner.class);
    protected IGTScanner rawScanner;
    private final ImmutableBitSet rtAggrMetrics;
    private final Map<Integer, TupleExpression> tupleExpressionMap;
    private final IEvaluatableTuple oneTuple;
    private final IFilterCodeSystem<ByteArray> filterCodeSystem;
    private GTRecord next = null;

    protected GTFunctionScanner(IGTScanner rawScanner, GTScanRequest req) {
        this.rawScanner = rawScanner;
        this.tupleExpressionMap = req.getTupleExpressionMap();
        this.rtAggrMetrics = req.getRtAggrMetrics();
        this.oneTuple = new IEvaluatableTuple(){

            @Override
            public Object getValue(TblColRef col) {
                int idx = col.getColumnDesc().getZeroBasedIndex();
                return GTFunctionScanner.this.rtAggrMetrics.get(idx) ? GTFunctionScanner.this.next.decodeValue(idx) : GTFunctionScanner.this.next.get(idx);
            }
        };
        this.filterCodeSystem = GTUtil.wrap(this.getInfo().codeSystem.getComparator());
    }

    @Override
    public GTInfo getInfo() {
        return this.rawScanner.getInfo();
    }

    @Override
    public void close() throws IOException {
        this.rawScanner.close();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        return new Iterator<GTRecord>(){
            private Iterator<GTRecord> inputIterator;
            {
                this.inputIterator = GTFunctionScanner.this.rawScanner.iterator();
            }

            @Override
            public boolean hasNext() {
                if (GTFunctionScanner.this.next != null) {
                    return true;
                }
                if (this.inputIterator.hasNext()) {
                    GTFunctionScanner.this.next = this.inputIterator.next();
                    this.calculateDynamics();
                    return true;
                }
                return false;
            }

            @Override
            public GTRecord next() {
                if (GTFunctionScanner.this.next == null) {
                    this.hasNext();
                    if (GTFunctionScanner.this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                GTRecord result = GTFunctionScanner.this.next;
                GTFunctionScanner.this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void calculateDynamics() {
                Iterator iterator = GTFunctionScanner.this.tupleExpressionMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int c = (Integer)iterator.next();
                    TupleExpression tupleExpr = (TupleExpression)GTFunctionScanner.this.tupleExpressionMap.get(c);
                    Object rtResult = tupleExpr.calculate(GTFunctionScanner.this.oneTuple, GTFunctionScanner.this.filterCodeSystem);
                    GTFunctionScanner.this.next.setValue(c, rtResult);
                }
            }
        };
    }
}

