/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.metadata.filter.FilterOptimizeTransformer;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.IOptimizeableTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class LogicalTupleFilter
extends TupleFilter
implements IOptimizeableTupleFilter {
    public LogicalTupleFilter(TupleFilter.FilterOperatorEnum op) {
        super(new ArrayList<TupleFilter>(2), op);
        boolean opGood;
        boolean bl = opGood = op == TupleFilter.FilterOperatorEnum.AND || op == TupleFilter.FilterOperatorEnum.OR || op == TupleFilter.FilterOperatorEnum.NOT;
        if (!opGood) {
            throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)op));
        }
    }

    private LogicalTupleFilter(List<TupleFilter> filters, TupleFilter.FilterOperatorEnum op) {
        super(filters, op);
    }

    private void reinitWithChildren(List<TupleFilter> newTupleFilter) {
        this.children.clear();
        this.addChildren(newTupleFilter);
    }

    @Override
    public TupleFilter copy() {
        LinkedList<TupleFilter> cloneChildren = new LinkedList<TupleFilter>(this.children);
        LogicalTupleFilter cloneTuple = new LogicalTupleFilter(cloneChildren, this.operator);
        return cloneTuple;
    }

    @Override
    public TupleFilter reverse() {
        switch (this.operator) {
            case NOT: {
                throw new IllegalStateException("NOT will be replaced in org.apache.kylin.query.relnode.OLAPFilterRel.TupleFilterVisitor");
            }
            case AND: 
            case OR: {
                LogicalTupleFilter reverse = new LogicalTupleFilter((TupleFilter.FilterOperatorEnum)((Object)REVERSE_OP_MAP.get((Object)this.operator)));
                for (TupleFilter child : this.children) {
                    reverse.addChild(child.reverse());
                }
                return reverse;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return (Object)((Object)this.operator) + " " + this.children;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        switch (this.operator) {
            case AND: {
                return this.evalAnd(tuple, cs);
            }
            case OR: {
                return this.evalOr(tuple, cs);
            }
            case NOT: {
                return this.evalNot(tuple, cs);
            }
        }
        return false;
    }

    private boolean evalAnd(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        for (TupleFilter filter : this.children) {
            if (filter.evaluate(tuple, cs)) continue;
            return false;
        }
        return true;
    }

    private boolean evalOr(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        for (TupleFilter filter : this.children) {
            if (!filter.evaluate(tuple, cs)) continue;
            return true;
        }
        return false;
    }

    private boolean evalNot(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return !((TupleFilter)this.children.get(0)).evaluate(tuple, cs);
    }

    @Override
    public Collection<?> getValues() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEvaluable() {
        switch (this.operator) {
            case NOT: {
                for (TupleFilter child : this.children) {
                    if (TupleFilter.isEvaluableRecursively(child)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (TupleFilter child : this.children) {
                    if (TupleFilter.isEvaluableRecursively(child)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public TupleFilter acceptOptimizeTransformer(FilterOptimizeTransformer transformer) {
        ArrayList<TupleFilter> newChildren = Lists.newArrayList();
        for (TupleFilter tupleFilter : this.getChildren()) {
            if (tupleFilter instanceof IOptimizeableTupleFilter) {
                newChildren.add(((IOptimizeableTupleFilter)((Object)tupleFilter)).acceptOptimizeTransformer(transformer));
                continue;
            }
            newChildren.add(tupleFilter);
        }
        this.reinitWithChildren(newChildren);
        return transformer.visit(this);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LogicalTupleFilter)) {
            return false;
        }
        LogicalTupleFilter otherFilter = (LogicalTupleFilter)other;
        if (otherFilter.operator != this.operator || otherFilter.children.size() != this.children.size()) {
            return false;
        }
        for (int i = 0; i < otherFilter.children.size(); ++i) {
            if (((TupleFilter)otherFilter.children.get(i)).equals(this.children.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return (this.operator == null ? 0 : this.operator.hashCode()) + 31 * this.children.hashCode();
    }
}

