/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;

public class RecordEventTimeDetail {
    private static final TimeZone timeZone;
    private static final ThreadLocal<SimpleDateFormat> dateFormatThreadLocal;
    private static final ThreadLocal<SimpleDateFormat> timeFormatThreadLocal;
    public final String year_begin_date;
    public final String month_begin_date;
    public final String date;
    public final String time;
    public final int hour;
    public final int minute;
    public final int second;
    public final String week_begin_date;

    public RecordEventTimeDetail(long timeStamp) {
        SimpleDateFormat timeFormat;
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(timeStamp);
        SimpleDateFormat dateFormat = dateFormatThreadLocal.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
            dateFormat.setTimeZone(timeZone);
            dateFormatThreadLocal.set(dateFormat);
        }
        if ((timeFormat = timeFormatThreadLocal.get()) == null) {
            timeFormat = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
            timeFormat.setTimeZone(timeZone);
            timeFormatThreadLocal.set(timeFormat);
        }
        String yearStr = String.format(Locale.ROOT, "%04d", calendar.get(1));
        String monthStr = String.format(Locale.ROOT, "%02d", calendar.get(2) + 1);
        this.year_begin_date = yearStr + "-01-01";
        this.month_begin_date = yearStr + "-" + monthStr + "-01";
        this.date = dateFormat.format(calendar.getTime());
        this.time = timeFormat.format(calendar.getTime());
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        long timeStampForWeekBegin = timeStamp;
        calendar.setTimeInMillis(timeStampForWeekBegin -= 86400000L * (long)(calendar.get(7) - 1));
        this.week_begin_date = dateFormat.format(calendar.getTime());
    }

    static {
        dateFormatThreadLocal = new ThreadLocal();
        timeFormatThreadLocal = new ThreadLocal();
        timeZone = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getKylinMetricsEventTimeZone());
    }
}

