/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class KVSortReducerWithDupKeyCheck
extends KeyValueSortReducer {
    protected void reduce(ImmutableBytesWritable row, Iterable<KeyValue> kvs, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<KeyValue> map = new TreeSet<KeyValue>((Comparator<KeyValue>)KeyValue.COMPARATOR);
        TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (KeyValue kv : kvs) {
            byte[] qualifier = CellUtil.cloneQualifier((Cell)kv);
            if (qualifierSet.contains(qualifier)) {
                throw new IllegalStateException("there is duplicate key:" + row);
            }
            qualifierSet.add(qualifier);
            try {
                map.add(kv.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new IOException(e);
            }
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (KeyValue kv : map) {
            context.write((Object)row, (Object)kv);
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

