/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.BulkLoadJob;
import org.apache.kylin.storage.hbase.steps.CreateHTableJob;
import org.apache.kylin.storage.hbase.steps.HDFSPathGarbageCollectionStep;
import org.apache.kylin.storage.hbase.steps.HFileDistcpJob;
import org.apache.kylin.storage.hbase.steps.MergeGCStep;

public abstract class HBaseJobSteps
extends JobBuilderSupport {
    public HBaseJobSteps(CubeSegment seg) {
        super(seg, null);
    }

    public HadoopShellExecutable createCreateHTableStep(String jobId) {
        return this.createCreateHTableStep(jobId, CuboidModeEnum.CURRENT);
    }

    public HadoopShellExecutable createCreateHTableStep(String jobId, CuboidModeEnum cuboidMode) {
        HadoopShellExecutable createHtableStep = new HadoopShellExecutable();
        createHtableStep.setName("Create HTable");
        StringBuilder cmd = new StringBuilder();
        HBaseJobSteps.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        HBaseJobSteps.appendExecCmdParameters(cmd, "segmentId", this.seg.getUuid());
        HBaseJobSteps.appendExecCmdParameters(cmd, "partitions", this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000");
        String partitionOutputPath = null;
        partitionOutputPath = this.seg.getConfig().isHFileDistCP() ? this.getRealizationRootPath(jobId) + "/rowkey_stats/part-r-00000_hfile" : this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000";
        HBaseJobSteps.appendExecCmdParameters(cmd, "partitions", partitionOutputPath);
        HBaseJobSteps.appendExecCmdParameters(cmd, "cuboidMode", cuboidMode.toString());
        HBaseJobSteps.appendExecCmdParameters(cmd, "hbaseConfPath", this.getHBaseConfFilePath(jobId));
        createHtableStep.setJobParams(cmd.toString());
        createHtableStep.setJobClass(CreateHTableJob.class);
        return createHtableStep;
    }

    public AbstractExecutable createDistcpHFileStep(String jobId) {
        String inputPath = this.getRealizationRootPath(jobId) + "/hfile";
        MapReduceExecutable createHFilesStep = new MapReduceExecutable();
        createHFilesStep.setName("HFile Distcp To HBase");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseJobSteps.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        HBaseJobSteps.appendExecCmdParameters(cmd, "input", inputPath);
        HBaseJobSteps.appendExecCmdParameters(cmd, "output", this.getHFilePath(jobId));
        HBaseJobSteps.appendExecCmdParameters(cmd, "htablename", this.seg.getStorageLocationIdentifier());
        HBaseJobSteps.appendExecCmdParameters(cmd, "jobname", "Kylin_HFile_Distcp_" + this.seg.getRealization().getName() + "_Step");
        createHFilesStep.setMapReduceParams(cmd.toString());
        createHFilesStep.setMapReduceJobClass(HFileDistcpJob.class);
        createHFilesStep.setCounterSaveAs(",,byteSizeBytes");
        return createHFilesStep;
    }

    public MapReduceExecutable createMergeCuboidDataStep(CubeSegment seg, List<CubeSegment> mergingSegments, String jobID, Class<? extends AbstractHadoopJob> clazz) {
        ArrayList<String> mergingCuboidPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingCuboidPaths.add(this.getCuboidRootPath(merging) + "*");
        }
        String formattedPath = StringUtil.join(mergingCuboidPaths, ",");
        String outputPath = this.getCuboidRootPath(jobID);
        MapReduceExecutable mergeCuboidDataStep = new MapReduceExecutable();
        mergeCuboidDataStep.setName("Merge Cuboid Data");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseJobSteps.appendExecCmdParameters(cmd, "cubename", seg.getCubeInstance().getName());
        HBaseJobSteps.appendExecCmdParameters(cmd, "segmentId", seg.getUuid());
        HBaseJobSteps.appendExecCmdParameters(cmd, "input", formattedPath);
        HBaseJobSteps.appendExecCmdParameters(cmd, "output", outputPath);
        HBaseJobSteps.appendExecCmdParameters(cmd, "jobname", "Kylin_Merge_Cuboid_" + seg.getCubeInstance().getName() + "_Step");
        mergeCuboidDataStep.setMapReduceParams(cmd.toString());
        mergeCuboidDataStep.setMapReduceJobClass(clazz);
        return mergeCuboidDataStep;
    }

    public abstract AbstractExecutable createConvertCuboidToHfileStep(String var1);

    public HadoopShellExecutable createBulkLoadStep(String jobId) {
        HadoopShellExecutable bulkLoadStep = new HadoopShellExecutable();
        bulkLoadStep.setName("Load HFile to HBase Table");
        StringBuilder cmd = new StringBuilder();
        HBaseJobSteps.appendExecCmdParameters(cmd, "input", this.getHFilePath(jobId));
        HBaseJobSteps.appendExecCmdParameters(cmd, "htablename", this.seg.getStorageLocationIdentifier());
        HBaseJobSteps.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        bulkLoadStep.setJobParams(cmd.toString());
        bulkLoadStep.setJobClass(BulkLoadJob.class);
        return bulkLoadStep;
    }

    public List<CubeSegment> getOptimizeSegments() {
        CubeInstance cube = (CubeInstance)this.seg.getRealization();
        ArrayList<CubeSegment> newSegments = Lists.newArrayList(cube.getSegments(SegmentStatusEnum.READY_PENDING));
        ArrayList<CubeSegment> oldSegments = Lists.newArrayListWithExpectedSize(newSegments.size());
        for (CubeSegment segment : newSegments) {
            oldSegments.add(cube.getOriginalSegmentToOptimize(segment));
        }
        return oldSegments;
    }

    public List<String> getOptimizeHTables() {
        return this.getOldHTables(this.getOptimizeSegments());
    }

    public List<String> getOldHTables(List<CubeSegment> oldSegments) {
        ArrayList<String> oldHTables = Lists.newArrayListWithExpectedSize(oldSegments.size());
        for (CubeSegment segment : oldSegments) {
            oldHTables.add(segment.getStorageLocationIdentifier());
        }
        return oldHTables;
    }

    public List<String> getMergingHTables() {
        Segments<CubeSegment> mergingSegments = ((CubeInstance)this.seg.getRealization()).getMergingSegments(this.seg);
        Preconditions.checkState(mergingSegments.size() > 1, "there should be more than 2 segments to merge, target segment " + this.seg);
        return this.getOldHTables(mergingSegments);
    }

    public List<String> getRefreshingHTables() {
        CubeSegment refreshingSegment = ((CubeInstance)this.seg.getRealization()).getOriginalSegmentToRefresh(this.seg);
        return this.getOldHTables(Collections.singletonList(refreshingSegment));
    }

    public List<String> getRefreshingHDFSPaths() {
        CubeSegment refreshingSegment = ((CubeInstance)this.seg.getRealization()).getOriginalSegmentToRefresh(this.seg);
        return this.getOldHDFSPaths(Collections.singletonList(refreshingSegment));
    }

    public List<String> getMergingHDFSPaths() {
        Segments<CubeSegment> mergingSegments = ((CubeInstance)this.seg.getRealization()).getMergingSegments(this.seg);
        Preconditions.checkState(mergingSegments.size() > 1, "there should be more than 2 segments to merge, target segment " + this.seg);
        ArrayList<String> mergingHDFSPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingHDFSPaths.add(this.getJobWorkingDir(merging.getLastBuildJobID()));
        }
        return mergingHDFSPaths;
    }

    public List<String> getOptimizeHDFSPaths() {
        return this.getOldHDFSPaths(this.getOptimizeSegments());
    }

    public List<String> getOldHDFSPaths(List<CubeSegment> oldSegments) {
        ArrayList<String> oldHDFSPaths = Lists.newArrayListWithExpectedSize(oldSegments.size());
        for (CubeSegment oldSegment : oldSegments) {
            oldHDFSPaths.add(this.getJobWorkingDir(oldSegment.getLastBuildJobID()));
        }
        return oldHDFSPaths;
    }

    public String getHFilePath(String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName() + "/hfile/");
    }

    public String getRowkeyDistributionOutputPath(String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName() + "/rowkey_stats");
    }

    public void addOptimizeGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.add(this.getOptimizationRootPath(jobId));
        HDFSPathGarbageCollectionStep step = this.createHDFSPathGCStep(toDeletePaths, jobId);
        jobFlow.addTask(step);
    }

    public void addCheckpointGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        MergeGCStep hBaseGCStep = this.createHBaseGCStep(this.getOptimizeHTables());
        jobFlow.addTask(hBaseGCStep);
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.addAll(this.getOptimizeHDFSPaths());
        HDFSPathGarbageCollectionStep step = this.createHDFSPathGCStep(toDeletePaths, jobId);
        jobFlow.addTask(step);
    }

    public void addMergingGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        MergeGCStep hBaseGCStep = this.createHBaseGCStep(this.getMergingHTables());
        jobFlow.addTask(hBaseGCStep);
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.addAll(this.getMergingHDFSPaths());
        toDeletePaths.add(this.getHFilePath(jobId));
        HDFSPathGarbageCollectionStep step = this.createHDFSPathGCStep(toDeletePaths, jobId);
        jobFlow.addTask(step);
    }

    public void addCubingGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.add(this.getFactDistinctColumnsPath(jobId));
        toDeletePaths.add(this.getHFilePath(jobId));
        toDeletePaths.add(this.getShrunkenDictionaryPath(jobId));
        CubeSegment oldSegment = ((CubeInstance)this.seg.getRealization()).getOriginalSegmentToRefresh(this.seg);
        if (oldSegment != null && KylinConfig.getInstanceFromEnv().cleanStorageAfterDelOperation()) {
            toDeletePaths.addAll(this.getRefreshingHDFSPaths());
            MergeGCStep hBaseGCStep = this.createHBaseGCStep(this.getRefreshingHTables());
            jobFlow.addTask(hBaseGCStep);
        }
        HDFSPathGarbageCollectionStep step = this.createHDFSPathGCStep(toDeletePaths, jobId);
        jobFlow.addTask(step);
    }

    public MergeGCStep createHBaseGCStep(List<String> toDropHTables) {
        MergeGCStep hBaseGCStep = new MergeGCStep();
        hBaseGCStep.setName("Garbage Collection on HBase");
        hBaseGCStep.setOldHTables(toDropHTables);
        return hBaseGCStep;
    }

    public HDFSPathGarbageCollectionStep createHDFSPathGCStep(List<String> toDeletePaths, String jobId) {
        HDFSPathGarbageCollectionStep hdfsGCStep = new HDFSPathGarbageCollectionStep();
        hdfsGCStep.setName("Garbage Collection on HDFS");
        hdfsGCStep.setDeletePaths(toDeletePaths);
        hdfsGCStep.setJobId(jobId);
        return hdfsGCStep;
    }
}

