/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.model;

import java.util.Set;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.model.Node;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ReplicaSet {
    @JsonProperty(value="rs_id")
    private int replicaSetID;
    @JsonProperty(value="nodes")
    private Set<Node> nodes = Sets.newHashSet();
    @JsonProperty(value="leader")
    private Node leader;

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<Node> nodes) {
        this.nodes = nodes;
    }

    public Node getLeader() {
        return this.leader;
    }

    public void setLeader(Node leader) {
        this.leader = leader;
    }

    public int getReplicaSetID() {
        return this.replicaSetID;
    }

    public void setReplicaSetID(int replicaSetID) {
        this.replicaSetID = replicaSetID;
    }

    public boolean containPhysicalNode(Node node) {
        return this.nodes.contains(node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSet that = (ReplicaSet)o;
        return this.replicaSetID == that.replicaSetID;
    }

    public int hashCode() {
        return this.replicaSetID;
    }

    public String toString() {
        return "ReplicaSet{replicaSetID=" + this.replicaSetID + ", nodes=" + this.nodes + '}';
    }
}

