/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.util.Assert;

abstract class ApplicationContextInitializerUtils {
    private static final Log logger = LogFactory.getLog(ApplicationContextInitializerUtils.class);

    ApplicationContextInitializerUtils() {
    }

    static Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> resolveInitializerClasses(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, "ContextConfigurationAttributes list must not be empty");
        LinkedHashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = new LinkedHashSet<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>>();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace("Processing context initializers for configuration attributes " + configAttributes);
            }
            initializerClasses.addAll(Arrays.asList(configAttributes.getInitializers()));
            if (configAttributes.isInheritInitializers()) continue;
            break;
        }
        return initializerClasses;
    }
}

