/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDescTiretreeGlobalDomainDictUtil;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.cube.model.HBaseMappingDesc;
import org.apache.kylin.cube.model.IHBaseMappingAdapter;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.cube.model.TooManyCuboidException;
import org.apache.kylin.dict.GlobalDictionaryBuilder;
import org.apache.kylin.dict.global.SegmentAppendTrieDictBuilder;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.extendedcolumn.ExtendedColumnMeasureType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IEngineAware;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.base.Joiner;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeDesc
extends RootPersistentEntity
implements IEngineAware {
    private static final Logger logger = LoggerFactory.getLogger(CubeDesc.class);
    public static final int MAX_ROWKEY_SIZE = 64;
    private KylinConfigExt config;
    private DataModelDesc model;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="is_draft")
    private boolean isDraft;
    @JsonProperty(value="model_name")
    private String modelName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="null_string")
    private String[] nullStrings;
    @JsonProperty(value="dimensions")
    private List<DimensionDesc> dimensions;
    @JsonProperty(value="measures")
    private List<MeasureDesc> measures;
    @JsonProperty(value="dictionaries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<DictionaryDesc> dictionaries;
    @JsonProperty(value="rowkey")
    private RowKeyDesc rowkey;
    @JsonProperty(value="hbase_mapping")
    private HBaseMappingDesc hbaseMapping;
    @JsonProperty(value="aggregation_groups")
    private List<AggregationGroup> aggregationGroups;
    @JsonProperty(value="signature")
    private String signature;
    @JsonProperty(value="notify_list")
    private List<String> notifyList;
    @JsonProperty(value="status_need_notify")
    private List<String> statusNeedNotify = Collections.emptyList();
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_end")
    private long partitionDateEnd = 3153600000000L;
    @JsonProperty(value="auto_merge_time_ranges")
    private long[] autoMergeTimeRanges;
    @JsonProperty(value="volatile_range")
    private long volatileRange = 0L;
    @JsonProperty(value="retention_range")
    private long retentionRange = 0L;
    @JsonProperty(value="engine_type")
    private int engineType = 2;
    @JsonProperty(value="storage_type")
    private int storageType = 2;
    @JsonProperty(value="override_kylin_properties")
    private LinkedHashMap<String, String> overrideKylinProps = new LinkedHashMap();
    @JsonProperty(value="partition_offset_start")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<Integer, Long> partitionOffsetStart = Maps.newHashMap();
    @JsonProperty(value="cuboid_black_list")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Set<Long> cuboidBlackSet = Sets.newHashSet();
    @JsonProperty(value="parent_forward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private int parentForward = 3;
    @JsonProperty(value="mandatory_dimension_set_list")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Set<String>> mandatoryDimensionSetList = Collections.emptyList();
    private List<String> errors = new ArrayList<String>();
    @JsonProperty(value="snapshot_table_desc_list")
    private List<SnapshotTableDesc> snapshotTableDescList = Collections.emptyList();
    private LinkedHashSet<TblColRef> allColumns = new LinkedHashSet();
    private LinkedHashSet<ColumnDesc> allColumnDescs = new LinkedHashSet();
    private LinkedHashSet<TblColRef> dimensionColumns = new LinkedHashSet();
    private Set<Long> mandatoryCuboids = new HashSet<Long>();
    private Map<TblColRef, DeriveInfo> derivedToHostMap = Maps.newHashMap();
    private Map<Array<TblColRef>, List<DeriveInfo>> hostToDerivedMap = Maps.newHashMap();
    private Map<TblColRef, DeriveInfo> extendedColumnToHosts = Maps.newHashMap();
    private volatile transient CuboidScheduler cuboidScheduler = null;

    public static JsonSerializer<CubeDesc> newSerializerForLowLevelAccess() {
        return new JsonSerializer<CubeDesc>(CubeDesc.class);
    }

    @Override
    public String resourceName() {
        return this.name;
    }

    public boolean isEnableSharding() {
        return this.storageType != 0 && this.storageType != 1;
    }

    public Set<TblColRef> getShardByColumns() {
        return this.getRowkey().getShardByColumns();
    }

    public Set<TblColRef> listAllColumns() {
        return this.allColumns == null ? null : Collections.unmodifiableSet(this.allColumns);
    }

    public Set<ColumnDesc> listAllColumnDescs() {
        return this.allColumnDescs == null ? null : Collections.unmodifiableSet(this.allColumnDescs);
    }

    public Set<TblColRef> listDimensionColumnsIncludingDerived() {
        return this.dimensionColumns == null ? null : Collections.unmodifiableSet(this.dimensionColumns);
    }

    public List<TblColRef> listDimensionColumnsExcludingDerived(boolean alsoExcludeExtendedCol) {
        ArrayList<TblColRef> result = new ArrayList<TblColRef>();
        for (TblColRef col : this.dimensionColumns) {
            if (this.isDerived(col) || alsoExcludeExtendedCol && this.isExtendedColumn(col)) continue;
            result.add(col);
        }
        return result;
    }

    public List<FunctionDesc> listAllFunctions() {
        ArrayList<FunctionDesc> functions = new ArrayList<FunctionDesc>();
        for (MeasureDesc m : this.measures) {
            functions.add(m.getFunction());
        }
        return functions;
    }

    public TblColRef findColumnRef(String table, String column) {
        return this.model.findColumn(table, column);
    }

    public DimensionDesc findDimensionByTable(String lookupTableName) {
        lookupTableName = lookupTableName.toUpperCase(Locale.ROOT);
        for (DimensionDesc dim : this.dimensions) {
            if (dim.getTableRef() == null || !dim.getTableRef().getTableIdentity().equals(lookupTableName)) continue;
            return dim;
        }
        return null;
    }

    public boolean hasHostColumn(TblColRef col) {
        return this.isDerived(col) || this.isExtendedColumn(col);
    }

    public boolean isDerived(TblColRef col) {
        return this.derivedToHostMap.containsKey(col);
    }

    public boolean isExtendedColumn(TblColRef col) {
        return this.extendedColumnToHosts.containsKey(col);
    }

    public DeriveInfo getHostInfo(TblColRef derived) {
        if (this.isDerived(derived)) {
            return this.derivedToHostMap.get(derived);
        }
        if (this.isExtendedColumn(derived)) {
            return this.extendedColumnToHosts.get(derived);
        }
        throw new RuntimeException("Cannot get host info for " + derived);
    }

    public Map<Array<TblColRef>, List<DeriveInfo>> getHostToDerivedInfo(List<TblColRef> rowCols, Collection<TblColRef> wantedCols) {
        HashMap<Array<TblColRef>, List<DeriveInfo>> result = new HashMap<Array<TblColRef>, List<DeriveInfo>>();
        for (Map.Entry<Array<TblColRef>, List<DeriveInfo>> entry : this.hostToDerivedMap.entrySet()) {
            Array<TblColRef> hostCols = entry.getKey();
            boolean hostOnRow = rowCols.containsAll(Arrays.asList(hostCols.getData()));
            if (!hostOnRow) continue;
            ArrayList<DeriveInfo> wantedInfo = new ArrayList<DeriveInfo>();
            for (DeriveInfo info : entry.getValue()) {
                if (wantedCols != null && Collections.disjoint(wantedCols, Arrays.asList(info.columns))) continue;
                wantedInfo.add(info);
            }
            if (wantedInfo.size() <= 0) continue;
            result.put(hostCols, wantedInfo);
        }
        return result;
    }

    public String getResourcePath() {
        return CubeDesc.concatResourcePath(this.resourceName());
    }

    public static String concatResourcePath(String descName) {
        return "/cube_desc/" + descName + ".json";
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    private void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public void setDraft(boolean isDraft) {
        this.isDraft = isDraft;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public DataModelDesc getModel() {
        return this.model;
    }

    public void setModel(DataModelDesc model) {
        this.model = model;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getNullStrings() {
        return this.nullStrings;
    }

    public List<DimensionDesc> getDimensions() {
        return this.dimensions == null ? null : Collections.unmodifiableList(this.dimensions);
    }

    public void setDimensions(List<DimensionDesc> dimensions) {
        this.dimensions = dimensions;
    }

    public List<MeasureDesc> getMeasures() {
        return this.measures == null ? null : Collections.unmodifiableList(this.measures);
    }

    public void setMeasures(List<MeasureDesc> measures) {
        this.measures = measures;
    }

    public List<DictionaryDesc> getDictionaries() {
        return this.dictionaries == null ? null : Collections.unmodifiableList(this.dictionaries);
    }

    public void setDictionaries(List<DictionaryDesc> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public RowKeyDesc getRowkey() {
        return this.rowkey;
    }

    public void setRowkey(RowKeyDesc rowkey) {
        this.rowkey = rowkey;
    }

    public List<AggregationGroup> getAggregationGroups() {
        return this.aggregationGroups == null ? null : Collections.unmodifiableList(this.aggregationGroups);
    }

    public void setAggregationGroups(List<AggregationGroup> aggregationGroups) {
        this.aggregationGroups = aggregationGroups;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public List<String> getNotifyList() {
        return this.notifyList == null ? null : Collections.unmodifiableList(this.notifyList);
    }

    public void setNotifyList(List<String> notifyList) {
        this.notifyList = notifyList;
    }

    public List<String> getStatusNeedNotify() {
        return this.statusNeedNotify == null ? null : Collections.unmodifiableList(this.statusNeedNotify);
    }

    public void setStatusNeedNotify(List<String> statusNeedNotify) {
        this.statusNeedNotify = statusNeedNotify;
    }

    public LinkedHashMap<String, String> getOverrideKylinProps() {
        return this.overrideKylinProps;
    }

    private void setOverrideKylinProps(LinkedHashMap<String, String> overrideKylinProps) {
        this.overrideKylinProps = overrideKylinProps;
    }

    public List<Set<String>> getMandatoryDimensionSetList() {
        return this.mandatoryDimensionSetList;
    }

    public void setMandatoryDimensionSetList(List<Set<String>> mandatoryDimensionSetList) {
        this.mandatoryDimensionSetList = mandatoryDimensionSetList;
    }

    public Set<Long> getMandatoryCuboids() {
        return this.mandatoryCuboids;
    }

    public boolean equalsRaw(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubeDesc that = (CubeDesc)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.modelName, that.modelName)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.dimensions, that.dimensions)) {
            return false;
        }
        if (!Objects.equals(this.measures, that.measures)) {
            return false;
        }
        if (!Objects.equals(this.dictionaries, that.dictionaries)) {
            return false;
        }
        if (!Arrays.equals(this.rowkey.getRowKeyColumns(), that.rowkey.getRowKeyColumns())) {
            return false;
        }
        if (!Objects.equals(this.nullStrings, that.nullStrings)) {
            return false;
        }
        if (!Arrays.equals(this.hbaseMapping.getColumnFamily(), that.hbaseMapping.getColumnFamily())) {
            return false;
        }
        if (this.aggregationGroups != that.aggregationGroups) {
            if (this.aggregationGroups == null || that.aggregationGroups == null) {
                return false;
            }
            if (!IntStream.range(0, this.aggregationGroups.size()).allMatch(i -> Arrays.equals(this.aggregationGroups.get(i).getIncludes(), that.aggregationGroups.get(i).getIncludes()) && Objects.equals(this.aggregationGroups.get(i).getSelectRule(), that.aggregationGroups.get(i).getSelectRule()))) {
                return false;
            }
        }
        if (!Objects.equals(this.notifyList, that.notifyList)) {
            return false;
        }
        if (!Objects.equals(this.statusNeedNotify, that.statusNeedNotify)) {
            return false;
        }
        if (!Arrays.equals(this.autoMergeTimeRanges, that.autoMergeTimeRanges)) {
            return false;
        }
        if (!Objects.equals(this.retentionRange, that.retentionRange)) {
            return false;
        }
        if (!Objects.equals(this.engineType, that.engineType)) {
            return false;
        }
        if (!Objects.equals(this.storageType, that.storageType)) {
            return false;
        }
        if (!Objects.equals(this.overrideKylinProps, that.overrideKylinProps)) {
            return false;
        }
        if (!Objects.equals(this.snapshotTableDescList, that.snapshotTableDescList)) {
            return false;
        }
        if (!Objects.equals(this.partitionDateStart, that.partitionDateStart)) {
            return false;
        }
        if (!Objects.equals(this.partitionDateEnd, that.partitionDateEnd)) {
            return false;
        }
        if (!Objects.equals(this.parentForward, that.parentForward)) {
            return false;
        }
        if (!Objects.equals(this.mandatoryDimensionSetList, that.mandatoryDimensionSetList)) {
            return false;
        }
        return Objects.equals(this.cuboidBlackSet, that.cuboidBlackSet);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubeDesc cubeDesc = (CubeDesc)o;
        if (!this.name.equals(cubeDesc.name)) {
            return false;
        }
        return this.modelName.equals(cubeDesc.modelName);
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.model.getRootFactTable().hashCode();
        return result;
    }

    public String toString() {
        return "CubeDesc [name=" + this.name + "]";
    }

    public boolean checkSignature() {
        if (this.getConfig().isIgnoreCubeSignatureInconsistency()) {
            logger.info("Skip checking cube signature");
            return true;
        }
        KylinVersion cubeVersion = new KylinVersion(this.getVersion());
        KylinVersion kylinVersion = KylinVersion.getCurrentVersion();
        if (!kylinVersion.isCompatibleWith(cubeVersion)) {
            logger.info("checkSignature on {} is skipped as the its version {} is different from kylin version {}", this.getName(), cubeVersion, kylinVersion);
            return true;
        }
        if (kylinVersion.isCompatibleWith(cubeVersion) && !kylinVersion.isSignatureCompatibleWith(cubeVersion)) {
            logger.info("checkSignature on {} is skipped as the its version is {} (not signature compatible but compatible) ", (Object)this.getName(), (Object)cubeVersion);
            return true;
        }
        if (StringUtils.isBlank(this.getSignature())) {
            return true;
        }
        String calculated = this.calculateSignature();
        String saved = this.getSignature();
        return calculated.equals(saved);
    }

    public boolean consistentWith(CubeDesc another) {
        if (another == null) {
            return false;
        }
        return this.calculateSignature().equals(another.calculateSignature());
    }

    public CubeDesc latestCopyForWrite() {
        CubeDescManager mgr = CubeDescManager.getInstance(this.config);
        CubeDesc lastest = mgr.getCubeDesc(this.name);
        return mgr.copyForWrite(lastest);
    }

    public String calculateSignature() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder sigString = new StringBuilder();
            sigString.append(this.name).append("|").append(JsonUtil.writeValueAsString(this.modelName)).append("|").append(JsonUtil.writeValueAsString(this.nullStrings)).append("|").append(JsonUtil.writeValueAsString(this.dimensions)).append("|").append(JsonUtil.writeValueAsString(this.measures)).append("|").append(JsonUtil.writeValueAsString(this.rowkey)).append("|").append(JsonUtil.writeValueAsString(this.aggregationGroups)).append("|").append(JsonUtil.writeValueAsString(this.hbaseMapping)).append("|").append(JsonUtil.writeValueAsString(this.storageType)).append("|");
            if (this.mandatoryDimensionSetList != null && !this.mandatoryDimensionSetList.isEmpty()) {
                for (Set<String> mandatoryDimensionSet : this.mandatoryDimensionSetList) {
                    TreeSet<String> sortedSet = Sets.newTreeSet(mandatoryDimensionSet);
                    sigString.append(JsonUtil.writeValueAsString(sortedSet)).append("|");
                }
            }
            String signatureInput = sigString.toString().replaceAll("\\s+", "").toLowerCase(Locale.ROOT);
            byte[] signature = md.digest(signatureInput.getBytes(StandardCharsets.UTF_8));
            String ret = new String(Base64.encodeBase64((byte[])signature), StandardCharsets.UTF_8);
            return ret;
        }
        catch (NoSuchAlgorithmException | JsonProcessingException e) {
            throw new RuntimeException("Failed to calculate signature");
        }
    }

    public void deInit() {
        this.config = null;
        this.model = null;
        this.allColumns = new LinkedHashSet();
        this.allColumnDescs = new LinkedHashSet();
        this.dimensionColumns = new LinkedHashSet();
        this.derivedToHostMap = Maps.newHashMap();
        this.hostToDerivedMap = Maps.newHashMap();
        this.extendedColumnToHosts = Maps.newHashMap();
        this.cuboidBlackSet = Sets.newHashSet();
        this.cuboidScheduler = null;
    }

    public void init(KylinConfig config) {
        this.errors.clear();
        Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "CubeDesc name is blank");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.modelName), "CubeDesc (%s) has blank model name", (Object)this.name);
        List<ProjectInstance> ownerPrj = ProjectManager.getInstance(config).findProjects(RealizationType.CUBE, this.name);
        LinkedHashMap<String, String> allOverrideProps = Maps.newLinkedHashMap(this.overrideKylinProps);
        if (ownerPrj.size() == 1) {
            Iterator<AggregationGroup> prjOverrideProps = ownerPrj.get(0).getOverrideKylinProps();
            for (Map.Entry entry : prjOverrideProps.entrySet()) {
                if (this.overrideKylinProps.containsKey(entry.getKey())) continue;
                allOverrideProps.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.config = KylinConfigExt.createInstance(config, allOverrideProps);
        Preconditions.checkArgument(this.rowkey.getRowKeyColumns().length <= this.config.getCubeRowkeyMaxSize(), "Too many rowkeys (%s) in CubeDesc, please try to reduce dimension number or adopt derived dimensions", this.rowkey.getRowKeyColumns().length);
        this.model = DataModelManager.getInstance(config).getDataModelDesc(this.modelName);
        Preconditions.checkNotNull(this.model, "DateModelDesc(%s) not found", (Object)this.modelName);
        for (DimensionDesc dim : this.dimensions) {
            dim.init(this);
        }
        this.initDimensionColumns();
        this.initMeasureColumns();
        this.rowkey.init(this);
        for (AggregationGroup agg : this.aggregationGroups) {
            agg.init(this, this.rowkey);
        }
        this.validateAggregationGroups();
        this.validateAggregationGroupsCombination();
        String hbaseMappingAdapterName = config.getHBaseMappingAdapter();
        if (hbaseMappingAdapterName != null) {
            try {
                IHBaseMappingAdapter hbaseMappingAdapter = (IHBaseMappingAdapter)Class.forName(hbaseMappingAdapterName).newInstance();
                hbaseMappingAdapter.initHBaseMapping(this);
                hbaseMappingAdapter.initMeasureReferenceToColumnFamilyWithChecking(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Error during adapting hbase mapping", e);
            }
        } else if (this.hbaseMapping != null) {
            this.hbaseMapping.init(this);
            this.initMeasureReferenceToColumnFamily();
        }
        List<TblColRef> dimCols = this.listDimensionColumnsExcludingDerived(true);
        Preconditions.checkState(this.rowkey.getRowKeyColumns().length == dimCols.size(), "RowKey columns count (%s) doesn't match dimensions columns count (%s)", this.rowkey.getRowKeyColumns().length, dimCols.size());
        this.initDictionaryDesc();
        this.amendAllColumns();
        this.initMandatoryCuboids();
    }

    private void initMandatoryCuboids() {
        this.mandatoryCuboids.clear();
        this.mandatoryCuboids.addAll(this.generateMandatoryCuboids(this.mandatoryDimensionSetList));
    }

    public Set<Long> generateMandatoryCuboids(List<Set<String>> mandatoryDimensionSetList) {
        HashMap<String, RowKeyColDesc> rowKeyColDescMap = Maps.newHashMap();
        for (RowKeyColDesc entry : this.getRowkey().getRowKeyColumns()) {
            rowKeyColDescMap.put(entry.getColumn(), entry);
        }
        HashSet<Long> mandatoryCuboids = Sets.newHashSetWithExpectedSize(mandatoryDimensionSetList.size());
        for (Set<String> mandatoryDimensionSet : mandatoryDimensionSetList) {
            long cuboid = 0L;
            for (String columnName : mandatoryDimensionSet) {
                TblColRef tblColRef = this.model.findColumn(columnName);
                RowKeyColDesc rowKeyColDesc = (RowKeyColDesc)rowKeyColDescMap.get(tblColRef.getIdentity());
                if (rowKeyColDesc == null) {
                    logger.warn("Column " + columnName + " in " + mandatoryDimensionSet + " does not exist");
                    throw new IllegalStateException("Column " + columnName + " in " + mandatoryDimensionSet + " does not exist");
                }
                cuboid |= 1L << rowKeyColDesc.getBitIndex();
            }
            mandatoryCuboids.add(cuboid);
        }
        return mandatoryCuboids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CuboidScheduler getInitialCuboidScheduler() {
        if (this.cuboidScheduler != null) {
            return this.cuboidScheduler;
        }
        CubeDesc cubeDesc = this;
        synchronized (cubeDesc) {
            if (this.cuboidScheduler == null) {
                this.cuboidScheduler = CuboidScheduler.getInstance(this);
            }
            return this.cuboidScheduler;
        }
    }

    public boolean isBlackedCuboid(long cuboidID) {
        return this.cuboidBlackSet.contains(cuboidID);
    }

    public void validateAggregationGroupsCombination() {
        int index = 1;
        for (AggregationGroup agg : this.getAggregationGroups()) {
            try {
                long combination = agg.calculateCuboidCombination();
                if (combination > this.config.getCubeAggrGroupMaxCombination()) {
                    String msg = "Aggregation group " + index + " of Cube Desc " + this.name + " has too many combinations: " + combination + ". Use 'mandatory'/'hierarchy'/'joint' to optimize; or update 'kylin.cube.aggrgroup.max-combination' to a bigger value.";
                    throw new TooManyCuboidException(msg);
                }
            }
            catch (TooManyCuboidException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unknown error while calculating cuboid number for Aggregation group " + index + " of Cube Desc " + this.name, e);
            }
            ++index;
        }
    }

    public void validateAggregationGroups() {
        int index = 1;
        for (AggregationGroup agg : this.getAggregationGroups()) {
            if (agg.getIncludes() == null) {
                logger.error("Aggregation group " + index + " 'includes' field not set");
                throw new IllegalStateException("Aggregation group " + index + " includes field not set");
            }
            if (agg.getSelectRule() == null) {
                logger.error("Aggregation group " + index + " 'select_rule' field not set");
                throw new IllegalStateException("Aggregation group " + index + " select rule field not set");
            }
            TreeSet<String> includeDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(includeDims, agg.getIncludes());
            TreeSet<String> mandatoryDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(mandatoryDims, agg.getSelectRule().mandatoryDims);
            ArrayList<Set<String>> hierarchyDimsList = Lists.newArrayList();
            TreeSet<String> hierarchyDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(hierarchyDimsList, hierarchyDims, agg.getSelectRule().hierarchyDims);
            ArrayList<Set<String>> jointDimsList = Lists.newArrayList();
            TreeSet<String> jointDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(jointDimsList, jointDims, agg.getSelectRule().jointDims);
            if (!(includeDims.containsAll(mandatoryDims) && includeDims.containsAll(hierarchyDims) && includeDims.containsAll(jointDims))) {
                ArrayList<String> notIncluded = Lists.newArrayList();
                Iterable<String> all = Iterables.unmodifiableIterable(Iterables.concat(mandatoryDims, hierarchyDims, jointDims));
                for (String dim : all) {
                    if (includeDims.contains(dim)) continue;
                    notIncluded.add(dim);
                }
                Collections.sort(notIncluded);
                logger.error("Aggregation group " + index + " Include dimensions not containing all the used dimensions");
                throw new IllegalStateException("Aggregation group " + index + " 'includes' dimensions not include all the dimensions:" + ((Object)notIncluded).toString());
            }
            if (CollectionUtils.containsAny(mandatoryDims, hierarchyDims)) {
                logger.warn("Aggregation group " + index + " mandatory dimensions overlap with hierarchy dimensions: " + this.ensureOrder(CollectionUtils.intersection(mandatoryDims, hierarchyDims)));
            }
            if (CollectionUtils.containsAny(mandatoryDims, jointDims)) {
                logger.warn("Aggregation group " + index + " mandatory dimensions overlap with joint dimensions: " + this.ensureOrder(CollectionUtils.intersection(mandatoryDims, jointDims)));
            }
            if (CollectionUtils.containsAny(hierarchyDims, jointDims)) {
                logger.error("Aggregation group " + index + " hierarchy dimensions overlap with joint dimensions");
                throw new IllegalStateException("Aggregation group " + index + " hierarchy dimensions overlap with joint dimensions: " + this.ensureOrder(CollectionUtils.intersection(hierarchyDims, jointDims)));
            }
            if (this.hasSingleOrNone(hierarchyDimsList)) {
                logger.error("Aggregation group " + index + " require at least 2 dimensions in a hierarchy");
                throw new IllegalStateException("Aggregation group " + index + " require at least 2 dimensions in a hierarchy.");
            }
            if (this.hasSingleOrNone(jointDimsList)) {
                logger.error("Aggregation group " + index + " require at least 2 dimensions in a joint");
                throw new IllegalStateException("Aggregation group " + index + " require at least 2 dimensions in a joint");
            }
            Pair<Boolean, Set<String>> overlap = this.hasOverlap(hierarchyDimsList, hierarchyDims);
            if (overlap.getFirst().booleanValue()) {
                logger.error("Aggregation group " + index + " a dimension exist in more than one hierarchy: " + this.ensureOrder(overlap.getSecond()));
                throw new IllegalStateException("Aggregation group " + index + " a dimension exist in more than one hierarchy: " + this.ensureOrder(overlap.getSecond()));
            }
            overlap = this.hasOverlap(jointDimsList, jointDims);
            if (overlap.getFirst().booleanValue()) {
                logger.error("Aggregation group " + index + " a dimension exist in more than one joint: " + this.ensureOrder(overlap.getSecond()));
                throw new IllegalStateException("Aggregation group " + index + " a dimension exist in more than one joint: " + this.ensureOrder(overlap.getSecond()));
            }
            ++index;
        }
    }

    public void validateNotifyList() {
        List<String> notifyList = this.getNotifyList();
        if (notifyList != null && !notifyList.isEmpty()) {
            EmailValidator emailValidator = EmailValidator.getInstance();
            for (String email : notifyList) {
                if (emailValidator.isValid(email)) continue;
                throw new IllegalArgumentException("Email [" + email + "] is not validation.");
            }
        }
    }

    private void getDims(Set<String> dims, String[] stringSet) {
        if (stringSet != null) {
            for (String str : stringSet) {
                dims.add(str);
            }
        }
    }

    private void getDims(ArrayList<Set<String>> dimsList, Set<String> dims, String[][] stringSets) {
        if (stringSets != null) {
            for (String[] ss : stringSets) {
                TreeSet<String> temp = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String s : ss) {
                    temp.add(s);
                    dims.add(s);
                }
                dimsList.add(temp);
            }
        }
    }

    private boolean hasSingleOrNone(ArrayList<Set<String>> dimsList) {
        boolean hasSingleOrNone = false;
        for (Set<String> dims : dimsList) {
            if (dims.size() > 1) continue;
            hasSingleOrNone = true;
            break;
        }
        return hasSingleOrNone;
    }

    private Pair<Boolean, Set<String>> hasOverlap(ArrayList<Set<String>> dimsList, Set<String> Dims) {
        HashSet<String> existing = new HashSet<String>();
        HashSet overlap = new HashSet();
        for (Set<String> dims : dimsList) {
            if (CollectionUtils.containsAny(existing, dims)) {
                overlap.addAll(this.ensureOrder(CollectionUtils.intersection(existing, dims)));
            }
            existing.addAll(dims);
        }
        return new Pair<Boolean, Set<String>>(overlap.size() > 0, overlap);
    }

    private void initDimensionColumns() {
        for (DimensionDesc dim : this.dimensions) {
            JoinDesc join = dim.getJoin();
            ArrayList<TblColRef> dimCols = Lists.newArrayList();
            String colStr = dim.getColumn();
            if (colStr == null && dim.isDerived() || "{FK}".equalsIgnoreCase(colStr)) {
                for (TblColRef col : join.getForeignKeyColumns()) {
                    dimCols.add(this.initDimensionColRef(col));
                }
            } else {
                Preconditions.checkState(!StringUtils.isEmpty(colStr), "Dimension column must not be blank: %s", (Object)dim);
                dimCols.add(this.initDimensionColRef(dim, colStr));
            }
            TblColRef[] dimColArray = dimCols.toArray(new TblColRef[dimCols.size()]);
            dim.setColumnRefs(dimColArray);
            if (dim.isDerived()) {
                String[] derived = dim.getDerived();
                String[][] split = this.splitDerivedColumnAndExtra(derived);
                String[] derivedNames = split[0];
                String[] derivedExtra = split[1];
                TblColRef[] derivedCols = new TblColRef[derivedNames.length];
                for (int i = 0; i < derivedNames.length; ++i) {
                    derivedCols[i] = this.initDimensionColRef(dim, derivedNames[i]);
                }
                this.initDerivedMap(dimColArray, DeriveType.LOOKUP, join, derivedCols, derivedExtra);
            }
            if (join == null) continue;
            this.allColumns.addAll(Arrays.asList(join.getForeignKeyColumns()));
            this.allColumns.addAll(Arrays.asList(join.getPrimaryKeyColumns()));
        }
        HashSet<TblColRef> realDimensions = new HashSet<TblColRef>(this.listDimensionColumnsExcludingDerived(true));
        for (JoinTableDesc joinTable : this.model.getJoinTables()) {
            JoinDesc join = joinTable.getJoin();
            int n = join.getForeignKeyColumns().length;
            for (int i = 0; i < n; ++i) {
                TblColRef pk = join.getPrimaryKeyColumns()[i];
                TblColRef fk = join.getForeignKeyColumns()[i];
                if (realDimensions.contains(pk) && !realDimensions.contains(fk)) {
                    this.initDimensionColRef(fk);
                    this.initDerivedMap(new TblColRef[]{pk}, DeriveType.PK_FK, join, new TblColRef[]{fk}, null);
                    continue;
                }
                if (!realDimensions.contains(fk) || realDimensions.contains(pk)) continue;
                this.initDimensionColRef(pk);
                this.initDerivedMap(new TblColRef[]{fk}, DeriveType.PK_FK, join, new TblColRef[]{pk}, null);
            }
        }
    }

    private String[][] splitDerivedColumnAndExtra(String[] derived) {
        String[] cols = new String[derived.length];
        String[] extra = new String[derived.length];
        for (int i = 0; i < derived.length; ++i) {
            String str = derived[i];
            int cut = str.indexOf(":");
            if (cut >= 0) {
                cols[i] = str.substring(0, cut);
                extra[i] = str.substring(cut + 1).trim();
                continue;
            }
            cols[i] = str;
            extra[i] = "";
        }
        return new String[][]{cols, extra};
    }

    private void initDerivedMap(TblColRef[] hostCols, DeriveType type, JoinDesc join, TblColRef[] derivedCols, String[] extra) {
        int i;
        if (hostCols.length == 0 || derivedCols.length == 0) {
            throw new IllegalStateException("host/derived columns must not be empty");
        }
        for (i = 0; i < derivedCols.length; ++i) {
            if (!ArrayUtils.contains(hostCols, derivedCols[i])) continue;
            derivedCols = (TblColRef[])ArrayUtils.remove(derivedCols, i);
            if (extra != null) {
                extra = (String[])ArrayUtils.remove(extra, i);
            }
            --i;
        }
        if (derivedCols.length == 0) {
            return;
        }
        for (i = 0; i < derivedCols.length; ++i) {
            TblColRef derivedCol = derivedCols[i];
            boolean isOneToOne = type == DeriveType.PK_FK || ArrayUtils.contains(hostCols, derivedCol) || extra != null && extra[i].contains("1-1");
            this.derivedToHostMap.put(derivedCol, new DeriveInfo(type, join, hostCols, isOneToOne));
        }
        Array<TblColRef> hostColArray = new Array<TblColRef>(hostCols);
        List<DeriveInfo> infoList = this.hostToDerivedMap.get(hostColArray);
        if (infoList == null) {
            infoList = new ArrayList<DeriveInfo>();
            this.hostToDerivedMap.put(hostColArray, infoList);
        }
        ArrayList<TblColRef> whatsLeft = new ArrayList<TblColRef>();
        for (TblColRef derCol : derivedCols) {
            boolean merged = false;
            for (DeriveInfo existing : infoList) {
                if (existing.type != type || !existing.join.getPKSide().equals(join.getPKSide())) continue;
                if (ArrayUtils.contains(existing.columns, derCol)) {
                    merged = true;
                    break;
                }
                if (type != DeriveType.LOOKUP) continue;
                existing.columns = (TblColRef[])ArrayUtils.add(existing.columns, derCol);
                merged = true;
                break;
            }
            if (merged) continue;
            whatsLeft.add(derCol);
        }
        if (whatsLeft.size() > 0) {
            infoList.add(new DeriveInfo(type, join, whatsLeft.toArray(new TblColRef[whatsLeft.size()]), false));
        }
    }

    private TblColRef initDimensionColRef(DimensionDesc dim, String colName) {
        int idx;
        JoinDesc join;
        TblColRef col = this.model.findColumn(dim.getTable(), colName);
        if (KylinVersion.isBefore200(this.getVersion()) && (join = dim.getJoin()) != null && (idx = ArrayUtils.indexOf(join.getPrimaryKeyColumns(), col)) >= 0) {
            col = join.getForeignKeyColumns()[idx];
        }
        return this.initDimensionColRef(col);
    }

    private TblColRef initDimensionColRef(TblColRef col) {
        this.allColumns.add(col);
        this.dimensionColumns.add(col);
        return col;
    }

    private void initMeasureColumns() {
        if (this.measures == null || this.measures.isEmpty()) {
            return;
        }
        for (MeasureDesc m : this.measures) {
            m.setName(m.getName().toUpperCase(Locale.ROOT));
            if (m.getDependentMeasureRef() != null) {
                m.setDependentMeasureRef(m.getDependentMeasureRef().toUpperCase(Locale.ROOT));
            }
            FunctionDesc func = m.getFunction();
            func.init(this.model);
            this.allColumns.addAll(func.getParameter().getColRefs());
            if (!"EXTENDED_COLUMN".equalsIgnoreCase(m.getFunction().getExpression())) continue;
            FunctionDesc functionDesc = m.getFunction();
            List<TblColRef> hosts = ExtendedColumnMeasureType.getExtendedColumnHosts(functionDesc);
            TblColRef extendedColumn = ExtendedColumnMeasureType.getExtendedColumn(functionDesc);
            this.initExtendedColumnMap(hosts.toArray(new TblColRef[hosts.size()]), extendedColumn);
        }
    }

    private void initExtendedColumnMap(TblColRef[] hostCols, TblColRef extendedColumn) {
        this.extendedColumnToHosts.put(extendedColumn, new DeriveInfo(DeriveType.EXTENDED_COLUMN, null, hostCols, false));
    }

    public void initMeasureReferenceToColumnFamily() {
        if (this.measures == null || this.measures.size() == 0) {
            return;
        }
        HashMap<String, MeasureDesc> measureLookup = new HashMap<String, MeasureDesc>();
        for (MeasureDesc m : this.measures) {
            measureLookup.put(m.getName(), m);
        }
        HashMap<String, Integer> measureIndexLookup = new HashMap<String, Integer>();
        for (int i = 0; i < this.measures.size(); ++i) {
            measureIndexLookup.put(this.measures.get(i).getName(), i);
        }
        BitSet checkEachMeasureExist = new BitSet();
        HashSet<String> measureSet = Sets.newHashSet();
        for (HBaseColumnFamilyDesc cf : this.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc c : cf.getColumns()) {
                String[] colMeasureRefs = c.getMeasureRefs();
                MeasureDesc[] measureDescs = new MeasureDesc[colMeasureRefs.length];
                int[] measureIndex = new int[colMeasureRefs.length];
                int lastMeasureIndex = -1;
                for (int i = 0; i < colMeasureRefs.length; ++i) {
                    measureDescs[i] = (MeasureDesc)measureLookup.get(colMeasureRefs[i]);
                    Preconditions.checkState(measureDescs[i] != null, "measure desc at (%s) is null", i);
                    measureIndex[i] = (Integer)measureIndexLookup.get(colMeasureRefs[i]);
                    Preconditions.checkState(measureIndex[i] >= 0, "measure index at (%s) not positive", i);
                    Preconditions.checkState(!measureSet.contains(colMeasureRefs[i]), "measure (%s) duplicates", (Object)colMeasureRefs[i]);
                    measureSet.add(colMeasureRefs[i]);
                    if (this.storageType > 2) {
                        Preconditions.checkState(measureIndex[i] > lastMeasureIndex, "measure (%s) is not in order", (Object)colMeasureRefs[i]);
                        lastMeasureIndex = measureIndex[i];
                    }
                    checkEachMeasureExist.set(measureIndex[i]);
                }
                c.setMeasures(measureDescs);
                c.setMeasureIndex(measureIndex);
                c.setColumnFamilyName(cf.getName());
            }
        }
        for (int i = 0; i < this.measures.size(); ++i) {
            Preconditions.checkState(checkEachMeasureExist.get(i), "measure (%s) does not exist in column family, or measure duplicates", (Object)this.measures.get(i));
        }
    }

    private void initDictionaryDesc() {
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                dictDesc.init(this);
                this.allColumns.add(dictDesc.getColumnRef());
                if (dictDesc.getResuseColumnRef() == null) continue;
                this.allColumns.add(dictDesc.getResuseColumnRef());
            }
        }
    }

    public TblColRef getColumnByBitIndex(int bitIndex) {
        RowKeyColDesc[] rowKeyColumns = this.getRowkey().getRowKeyColumns();
        return rowKeyColumns[rowKeyColumns.length - 1 - bitIndex].getColRef();
    }

    public boolean hasMemoryHungryMeasures() {
        for (MeasureDesc measure : this.measures) {
            if (!measure.getFunction().getMeasureType().isMemoryHungry()) continue;
            return true;
        }
        return false;
    }

    private void amendAllColumns() {
        Set<TableRef> tables = this.collectTablesOnJoinChain(this.allColumns);
        for (TableRef t : tables) {
            JoinDesc join = this.model.getJoinByPKSide(t);
            if (join == null) continue;
            this.allColumns.addAll(Arrays.asList(join.getForeignKeyColumns()));
            this.allColumns.addAll(Arrays.asList(join.getPrimaryKeyColumns()));
        }
        for (TblColRef col : this.allColumns) {
            this.allColumnDescs.add(col.getColumnDesc());
        }
    }

    private Set<TableRef> collectTablesOnJoinChain(Set<TblColRef> columns) {
        HashSet<TableRef> result = new HashSet<TableRef>();
        for (TblColRef col : columns) {
            TableRef t = col.getTableRef();
            while (t != null) {
                result.add(t);
                JoinDesc join = this.model.getJoinByPKSide(t);
                t = join == null ? null : join.getFKSide();
            }
        }
        return result;
    }

    public long getVolatileRange() {
        return this.volatileRange;
    }

    public void setVolatileRange(long volatileRange) {
        this.volatileRange = volatileRange;
    }

    public long getRetentionRange() {
        return this.retentionRange;
    }

    public void setRetentionRange(long retentionRange) {
        this.retentionRange = retentionRange;
    }

    public long[] getAutoMergeTimeRanges() {
        return this.autoMergeTimeRanges;
    }

    public void setAutoMergeTimeRanges(long[] autoMergeTimeRanges) {
        this.autoMergeTimeRanges = autoMergeTimeRanges;
    }

    public boolean isBroken() {
        return !this.errors.isEmpty();
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public String getErrorsAsString() {
        return Joiner.on("; ").join(this.errors);
    }

    public HBaseMappingDesc getHbaseMapping() {
        return this.hbaseMapping;
    }

    public void setHbaseMapping(HBaseMappingDesc hbaseMapping) {
        this.hbaseMapping = hbaseMapping;
    }

    public void setNullStrings(String[] nullStrings) {
        this.nullStrings = nullStrings;
    }

    public boolean supportsLimitPushDown() {
        return this.getStorageType() != 0 && this.getStorageType() != 1;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    @Override
    public int getEngineType() {
        return this.engineType;
    }

    public void setEngineType(int engineType) {
        this.engineType = engineType;
    }

    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public long getPartitionDateEnd() {
        return this.partitionDateEnd;
    }

    public void setPartitionDateEnd(long partitionDateEnd) {
        this.partitionDateEnd = partitionDateEnd;
    }

    public Map<Integer, Long> getPartitionOffsetStart() {
        return this.partitionOffsetStart;
    }

    public void setPartitionOffsetStart(Map<Integer, Long> partitionOffsetStart) {
        this.partitionOffsetStart = partitionOffsetStart;
    }

    public Set<Long> getAllCuboids() {
        return this.getInitialCuboidScheduler().getAllCuboidIds();
    }

    public int getParentForward() {
        return this.parentForward;
    }

    public void setParentForward(int parentForward) {
        this.parentForward = parentForward;
    }

    public Set<TblColRef> getAllColumnsNeedDictionaryForBuildingOnly() {
        HashSet<TblColRef> result = Sets.newHashSet();
        HashSet colsNeedDictStored = Sets.newHashSet();
        for (MeasureDesc measure : this.measures) {
            FunctionDesc func = measure.getFunction();
            MeasureType<?> aggrType = func.getMeasureType();
            HashSet<TblColRef> colSet = Sets.newHashSet();
            colSet.addAll(aggrType.getColumnsNeedDictionary(func));
            colSet.removeAll(aggrType.getColumnsNeedDictionaryForBuildingOnly(func));
            colsNeedDictStored.addAll(colSet);
            result.addAll(aggrType.getColumnsNeedDictionaryForBuildingOnly(func));
        }
        colsNeedDictStored.addAll(this.getAllDimsHaveDictionary());
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                TblColRef col = dictDesc.getColumnRef();
                colsNeedDictStored.add(col);
            }
        }
        result.removeAll(colsNeedDictStored);
        return result;
    }

    public Set<TblColRef> getAllDimsHaveDictionary() {
        HashSet<TblColRef> result = Sets.newHashSet();
        for (RowKeyColDesc rowKeyColDesc : this.rowkey.getRowKeyColumns()) {
            TblColRef colRef = rowKeyColDesc.getColRef();
            if (!this.rowkey.isUseDictionary(colRef)) continue;
            result.add(colRef);
        }
        return result;
    }

    public Set<TblColRef> getAllColumnsHaveDictionary() {
        String mrHiveDictColumns;
        LinkedHashSet<TblColRef> result = Sets.newLinkedHashSet();
        result.addAll(this.getAllDimsHaveDictionary());
        for (MeasureDesc measure : this.measures) {
            MeasureType<?> aggrType = measure.getFunction().getMeasureType();
            result.addAll(aggrType.getColumnsNeedDictionary(measure.getFunction()));
        }
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                TblColRef col = dictDesc.getColumnRef();
                result.add(col);
            }
        }
        if (this.overrideKylinProps.containsKey("kylin.dictionary.mr-hive.columns") && StringUtils.isNotEmpty(mrHiveDictColumns = this.overrideKylinProps.get("kylin.dictionary.mr-hive.columns"))) {
            String[] mrHiveDictColumnArr;
            for (String dictColumn : mrHiveDictColumnArr = mrHiveDictColumns.split(",")) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    TblColRef colRef = (TblColRef)it.next();
                    String aliasCol = colRef.getTableAlias() + "_" + colRef.getName();
                    if (!aliasCol.equalsIgnoreCase(dictColumn)) continue;
                    logger.debug("Remove column {} because it has been built by MR", (Object)aliasCol);
                    it.remove();
                }
            }
        }
        return result;
    }

    public Set<TblColRef> getAllColumnsNeedDictionaryBuilt() {
        Set<TblColRef> result = this.getAllColumnsHaveDictionary();
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                if (dictDesc.getResuseColumnRef() != null) {
                    result.remove(dictDesc.getColumnRef());
                    result.add(dictDesc.getResuseColumnRef());
                }
                if (!Objects.isNull(dictDesc.getResuseColumnRef()) || !Objects.nonNull(dictDesc.getReuseColumn())) continue;
                logger.info("tiretree global domain dic : column {} use tiretree global domain dic, reuse column {} ", (Object)dictDesc.getColumnRef(), (Object)dictDesc.getReuseColumn());
                result.remove(dictDesc.getColumnRef());
            }
        }
        return result;
    }

    public List<CubeDescTiretreeGlobalDomainDictUtil.GlobalDict> listDomainDict() {
        ArrayList<CubeDescTiretreeGlobalDomainDictUtil.GlobalDict> dicts = new ArrayList<CubeDescTiretreeGlobalDomainDictUtil.GlobalDict>();
        if (this.dictionaries != null && this.dictionaries.size() > 0) {
            for (DictionaryDesc dictionaryDesc : this.dictionaries) {
                if (!dictionaryDesc.isDomain()) continue;
                dicts.add(new CubeDescTiretreeGlobalDomainDictUtil.GlobalDict(dictionaryDesc.getColumnRef(), dictionaryDesc.getReuseColumn(), dictionaryDesc.getCube(), dictionaryDesc.getModel()));
            }
        }
        return dicts;
    }

    public TblColRef getDictionaryReuseColumn(TblColRef col) {
        if (this.dictionaries == null) {
            return col;
        }
        for (DictionaryDesc dictDesc : this.dictionaries) {
            if (!dictDesc.getColumnRef().equals(col) || dictDesc.getResuseColumnRef() == null) continue;
            return dictDesc.getResuseColumnRef();
        }
        return col;
    }

    public TblColRef getDistributedByColumn() {
        Set<TblColRef> shardBy = this.getShardByColumns();
        if (shardBy != null && shardBy.size() > 0) {
            return shardBy.iterator().next();
        }
        return null;
    }

    public List<SnapshotTableDesc> getSnapshotTableDescList() {
        return this.snapshotTableDescList;
    }

    public void setSnapshotTableDescList(List<SnapshotTableDesc> snapshotTableDescList) {
        this.snapshotTableDescList = snapshotTableDescList;
    }

    public SnapshotTableDesc getSnapshotTableDesc(String tableName) {
        for (SnapshotTableDesc snapshotTableDesc : this.snapshotTableDescList) {
            if (!snapshotTableDesc.getTableName().equalsIgnoreCase(tableName)) continue;
            return snapshotTableDesc;
        }
        return null;
    }

    public boolean isGlobalSnapshotTable(String tableName) {
        SnapshotTableDesc desc = this.getSnapshotTableDesc(tableName);
        if (desc == null) {
            return false;
        }
        return desc.isGlobal();
    }

    public void createAndSetSnapshotTableGlobal(String tableName, boolean global) {
        SnapshotTableDesc desc = this.getSnapshotTableDesc(tableName);
        if (desc == null) {
            SnapshotTableDesc newDesc = new SnapshotTableDesc();
            newDesc.setGlobal(global);
            newDesc.setTableName(tableName);
            this.snapshotTableDescList.add(newDesc);
        } else {
            desc.setGlobal(global);
        }
    }

    public Set<String> getInMemLookupTables() {
        HashSet<String> snapshots = Sets.newHashSet();
        for (DimensionDesc dim : this.getDimensions()) {
            TableRef table = dim.getTableRef();
            if (!this.getModel().isLookupTable(table) || this.isExtSnapshotTable(table.getTableIdentity())) continue;
            snapshots.add(table.getTableIdentity());
        }
        return snapshots;
    }

    public boolean isExtSnapshotTable(String tableName) {
        SnapshotTableDesc desc = this.getSnapshotTableDesc(tableName);
        if (desc == null) {
            return false;
        }
        return desc.isExtSnapshotTable();
    }

    public List<String> getAllExtLookupSnapshotTypes() {
        ArrayList<String> result = Lists.newArrayList();
        for (SnapshotTableDesc snapshotTableDesc : this.snapshotTableDescList) {
            if (!snapshotTableDesc.isExtSnapshotTable()) continue;
            result.add(snapshotTableDesc.getStorageType());
        }
        return result;
    }

    public boolean isStreamingCube() {
        return this.getModel().getRootFactTable().getTableDesc().isStreamingTable();
    }

    TblColRef getClusteredByColumn() {
        if (this.getDistributedByColumn() != null) {
            return null;
        }
        if (this.dictionaries == null) {
            return null;
        }
        String clusterByColumn = this.config.getFlatHiveTableClusterByDictColumn();
        for (DictionaryDesc dictDesc : this.dictionaries) {
            if (!dictDesc.getColumnRef().getName().equalsIgnoreCase(clusterByColumn)) continue;
            return dictDesc.getColumnRef();
        }
        return null;
    }

    public String getDictionaryBuilderClass(TblColRef col) {
        if (this.dictionaries == null) {
            return null;
        }
        for (DictionaryDesc desc : this.dictionaries) {
            if (desc.getBuilderClass() == null || !col.equals(desc.getColumnRef())) continue;
            return desc.getBuilderClass();
        }
        return null;
    }

    private List<TblColRef> getAllGlobalDictColumns() {
        List<DictionaryDesc> dictionaryDescList = this.getDictionaries();
        if (dictionaryDescList == null) {
            return new ArrayList<TblColRef>();
        }
        return dictionaryDescList.stream().filter(dict -> {
            String cls = dict.getBuilderClass();
            return GlobalDictionaryBuilder.class.getName().equals(cls) || SegmentAppendTrieDictBuilder.class.getName().equals(cls);
        }).map(DictionaryDesc::getColumnRef).collect(Collectors.toList());
    }

    public List<TblColRef> getAllGlobalDictColumnsNeedBuilt() {
        HashSet<String> mrhiveDictColumns = new HashSet<String>(Arrays.asList(this.config.getMrHiveDictColumns()));
        List<TblColRef> allGlobalDictColumns = this.getAllGlobalDictColumns();
        return allGlobalDictColumns.stream().filter(col -> !mrhiveDictColumns.contains(col.getTableAlias() + "_" + col.getName())).collect(Collectors.toList());
    }

    public boolean isShrunkenDictFromGlobalEnabled() {
        return this.config.isShrunkenDictFromGlobalEnabled() && !this.getAllGlobalDictColumnsNeedBuilt().isEmpty();
    }

    public List<TblColRef> getAllUHCColumns() {
        ArrayList<TblColRef> uhcColumns = new ArrayList<TblColRef>();
        uhcColumns.addAll(this.getAllGlobalDictColumnsNeedBuilt());
        uhcColumns.addAll(this.getShardByColumns());
        return uhcColumns;
    }

    public String getProject() {
        DataModelDesc modelDesc = this.getModel();
        if (modelDesc == null) {
            List<ProjectInstance> ownerPrj = ProjectManager.getInstance(this.config).findProjects(RealizationType.CUBE, this.name);
            if (ownerPrj.size() == 1) {
                return ownerPrj.get(0).getName();
            }
            throw new IllegalStateException("No project found for cube " + this.name);
        }
        return this.getModel().getProject();
    }

    public static CubeDesc getCopyOf(CubeDesc cubeDesc) {
        CubeDesc newCubeDesc = new CubeDesc();
        newCubeDesc.setName(cubeDesc.getName());
        newCubeDesc.setDraft(cubeDesc.isDraft());
        newCubeDesc.setModelName(cubeDesc.getModelName());
        newCubeDesc.setDescription(cubeDesc.getDescription());
        newCubeDesc.setNullStrings(cubeDesc.getNullStrings());
        newCubeDesc.setDimensions(cubeDesc.getDimensions());
        newCubeDesc.setMeasures(cubeDesc.getMeasures());
        newCubeDesc.setDictionaries(cubeDesc.getDictionaries());
        newCubeDesc.setRowkey(cubeDesc.getRowkey());
        newCubeDesc.setHbaseMapping(cubeDesc.getHbaseMapping());
        newCubeDesc.setSignature(cubeDesc.getSignature());
        newCubeDesc.setNotifyList(cubeDesc.getNotifyList());
        newCubeDesc.setStatusNeedNotify(cubeDesc.getStatusNeedNotify());
        newCubeDesc.setAutoMergeTimeRanges(cubeDesc.getAutoMergeTimeRanges());
        newCubeDesc.setPartitionDateStart(cubeDesc.getPartitionDateStart());
        newCubeDesc.setPartitionDateEnd(cubeDesc.getPartitionDateEnd());
        newCubeDesc.setVolatileRange(cubeDesc.getVolatileRange());
        newCubeDesc.setRetentionRange(cubeDesc.getRetentionRange());
        newCubeDesc.setEngineType(cubeDesc.getEngineType());
        newCubeDesc.setStorageType(cubeDesc.getStorageType());
        newCubeDesc.setAggregationGroups(cubeDesc.getAggregationGroups());
        newCubeDesc.setOverrideKylinProps(cubeDesc.getOverrideKylinProps());
        newCubeDesc.setConfig((KylinConfigExt)cubeDesc.getConfig());
        newCubeDesc.setPartitionOffsetStart(cubeDesc.getPartitionOffsetStart());
        newCubeDesc.setVersion(cubeDesc.getVersion());
        newCubeDesc.setParentForward(cubeDesc.getParentForward());
        newCubeDesc.setSnapshotTableDescList(cubeDesc.getSnapshotTableDescList());
        newCubeDesc.setMandatoryDimensionSetList(cubeDesc.getMandatoryDimensionSetList());
        newCubeDesc.updateRandomUuid();
        return newCubeDesc;
    }

    private Collection ensureOrder(Collection c) {
        TreeSet<String> set = new TreeSet<String>();
        for (Object o : c) {
            set.add(o.toString());
        }
        return set;
    }

    public static class DeriveInfo
    implements Serializable {
        public DeriveType type;
        public JoinDesc join;
        public TblColRef[] columns;
        public boolean isOneToOne;

        DeriveInfo(DeriveType type, JoinDesc join, TblColRef[] columns, boolean isOneToOne) {
            this.type = type;
            this.join = join;
            this.columns = columns;
            this.isOneToOne = isOneToOne;
        }

        public String toString() {
            return "DeriveInfo [type=" + this.type + ", join=" + this.join + ", columns=" + Arrays.toString(this.columns) + ", isOneToOne=" + this.isOneToOne + "]";
        }
    }

    public static enum DeriveType implements Serializable
    {
        LOOKUP,
        PK_FK,
        EXTENDED_COLUMN;

    }

    public static class CannotFilterExtendedColumnException
    extends RuntimeException {
        public CannotFilterExtendedColumnException(TblColRef tblColRef) {
            super(tblColRef == null ? "null" : tblColRef.getCanonicalName());
        }
    }
}

