/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;

public class FlinkOnYarnConfigMapping {
    public static final Map<String, String> flinkOnYarnConfigMap = new HashMap<String, String>();

    static {
        ConfigOption jmHeapSizeOption = JobManagerOptions.JOB_MANAGER_HEAP_MEMORY;
        flinkOnYarnConfigMap.put(jmHeapSizeOption.key(), "-yjm");
        if (jmHeapSizeOption.hasFallbackKeys()) {
            Iterator deprecatedKeyIterator = jmHeapSizeOption.fallbackKeys().iterator();
            while (deprecatedKeyIterator.hasNext()) {
                flinkOnYarnConfigMap.put(((FallbackKey)deprecatedKeyIterator.next()).getKey(), "-yjm");
            }
        }
        ConfigOption tmHeapSizeOption = TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY;
        flinkOnYarnConfigMap.put(tmHeapSizeOption.key(), "-ytm");
        if (tmHeapSizeOption.hasFallbackKeys()) {
            Iterator deprecatedKeyIterator = tmHeapSizeOption.fallbackKeys().iterator();
            while (deprecatedKeyIterator.hasNext()) {
                flinkOnYarnConfigMap.put(((FallbackKey)deprecatedKeyIterator.next()).getKey(), "-ytm");
            }
        }
        ConfigOption taskSlotNumOption = TaskManagerOptions.NUM_TASK_SLOTS;
        flinkOnYarnConfigMap.put(taskSlotNumOption.key(), "-ys");
        if (taskSlotNumOption.hasFallbackKeys()) {
            Iterator deprecatedKeyIterator = taskSlotNumOption.fallbackKeys().iterator();
            while (deprecatedKeyIterator.hasNext()) {
                flinkOnYarnConfigMap.put(((FallbackKey)deprecatedKeyIterator.next()).getKey(), "-ys");
            }
        }
        ConfigOption tmMemoryPreallocate = TaskManagerOptions.MANAGED_MEMORY_PRE_ALLOCATE;
        flinkOnYarnConfigMap.put(tmMemoryPreallocate.key(), "-yD taskmanager.memory.preallocate");
        if (taskSlotNumOption.hasFallbackKeys()) {
            Iterator deprecatedKeyIterator = tmMemoryPreallocate.fallbackKeys().iterator();
            while (deprecatedKeyIterator.hasNext()) {
                flinkOnYarnConfigMap.put(((FallbackKey)deprecatedKeyIterator.next()).getKey(), "-yD taskmanager.memory.preallocate");
            }
        }
        flinkOnYarnConfigMap.put("yarn.queue", "-yqu");
        flinkOnYarnConfigMap.put("yarn.nodelabel", "-ynl");
    }
}

