/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import org.apache.kylin.shaded.com.google.common.base.Preconditions;

public final class ExecuteResult {
    private final State state;
    private final String output;
    private final Throwable throwable;

    public ExecuteResult() {
        this(State.SUCCEED, "succeed");
    }

    public ExecuteResult(State state) {
        this(state, "");
    }

    public ExecuteResult(State state, String output) {
        this(state, output, null);
    }

    public ExecuteResult(State state, String output, Throwable throwable) {
        Preconditions.checkArgument(state != null, "state cannot be null");
        this.state = state;
        this.output = output;
        this.throwable = throwable;
    }

    public static ExecuteResult createSucceed() {
        return new ExecuteResult(State.SUCCEED, "succeed");
    }

    public static ExecuteResult createError(Throwable throwable) {
        Preconditions.checkArgument(throwable != null, "throwable cannot be null");
        return new ExecuteResult(State.ERROR, throwable.getLocalizedMessage(), throwable);
    }

    public static ExecuteResult createFailed(Throwable throwable) {
        Preconditions.checkArgument(throwable != null, "throwable cannot be null");
        return new ExecuteResult(State.FAILED, throwable.getLocalizedMessage(), throwable);
    }

    public State state() {
        return this.state;
    }

    public boolean succeed() {
        return this.state == State.SUCCEED;
    }

    public String output() {
        return this.output;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static enum State {
        SUCCEED,
        FAILED,
        ERROR,
        DISCARDED,
        STOPPED;

    }
}

