/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableWindowBridge;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPUnionRel;
import org.apache.kylin.tool.shaded.org.apache.commons.compress.utils.Lists;

public class OLAPWindowRel
extends Window
implements OLAPRel {
    ColumnRowType columnRowType;
    OLAPContext context;

    public OLAPWindowRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traitSet, input, constants, rowType, groups);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getConvention() == input.getConvention() ? 1 : 0) != 0);
    }

    public Window copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 1);
        return new OLAPWindowRel(this.getCluster(), traitSet, inputs.get(0), (List<RexLiteral>)this.constants, this.rowType, (List<Window.Group>)this.groups);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization)).itemIf("constants", (Object)this.constants, !this.constants.isEmpty()).itemIf("groups", (Object)this.groups, !this.groups.isEmpty());
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.fixSharedOlapTableScan((SingleRel)this);
        implementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        this.context = implementor.getContext();
        this.context.hasWindow = true;
    }

    ColumnRowType buildColumnRowType() {
        OLAPRel olapChild = (OLAPRel)this.getInput(0);
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        columns.addAll(inputColumnRowType.getAllColumns());
        for (Window.Group group : this.groups) {
            if (olapChild instanceof OLAPUnionRel) {
                for (AggregateCall aggrCall : group.getAggregateCalls((Window)this)) {
                    TblColRef aggrCallCol = TblColRef.newInnerColumn(aggrCall.getName(), TblColRef.InnerDataTypeEnum.LITERAL);
                    columns.add(aggrCallCol);
                }
                continue;
            }
            ArrayList sourceColOuter = Lists.newArrayList();
            group.keys.asSet().stream().map(inputColumnRowType::getTupleExpressionByIndex).forEach(sourceColOuter::add);
            group.orderKeys.getFieldCollations().stream().map(RelFieldCollation::getFieldIndex).map(inputColumnRowType::getTupleExpressionByIndex).forEach(sourceColOuter::add);
            for (AggregateCall aggrCall : group.getAggregateCalls((Window)this)) {
                TblColRef aggrCallCol = TblColRef.newInnerColumn(aggrCall.getName(), TblColRef.InnerDataTypeEnum.LITERAL);
                ArrayList<TupleExpression> sourceColInner = Lists.newArrayList(sourceColOuter.iterator());
                aggrCall.getArgList().stream().filter(i -> i < inputColumnRowType.size()).map(inputColumnRowType::getTupleExpressionByIndex).forEach(sourceColInner::add);
                aggrCallCol.setSubTupleExps(sourceColInner);
                columns.add(aggrCallCol);
            }
        }
        return new ColumnRowType(columns);
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        for (RelNode child : this.getInputs()) {
            implementor.visitChild(this, child);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        for (EnumerableRel input : inputs) {
            if (!(input instanceof OLAPRel)) continue;
            ((OLAPRel)input).replaceTraitSet((RelTrait)EnumerableConvention.INSTANCE);
        }
        return EnumerableWindowBridge.createEnumerableWindow((RelOptCluster)this.getCluster(), (RelTraitSet)this.traitSet, (RelNode)((RelNode)inputs.get(0)), (List)this.constants, (RelDataType)this.rowType, (List)this.groups);
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        for (RelNode child : this.getInputs()) {
            if (!((OLAPRel)child).hasSubQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

