/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.IInput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.spark.SparkCreatingFlatTable;
import org.apache.kylin.engine.spark.SparkExecutable;
import org.apache.kylin.engine.spark.SparkExecutableFactory;
import org.apache.kylin.engine.spark.SparkSqlBatch;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.util.FlatTableSqlQuoteUtils;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.source.hive.CreateFlatHiveTableByLivyStep;
import org.apache.kylin.source.hive.CreateFlatHiveTableStep;
import org.apache.kylin.source.hive.CreateMrHiveDictStep;
import org.apache.kylin.source.hive.GarbageCollectionStep;
import org.apache.kylin.source.hive.MRHiveDictUtil;
import org.apache.kylin.source.hive.RedistributeFlatHiveTableByLivyStep;
import org.apache.kylin.source.hive.RedistributeFlatHiveTableStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveInputBase {
    private static final Logger logger = LoggerFactory.getLogger(HiveInputBase.class);

    protected static String getTableNameForHCat(TableDesc table, String uuid) {
        String tableName = table.isView() ? table.getMaterializedName(uuid) : table.getName();
        String database = table.isView() ? KylinConfig.getInstanceFromEnv().getHiveDatabaseForIntermediateTable() : table.getDatabase();
        return String.format(Locale.ROOT, "%s.%s", database, tableName).toUpperCase(Locale.ROOT);
    }

    protected static AbstractExecutable createFlatHiveTableStep(String hiveInitStatements, String jobWorkingDir, String cubeName, IJoinedFlatTableDesc flatDesc) {
        String dropTableHql = JoinedFlatTable.generateDropTableStatement(flatDesc);
        String createTableHql = JoinedFlatTable.generateCreateTableStatement(flatDesc, jobWorkingDir);
        String insertDataHqls = JoinedFlatTable.generateInsertDataStatement(flatDesc);
        CreateFlatHiveTableStep step = new CreateFlatHiveTableStep();
        step.setInitStatement(hiveInitStatements);
        step.setCreateTableStatement(dropTableHql + createTableHql + insertDataHqls);
        CubingExecutableUtil.setCubeName(cubeName, step.getParams());
        step.setName("Create Intermediate Flat Hive Table");
        return step;
    }

    protected static AbstractExecutable createFlatHiveTableByLivyStep(String hiveInitStatements, String jobWorkingDir, String cubeName, IJoinedFlatTableDesc flatDesc) {
        String dropTableHql = JoinedFlatTable.generateDropTableStatement(flatDesc);
        String createTableHql = JoinedFlatTable.generateCreateTableStatement(flatDesc, jobWorkingDir);
        String insertDataHqls = JoinedFlatTable.generateInsertDataStatement(flatDesc);
        CreateFlatHiveTableByLivyStep step = new CreateFlatHiveTableByLivyStep();
        step.setInitStatement(hiveInitStatements);
        step.setCreateTableStatement(dropTableHql + createTableHql + insertDataHqls);
        CubingExecutableUtil.setCubeName(cubeName, step.getParams());
        step.setName("Create Intermediate Flat Hive Table");
        return step;
    }

    protected static AbstractExecutable createFlatHiveTableBySparkSql(String hiveInitStatements, String jobWorkingDir, String cubeName, IJoinedFlatTableDesc flatDesc) {
        String dropTableHql = JoinedFlatTable.generateDropTableStatement(flatDesc);
        String createTableHql = JoinedFlatTable.generateCreateTableStatement(flatDesc, jobWorkingDir);
        String insertDataHqls = JoinedFlatTable.generateInsertDataStatement(flatDesc);
        KylinConfig config = flatDesc.getSegment().getConfig();
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(config);
        sparkExecutable.setName("Create Intermediate Flat Table With Spark");
        sparkExecutable.setClassName(SparkCreatingFlatTable.class.getName());
        sparkExecutable.setParam(SparkSqlBatch.OPTION_CUBE_NAME.getOpt(), cubeName);
        sparkExecutable.setParam(SparkSqlBatch.OPTION_STEP_NAME.getOpt(), HiveInputBase.base64EncodeStr("Create Intermediate Flat Table With Spark"));
        sparkExecutable.setParam(SparkSqlBatch.OPTION_SEGMENT_ID.getOpt(), flatDesc.getSegment().getName());
        sparkExecutable.setParam(SparkSqlBatch.OPTION_SQL_COUNT.getOpt(), String.valueOf(5));
        sparkExecutable.setParam(SparkCreatingFlatTable.getSqlOption(0).getOpt(), HiveInputBase.base64EncodeStr(hiveInitStatements));
        sparkExecutable.setParam(SparkCreatingFlatTable.getSqlOption(1).getOpt(), HiveInputBase.base64EncodeStr(dropTableHql));
        String[] sqlArr = createTableHql.trim().split(";");
        if (2 != sqlArr.length) {
            throw new RuntimeException("create table hql should combined by a create table sql and a alter sql, but got: " + createTableHql);
        }
        sparkExecutable.setParam(SparkCreatingFlatTable.getSqlOption(2).getOpt(), HiveInputBase.base64EncodeStr(sqlArr[0]));
        sparkExecutable.setParam(SparkCreatingFlatTable.getSqlOption(3).getOpt(), HiveInputBase.base64EncodeStr(sqlArr[1]));
        sparkExecutable.setParam(SparkCreatingFlatTable.getSqlOption(4).getOpt(), HiveInputBase.base64EncodeStr(insertDataHqls));
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, config.getSparkAdditionalJars());
        sparkExecutable.setJars(jars.toString());
        return sparkExecutable;
    }

    private static String base64EncodeStr(String str) {
        return new String(Base64.getEncoder().encode(str.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    protected static AbstractExecutable createRedistributeFlatHiveTableStep(String hiveInitStatements, String cubeName, IJoinedFlatTableDesc flatDesc, CubeDesc cubeDesc) {
        RedistributeFlatHiveTableStep step = new RedistributeFlatHiveTableStep();
        step.setInitStatement(hiveInitStatements);
        step.setIntermediateTable(flatDesc.getTableName());
        step.setRedistributeDataStatement(JoinedFlatTable.generateRedistributeFlatTableStatement(flatDesc, cubeDesc));
        CubingExecutableUtil.setCubeName(cubeName, step.getParams());
        step.setName("Redistribute Flat Hive Table");
        return step;
    }

    protected static AbstractExecutable createRedistributeFlatHiveTableByLivyStep(String hiveInitStatements, String cubeName, IJoinedFlatTableDesc flatDesc, CubeDesc cubeDesc) {
        RedistributeFlatHiveTableByLivyStep step = new RedistributeFlatHiveTableByLivyStep();
        step.setInitStatement(hiveInitStatements);
        step.setIntermediateTable(flatDesc.getTableName());
        step.setRedistributeDataStatement(JoinedFlatTable.generateRedistributeFlatTableStatement(flatDesc, cubeDesc));
        CubingExecutableUtil.setCubeName(cubeName, step.getParams());
        step.setName("Redistribute Flat Hive Table");
        return step;
    }

    protected static ShellExecutable createLookupHiveViewMaterializationStep(String hiveInitStatements, String jobWorkingDir, IJoinedFlatTableDesc flatDesc, List<String> intermediateTables, String uuid) {
        ShellExecutable step = new ShellExecutable();
        step.setName("Materialize Hive View in Lookup Tables");
        KylinConfig kylinConfig = flatDesc.getSegment().getConfig();
        TableMetadataManager metadataManager = TableMetadataManager.getInstance(kylinConfig);
        HashSet<TableDesc> lookupViewsTables = Sets.newHashSet();
        String prj = flatDesc.getDataModel().getProject();
        for (JoinTableDesc lookupDesc : flatDesc.getDataModel().getJoinTables()) {
            TableDesc tableDesc = metadataManager.getTableDesc(lookupDesc.getTable(), prj);
            if (lookupDesc.getKind() != DataModelDesc.TableKind.LOOKUP || !tableDesc.isView()) continue;
            lookupViewsTables.add(tableDesc);
        }
        if (lookupViewsTables.size() == 0) {
            return null;
        }
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.overwriteHiveProps(kylinConfig.getHiveConfigOverride());
        hiveCmdBuilder.addStatement(hiveInitStatements);
        for (TableDesc lookUpTableDesc : lookupViewsTables) {
            String identity = FlatTableSqlQuoteUtils.quoteTableIdentity(lookUpTableDesc.getDatabase(), lookUpTableDesc.getName(), null);
            if (!lookUpTableDesc.isView()) continue;
            String intermediate = lookUpTableDesc.getMaterializedName(uuid);
            String materializeViewHql = HiveInputBase.materializeViewHql(intermediate, identity, jobWorkingDir);
            hiveCmdBuilder.addStatement(materializeViewHql);
            intermediateTables.add(intermediate);
        }
        step.setCmd(hiveCmdBuilder.build());
        return step;
    }

    protected static String materializeViewHql(String viewName, String tableName, String jobWorkingDir) {
        StringBuilder createIntermediateTableHql = new StringBuilder();
        createIntermediateTableHql.append("DROP TABLE IF EXISTS `" + viewName + "`;\n");
        createIntermediateTableHql.append("CREATE TABLE IF NOT EXISTS `" + viewName + "` LIKE " + tableName + " LOCATION '" + jobWorkingDir + "/" + viewName + "';\n");
        createIntermediateTableHql.append("ALTER TABLE `" + viewName + "` SET TBLPROPERTIES('auto.purge'='true');\n");
        createIntermediateTableHql.append("INSERT OVERWRITE TABLE `" + viewName + "` SELECT * FROM " + tableName + ";\n");
        return createIntermediateTableHql.toString();
    }

    protected static String getJobWorkingDir(DefaultChainedExecutable jobFlow, String hdfsWorkingDir) {
        String jobWorkingDir = JobBuilderSupport.getJobWorkingDir(hdfsWorkingDir, jobFlow.getId());
        if (KylinConfig.getInstanceFromEnv().getHiveTableDirCreateFirst()) {
            HiveInputBase.checkAndCreateWorkDir(jobWorkingDir);
        }
        return jobWorkingDir;
    }

    protected static void checkAndCreateWorkDir(String jobWorkingDir) {
        try {
            Path path = new Path(jobWorkingDir);
            FileSystem fileSystem = HadoopUtil.getFileSystem(path);
            if (!fileSystem.exists(path)) {
                logger.info("Create jobWorkDir : " + jobWorkingDir);
                fileSystem.mkdirs(path);
            }
        }
        catch (IOException e) {
            logger.error("Could not create lookUp table dir : " + jobWorkingDir);
        }
    }

    public static class BaseBatchCubingInputSide
    implements IInput.IBatchCubingInputSide {
        protected final IJoinedFlatTableDesc flatDesc;
        protected final String flatTableDatabase;
        protected final String hdfsWorkingDir;
        List<String> hiveViewIntermediateTables = Lists.newArrayList();

        public BaseBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            this.flatDesc = flatDesc;
            this.flatTableDatabase = config.getHiveDatabaseForIntermediateTable();
            this.hdfsWorkingDir = config.getHdfsWorkingDirectory();
        }

        @Override
        public void addStepPhase1_CreateFlatTable(DefaultChainedExecutable jobFlow) {
            String cubeName = CubingExecutableUtil.getCubeName(jobFlow.getParams());
            CubeInstance cubeInstance = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(cubeName);
            KylinConfig cubeConfig = cubeInstance.getConfig();
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            this.addStepPhase1_DoCreateFlatTable(jobFlow);
            KylinConfig dictConfig = this.flatDesc.getSegment().getConfig();
            String[] mrHiveDictColumns = dictConfig.getMrHiveDictColumnsExcludeRefColumns();
            if (Objects.nonNull(mrHiveDictColumns) && mrHiveDictColumns.length > 0 && !"".equals(mrHiveDictColumns[0])) {
                this.addStepPhase1_DoCreateMrHiveGlobalDict(jobFlow, mrHiveDictColumns);
            }
            if (cubeConfig.isHiveRedistributeEnabled()) {
                KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
                if (kylinConfig.isLivyEnabled() && cubeInstance.getEngineType() == 4) {
                    jobFlow.addTask(HiveInputBase.createRedistributeFlatHiveTableByLivyStep(hiveInitStatements, cubeName, this.flatDesc, cubeInstance.getDescriptor()));
                } else {
                    jobFlow.addTask(HiveInputBase.createRedistributeFlatHiveTableStep(hiveInitStatements, cubeName, this.flatDesc, cubeInstance.getDescriptor()));
                }
            }
            this.addStepPhase1_DoMaterializeLookupTable(jobFlow);
        }

        @Override
        public void addStepPhase_ReplaceFlatTableGlobalColumnValue(DefaultChainedExecutable jobFlow) {
            KylinConfig dictConfig = this.flatDesc.getSegment().getConfig();
            String cubeName = CubingExecutableUtil.getCubeName(jobFlow.getParams());
            String globalDictTable = MRHiveDictUtil.globalDictTableName(this.flatDesc, cubeName);
            String globalDictDatabase = dictConfig.getMrHiveDictDB();
            String[] mrHiveDictColumnsExcludeRefCols = dictConfig.getMrHiveDictColumnsExcludeRefColumns();
            Map<String, String> dictRef = dictConfig.getMrHiveDictRefColumns();
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            if (Objects.nonNull(mrHiveDictColumnsExcludeRefCols) && mrHiveDictColumnsExcludeRefCols.length > 0) {
                jobFlow.addTask(BaseBatchCubingInputSide.createHiveGlobalDictMergeGlobalDict(this.flatDesc, hiveInitStatements, cubeName, mrHiveDictColumnsExcludeRefCols, globalDictDatabase, globalDictTable));
                for (String item : mrHiveDictColumnsExcludeRefCols) {
                    dictRef.put(item, "");
                }
            }
            if (!dictRef.isEmpty()) {
                jobFlow.addTask(BaseBatchCubingInputSide.createMrHiveGlobalDictReplaceStep(this.flatDesc, hiveInitStatements, cubeName, dictRef, this.flatTableDatabase, globalDictDatabase, globalDictTable, dictConfig.getMrHiveDictTableSuffix(), jobFlow.getId()));
            }
        }

        protected void addStepPhase1_DoCreateMrHiveGlobalDict(DefaultChainedExecutable jobFlow, String[] mrHiveDictColumns) {
            String cubeName = CubingExecutableUtil.getCubeName(jobFlow.getParams());
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            jobFlow.addTask(BaseBatchCubingInputSide.createMrHiveGlobalDictExtractStep(this.flatDesc, hiveInitStatements, cubeName, mrHiveDictColumns, jobFlow.getId()));
        }

        protected static AbstractExecutable createMrHiveGlobalDictExtractStep(IJoinedFlatTableDesc flatDesc, String hiveInitStatements, String cubeName, String[] mrHiveDictColumns, String jobId) {
            KylinConfig cfg = flatDesc.getSegment().getConfig();
            String globalDictTable = MRHiveDictUtil.globalDictTableName(flatDesc, cubeName);
            String globalDictDatabase = cfg.getMrHiveDictDB();
            String distinctValueTable = MRHiveDictUtil.distinctValueTable(flatDesc);
            String segmentLevelDictTableName = MRHiveDictUtil.segmentLevelDictTableName(flatDesc);
            String createGlobalDictTableHql = MRHiveDictUtil.generateDictionaryDdl(flatDesc, globalDictDatabase, globalDictTable);
            String dropDistinctValueTableHql = MRHiveDictUtil.generateDropTableStatement(distinctValueTable);
            String createDistinctValueTableHql = MRHiveDictUtil.generateDistinctValueTableStatement(flatDesc);
            String dropSegmentLevelDictTableHql = MRHiveDictUtil.generateDropTableStatement(segmentLevelDictTableName);
            String createSegmentLevelDictTableHql = MRHiveDictUtil.generateDictTableStatement(flatDesc, segmentLevelDictTableName);
            String maxAndDistinctCountSql = MRHiveDictUtil.generateDictStatisticsSql(distinctValueTable, globalDictTable, globalDictDatabase);
            StringBuilder insertDataToDictIntermediateTableSql = new StringBuilder();
            for (String dictColumn : mrHiveDictColumns) {
                insertDataToDictIntermediateTableSql.append(MRHiveDictUtil.generateInsertDataStatement(flatDesc, dictColumn, globalDictDatabase, globalDictTable));
            }
            String setParametersHql = "set hive.exec.compress.output=false;set hive.mapred.mode=unstrict;";
            CreateMrHiveDictStep step = new CreateMrHiveDictStep();
            step.setInitStatement(hiveInitStatements);
            step.setCreateTableStatement(setParametersHql + createGlobalDictTableHql + dropDistinctValueTableHql + createDistinctValueTableHql + dropSegmentLevelDictTableHql + createSegmentLevelDictTableHql + insertDataToDictIntermediateTableSql.toString() + maxAndDistinctCountSql);
            CubingExecutableUtil.setCubeName(cubeName, step.getParams());
            step.setName("Build Hive Global Dict - extract distinct value");
            step.setIsLock(true);
            step.setIsUnLock(false);
            step.setLockPathName(cubeName);
            step.setJobFlowJobId(jobId);
            return step;
        }

        protected static AbstractExecutable createHiveGlobalDictMergeGlobalDict(IJoinedFlatTableDesc flatDesc, String hiveInitStatements, String cubeName, String[] mrHiveDictColumns, String globalDictDatabase, String globalDictTable) {
            String globalDictIntermediateTable = MRHiveDictUtil.segmentLevelDictTableName(flatDesc);
            StringBuilder addPartitionHql = new StringBuilder();
            HashMap<String, String> dictHqlMap = new HashMap<String, String>();
            for (String dictColumn : mrHiveDictColumns) {
                try {
                    addPartitionHql.append("ALTER TABLE ").append(globalDictIntermediateTable).append(" ADD IF NOT EXISTS PARTITION (dict_column='").append(dictColumn).append("');").append(" \n");
                    String dictHql = "INSERT OVERWRITE TABLE " + globalDictDatabase + "." + globalDictTable + " \nPARTITION (dict_column = '" + dictColumn + "') \nSELECT dict_key, dict_val FROM " + globalDictDatabase + "." + globalDictTable + " \nWHERE dict_column = '" + dictColumn + "' \n" + flatDesc.getDataModel().getConfig().getHiveUnionStyle() + " \nSELECT dict_key, dict_val FROM " + globalDictIntermediateTable + " \n WHERE dict_column = '" + dictColumn + "' ;\n";
                    dictHqlMap.put(dictColumn, dictHql);
                }
                catch (Exception e) {
                    logger.error("", e);
                }
            }
            String hiveInitStatementForUnstrict = "set hive.mapred.mode=unstrict;";
            CreateMrHiveDictStep step = new CreateMrHiveDictStep();
            step.setInitStatement(hiveInitStatements + hiveInitStatementForUnstrict + addPartitionHql);
            step.setCreateTableStatementMap(dictHqlMap);
            step.setIsLock(false);
            step.setIsUnLock(false);
            step.setLockPathName(cubeName);
            CubingExecutableUtil.setCubeName(cubeName, step.getParams());
            step.setName("Build Hive Global Dict - merge to dict table");
            return step;
        }

        protected static AbstractExecutable createMrHiveGlobalDictReplaceStep(IJoinedFlatTableDesc flatDesc, String hiveInitStatements, String cubeName, Map<String, String> mrHiveDictColumns, String flatTableDatabase, String globalDictDatabase, String globalDictTable, String dictSuffix, String jobId) {
            HashMap<String, String> dictHqlMap = new HashMap<String, String>();
            for (String dictColumn : mrHiveDictColumns.keySet()) {
                StringBuilder insertOverwriteHql = new StringBuilder();
                TblColRef dictColumnRef = null;
                String flatTable = flatTableDatabase + "." + flatDesc.getTableName();
                insertOverwriteHql.append("INSERT OVERWRITE TABLE ").append(flatTable).append(" \n");
                try {
                    insertOverwriteHql.append("SELECT \n");
                    int flatTableColumnSize = flatDesc.getAllColumns().size();
                    for (int i = 0; i < flatTableColumnSize; ++i) {
                        TblColRef tblColRef = flatDesc.getAllColumns().get(i);
                        String colName = JoinedFlatTable.colName(tblColRef, flatDesc.useAlias());
                        if (i > 0) {
                            insertOverwriteHql.append(",");
                        }
                        if (colName.equalsIgnoreCase(dictColumn)) {
                            insertOverwriteHql.append("b.dict_val \n");
                            dictColumnRef = tblColRef;
                            continue;
                        }
                        insertOverwriteHql.append("a.").append(JoinedFlatTable.colName(tblColRef)).append(" \n");
                    }
                    if (!Strings.isNullOrEmpty(mrHiveDictColumns.get(dictColumn))) {
                        String[] tableColumn = mrHiveDictColumns.get(dictColumn).split("\\.");
                        String refGlobalDictTable = tableColumn[0] + dictSuffix;
                        String refDictColumn = tableColumn[1];
                        insertOverwriteHql.append("FROM ").append(flatTable).append(" a \nLEFT OUTER JOIN \n (").append("SELECT dict_key, dict_val FROM ").append(globalDictDatabase).append(".").append(refGlobalDictTable).append(" WHERE dict_column = '").append(refDictColumn).append("') b \n").append("ON a.").append(JoinedFlatTable.colName(dictColumnRef)).append(" = b.dict_key;");
                    } else {
                        insertOverwriteHql.append("FROM ").append(flatTable).append(" a \nLEFT OUTER JOIN \n (").append("SELECT dict_key, dict_val FROM ").append(globalDictDatabase).append(".").append(globalDictTable).append(" WHERE dict_column = '").append(dictColumn).append("') b \n").append("ON a.").append(JoinedFlatTable.colName(dictColumnRef)).append(" = b.dict_key;");
                    }
                    dictHqlMap.put(dictColumn, insertOverwriteHql.toString());
                }
                catch (Exception e) {
                    logger.error("", e);
                }
            }
            String setParameterHal = "set hive.exec.compress.output=false; set hive.mapred.mode=unstrict;";
            CreateMrHiveDictStep step = new CreateMrHiveDictStep();
            step.setInitStatement(hiveInitStatements + setParameterHal);
            step.setCreateTableStatementMap(dictHqlMap);
            step.setIsUnLock(true);
            step.setLockPathName(cubeName);
            step.setJobFlowJobId(jobId);
            CubingExecutableUtil.setCubeName(cubeName, step.getParams());
            step.setName("Build Hive Global Dict - replace intermediate table");
            return step;
        }

        protected void addStepPhase1_DoCreateFlatTable(DefaultChainedExecutable jobFlow) {
            String cubeName = CubingExecutableUtil.getCubeName(jobFlow.getParams());
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            String jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            CubeInstance cubeInstance = CubeManager.getInstance(kylinConfig).getCube(cubeName);
            if (cubeInstance.getEngineType() == 4) {
                if (kylinConfig.isLivyEnabled()) {
                    jobFlow.addTask(HiveInputBase.createFlatHiveTableByLivyStep(hiveInitStatements, jobWorkingDir, cubeName, this.flatDesc));
                } else if (kylinConfig.isSparCreateHiveTableViaSparkEnable()) {
                    jobFlow.addTask(HiveInputBase.createFlatHiveTableBySparkSql(hiveInitStatements, jobWorkingDir, cubeName, this.flatDesc));
                } else {
                    jobFlow.addTask(HiveInputBase.createFlatHiveTableStep(hiveInitStatements, jobWorkingDir, cubeName, this.flatDesc));
                }
            } else {
                jobFlow.addTask(HiveInputBase.createFlatHiveTableStep(hiveInitStatements, jobWorkingDir, cubeName, this.flatDesc));
            }
        }

        protected void addStepPhase1_DoMaterializeLookupTable(DefaultChainedExecutable jobFlow) {
            String jobWorkingDir;
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            ShellExecutable task = HiveInputBase.createLookupHiveViewMaterializationStep(hiveInitStatements, jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir), this.flatDesc, this.hiveViewIntermediateTables, jobFlow.getId());
            if (task != null) {
                jobFlow.addTask(task);
            }
        }

        @Override
        public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
            String jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            GarbageCollectionStep step = new GarbageCollectionStep();
            step.setName("Hive Cleanup");
            ArrayList<String> deleteTables = new ArrayList<String>();
            deleteTables.add(this.getIntermediateTableIdentity());
            String[] mrHiveDicts = this.flatDesc.getSegment().getConfig().getMrHiveDictColumns();
            if (Objects.nonNull(mrHiveDicts) && mrHiveDicts.length > 0) {
                String tableName = this.flatTableDatabase + "." + this.flatDesc.getTableName() + this.flatDesc.getSegment().getConfig().getMrHiveDistinctValueTableSuffix();
                String tableName2 = this.flatTableDatabase + "." + this.flatDesc.getTableName() + this.flatDesc.getSegment().getConfig().getMrHiveDictTableSuffix();
                deleteTables.add(tableName);
                deleteTables.add(tableName2);
            }
            step.setIntermediateTables(deleteTables);
            step.setExternalDataPaths(Collections.singletonList(JoinedFlatTable.getTableDir(this.flatDesc, jobWorkingDir)));
            step.setHiveViewIntermediateTableIdentities(StringUtil.join(this.hiveViewIntermediateTables, ","));
            jobFlow.addTask(step);
        }

        protected String getIntermediateTableIdentity() {
            return this.flatTableDatabase + "." + this.flatDesc.getTableName();
        }
    }
}

