/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.dict;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDictionaryStore {
    private static Logger logger = LoggerFactory.getLogger(RemoteDictionaryStore.class);
    private final byte[] hbaseTableName;
    private final String tableName;
    private final byte[] encodeQualifierName = "encode_value".getBytes(StandardCharsets.UTF_8);
    private final byte[] tsQualifierName = "ts".getBytes(StandardCharsets.UTF_8);
    private Table table;
    private boolean printValue = KylinConfig.getInstanceFromEnv().isPrintRealtimeDictEnabled();

    public RemoteDictionaryStore(String cubeName) {
        this.hbaseTableName = cubeName.getBytes(StandardCharsets.UTF_8);
        this.tableName = cubeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] cfs) throws IOException {
        logger.debug("Checking streaming remote store for {} at {}.", (Object)this.tableName, (Object)String.join((CharSequence)", ", cfs));
        Connection conn = RemoteDictionaryStore.getConnection();
        Admin admin = conn.getAdmin();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])this.hbaseTableName));
        for (String family : cfs) {
            HColumnDescriptor fd = new HColumnDescriptor(family);
            desc.addFamily(fd);
        }
        DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentProcess();
        try {
            boolean locked = lock.lock(this.lockPath());
            if (locked && !admin.tableExists(TableName.valueOf((byte[])this.hbaseTableName))) {
                logger.info("Create htable with {}.", (Object)desc);
                admin.createTable((TableDescriptor)desc);
            } else {
                logger.info("Table exists or cannot fetch lock {}", (Object)desc);
            }
        }
        finally {
            admin.close();
            if (lock != null && lock.isLockedByMe(this.lockPath())) {
                lock.unlock(this.lockPath());
            }
        }
        this.table = conn.getTable(TableName.valueOf((byte[])this.hbaseTableName));
    }

    public int checkAndPutWithRetry(ByteArray columnFamily, String rowkeyStr, int expectedValue, int putValue, boolean checkPrevious) {
        IOException hbaseSideException;
        int retryTimes = 0;
        int encoedId = -1;
        do {
            try {
                encoedId = this.checkAndPut(columnFamily, rowkeyStr, expectedValue, putValue, checkPrevious);
                hbaseSideException = null;
            }
            catch (IOException e) {
                logger.error("CheckAndPut failed at " + rowkeyStr + ", columnFamily " + new String(columnFamily.array(), StandardCharsets.UTF_8), e);
                hbaseSideException = e;
                ++retryTimes;
                try {
                    long sleep = 1000L * (long)(retryTimes <= 10 ? retryTimes : 10);
                    logger.debug("Sleep to wait set succeed for {} ms.", (Object)sleep);
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (hbaseSideException != null);
        return encoedId;
    }

    int checkAndPut(ByteArray columnFamily, String rowkeyStr, int expectedValue, int putValue, boolean checkPrevious) throws IOException {
        byte[] rowkey = rowkeyStr.getBytes(StandardCharsets.UTF_8);
        if (rowkey.length == 0) {
            return 0;
        }
        byte[] valueByte = Integer.toString(putValue).getBytes(StandardCharsets.UTF_8);
        Put put = new Put(rowkey);
        put.addColumn(columnFamily.array(), this.encodeQualifierName, valueByte);
        put.addColumn(columnFamily.array(), this.tsQualifierName, Bytes.toBytes(System.currentTimeMillis()));
        boolean hasPut = this.table.checkAndPut(rowkey, columnFamily.array(), this.encodeQualifierName, checkPrevious ? Integer.toString(expectedValue).getBytes(StandardCharsets.UTF_8) : null, put);
        if (hasPut) {
            if (this.printValue) {
                logger.debug("Encode {} to {}", (Object)rowkeyStr, (Object)putValue);
            }
            return putValue;
        }
        return -2;
    }

    public int encodeWithRetry(ByteArray column, String rowkeyStr) {
        IOException hbaseSideException;
        int retryTimes = 0;
        int encoedId = -2;
        do {
            try {
                encoedId = this.encode(column, rowkeyStr);
                hbaseSideException = null;
            }
            catch (IOException e) {
                logger.error("Encode failed at " + rowkeyStr + ", column " + new String(column.array(), StandardCharsets.UTF_8), e);
                hbaseSideException = e;
                ++retryTimes;
                try {
                    long sleep = 1000L * (long)(retryTimes <= 10 ? retryTimes : 10);
                    logger.debug("Sleep to wait set succeed for {} ms.", (Object)sleep);
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (hbaseSideException != null);
        return encoedId;
    }

    int encode(ByteArray column, String rowkeyStr) throws IOException {
        byte[] rowkey = rowkeyStr.getBytes(StandardCharsets.UTF_8);
        if (rowkey.length == 0) {
            return 0;
        }
        Get get = new Get(rowkey);
        Result res = this.table.get(get);
        byte[] resBytes = res.getValue(column.array(), this.encodeQualifierName);
        byte[] tsBytes = res.getValue(column.array(), this.tsQualifierName);
        String realId = new String(resBytes, StandardCharsets.UTF_8);
        String ts = new String(tsBytes, StandardCharsets.UTF_8);
        if (this.printValue) {
            logger.debug("Encode {} to {} [{}]", rowkeyStr, realId, ts);
        }
        return Integer.parseInt(realId);
    }

    static Connection getConnection() {
        Configuration conf = HBaseConfiguration.create((Configuration)HadoopUtil.getCurrentConfiguration());
        try {
            return ConnectionFactory.createConnection((Configuration)conf);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot connect to HBase.", ioe);
        }
    }

    private String lockPath() {
        return "/realtime/create_global_dict_table/" + this.tableName;
    }
}

