/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class ResponseResultSchema {
    private CubeDesc cubeDesc;
    private TblColRef[] dimensions;
    private FunctionDesc[] metrics;
    private MeasureDesc[] measures;
    private DataType[] dimDataTypes;
    private DataType[] metricsDataTypes;
    private int nDimensions;
    private Map<TblColRef, Integer> dimColIdxMap;
    private int nMetrics;
    private Map<TblColRef, Integer> metricsColIdxMap;

    public ResponseResultSchema(CubeDesc cubeDesc, Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics) {
        this.cubeDesc = cubeDesc;
        this.init(selectedDimensions, selectedMetrics);
    }

    private void init(Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics) {
        this.dimensions = new TblColRef[selectedDimensions.size()];
        this.metrics = new FunctionDesc[selectedMetrics.size()];
        this.measures = new MeasureDesc[selectedMetrics.size()];
        this.dimDataTypes = new DataType[this.dimensions.length];
        this.metricsDataTypes = new DataType[this.metrics.length];
        this.dimColIdxMap = Maps.newHashMap();
        RowKeyDesc rowKeyDesc = this.cubeDesc.getRowkey();
        int colIdx = 0;
        for (RowKeyColDesc rowKeyColDesc : rowKeyDesc.getRowKeyColumns()) {
            TblColRef dimension = rowKeyColDesc.getColRef();
            if (!selectedDimensions.contains(dimension)) continue;
            this.dimensions[colIdx] = dimension;
            this.dimDataTypes[colIdx] = dimension.getType();
            this.dimColIdxMap.put(dimension, colIdx);
            ++colIdx;
        }
        this.nDimensions = colIdx;
        colIdx = 0;
        this.metricsColIdxMap = Maps.newHashMap();
        for (MeasureDesc measure : this.cubeDesc.getMeasures()) {
            FunctionDesc func = measure.getFunction();
            if (!selectedMetrics.contains(func)) continue;
            this.metrics[colIdx] = func;
            this.measures[colIdx] = measure;
            this.metricsColIdxMap.put(func.getParameter().getColRef(), colIdx);
            this.metricsDataTypes[colIdx] = func.getReturnDataType();
            ++colIdx;
        }
        this.nMetrics = colIdx;
    }

    public int getColumnCount() {
        return this.nDimensions + this.nMetrics;
    }

    public int getDimensionCount() {
        return this.nDimensions;
    }

    public int getMetricsCount() {
        return this.nMetrics;
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public DataType[] getMetricsDataTypes() {
        return this.metricsDataTypes;
    }

    public DataType getMetricsDataType(int i) {
        return this.metricsDataTypes[i];
    }

    public int getIndexOfDimension(TblColRef dimension) {
        Integer i = this.dimColIdxMap.get(dimension);
        return i == null ? -1 : i;
    }

    public int getIndexOfMetrics(TblColRef metricsColumn) {
        Integer i = this.metricsColIdxMap.get(metricsColumn);
        return i == null ? -1 : i;
    }

    public TblColRef[] getDimensions() {
        return this.dimensions;
    }

    public FunctionDesc[] getMetrics() {
        return this.metrics;
    }

    public MeasureDesc[] getMeasureDescs() {
        return this.measures;
    }

    public String[] getAggrFuncs() {
        String[] result = new String[this.metrics.length];
        for (int i = 0; i < this.metrics.length; ++i) {
            result[i] = this.metrics[i].getExpression();
        }
        return result;
    }

    public DimensionEncoding[] getDimensionEncodings(IDimensionEncodingMap dimEncMap) {
        DimensionEncoding[] dimEncs = new DimensionEncoding[this.dimensions.length];
        for (int i = 0; i < dimEncs.length; ++i) {
            dimEncs[i] = dimEncMap.get(this.dimensions[i]);
        }
        return dimEncs;
    }
}

