/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.storage.Record;

public class SingleThreadResultCollector
extends ResultCollector {
    @Override
    public Iterator<Record> iterator() {
        if (this.searchResults.isEmpty()) {
            return Collections.emptyIterator();
        }
        final Iterator resultIterator = this.searchResults.iterator();
        return new Iterator<Record>(){
            Iterator<Record> current = Collections.emptyIterator();
            IStreamingSearchResult prevResult = null;

            @Override
            public boolean hasNext() {
                boolean currentHasNext;
                while (!(currentHasNext = Preconditions.checkNotNull(this.current).hasNext()) && resultIterator.hasNext()) {
                    if (this.prevResult != null) {
                        this.prevResult.endRead();
                    }
                    IStreamingSearchResult currResult = (IStreamingSearchResult)resultIterator.next();
                    currResult.startRead();
                    this.prevResult = currResult;
                    this.current = currResult.iterator();
                }
                if (!currentHasNext && this.prevResult != null) {
                    this.prevResult.endRead();
                }
                return currentHasNext;
            }

            @Override
            public Record next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not support remove");
            }
        };
    }
}

