/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.stream.core.query.StreamingTupleConverter;
import org.apache.kylin.stream.core.storage.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingTupleIterator
implements ITupleIterator {
    private static final Logger logger = LoggerFactory.getLogger(StreamingTupleIterator.class);
    protected final TupleInfo tupleInfo;
    protected final Tuple tuple;
    protected Iterator<Record> gtRecords;
    protected StreamingTupleConverter tupleConverter;
    protected Tuple next;
    private List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    private int advMeasureRowsRemaining;
    private int advMeasureRowIndex;

    public StreamingTupleIterator(Iterator<Record> gtRecords, StreamingTupleConverter tupleConverter, TupleInfo returnTupleInfo) {
        this.gtRecords = gtRecords;
        this.tupleConverter = tupleConverter;
        this.tupleInfo = returnTupleInfo;
        this.tuple = new Tuple(returnTupleInfo);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.advMeasureRowsRemaining > 0) {
            for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
                filler.fillTuple(this.tuple, this.advMeasureRowIndex);
            }
            ++this.advMeasureRowIndex;
            --this.advMeasureRowsRemaining;
            this.next = this.tuple;
            return true;
        }
        if (!this.gtRecords.hasNext()) {
            return false;
        }
        Record curRecord = this.gtRecords.next();
        this.advMeasureFillers = this.tupleConverter.translateResult(curRecord, this.tuple);
        if (this.advMeasureFillers == null) {
            this.next = this.tuple;
            return true;
        }
        this.advMeasureRowsRemaining = -1;
        for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
            if (this.advMeasureRowsRemaining < 0) {
                this.advMeasureRowsRemaining = filler.getNumOfRows();
            }
            if (this.advMeasureRowsRemaining == filler.getNumOfRows()) continue;
            throw new IllegalStateException();
        }
        if (this.advMeasureRowsRemaining < 0) {
            throw new IllegalStateException();
        }
        this.advMeasureRowIndex = 0;
        return this.hasNext();
    }

    @Override
    public ITuple next() {
        if (this.next == null) {
            this.hasNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        Tuple result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

