/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.rest.security;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.security.QueryInterceptor;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class StreamTableInterceptor
extends QueryInterceptor {
    @Override
    protected boolean isEnabled() {
        return KylinConfig.getInstanceFromEnv().isTableACLEnabled();
    }

    public Set<String> getQueryIdentifiers(List<OLAPContext> contexts) {
        return this.getAllTblsWithSchema(contexts);
    }

    protected Set<String> getIdentifierBlackList(List<OLAPContext> contexts) {
        return Sets.newHashSet();
    }

    @Override
    protected String getIdentifierType() {
        return "table";
    }

    private Set<String> getAllTblsWithSchema(List<OLAPContext> contexts) {
        TreeSet<String> tableWithSchema = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (OLAPContext context : contexts) {
            for (OLAPTableScan tableScan : context.allTableScans) {
                tableWithSchema.add(tableScan.getTableRef().getTableIdentity());
            }
        }
        return tableWithSchema;
    }
}

