/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube.streamingv2;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metrics.lib.impl.kafka.KafkaReservoirReporter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.source.MessageParserInfo;
import org.apache.kylin.stream.core.source.StreamingSourceConfig;
import org.apache.kylin.tool.metrics.systemcube.HiveTableCreator;
import org.apache.kylin.tool.metrics.systemcube.def.MetricsSinkDesc;

public class StreamingMetadataCreator {
    public static final Serializer<StreamingSourceConfig> STREAMING_SOURCE_CONFIG_SERIALIZER = new JsonSerializer<StreamingSourceConfig>(StreamingSourceConfig.class);

    public static StreamingSourceConfig generateKylinTableForMetricsQuery(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQuery());
        return StreamingMetadataCreator.generateStreamingV2Config(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectQuery(), columns);
    }

    public static StreamingSourceConfig generateKylinTableForMetricsQueryCube(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQueryCube());
        return StreamingMetadataCreator.generateStreamingV2Config(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectQueryCube(), columns);
    }

    public static StreamingSourceConfig generateKylinTableForMetricsQueryRpcCall(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQueryRPC());
        return StreamingMetadataCreator.generateStreamingV2Config(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectQueryRpcCall(), columns);
    }

    public static StreamingSourceConfig generateKylinTableForMetricsJob(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsJob());
        return StreamingMetadataCreator.generateStreamingV2Config(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectJob(), columns);
    }

    public static StreamingSourceConfig generateKylinTableForMetricsJobException(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsJobException());
        return StreamingMetadataCreator.generateStreamingV2Config(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectJobException(), columns);
    }

    private static StreamingSourceConfig generateStreamingV2Config(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc, String subject, List<Pair<String, String>> columns) {
        StreamingSourceConfig streamingSourceConfig = new StreamingSourceConfig();
        MessageParserInfo parserInfo = new MessageParserInfo();
        parserInfo.setFormatTs(false);
        parserInfo.setTsColName("KTIMESTAMP");
        parserInfo.setTsPattern("MS");
        parserInfo.setTsParser("org.apache.kylin.stream.source.kafka.LongTimeParser");
        HashMap<String, String> columnToSourceFieldMapping = new HashMap<String, String>();
        for (Pair<String, String> col : columns) {
            columnToSourceFieldMapping.put(col.getKey(), col.getKey());
        }
        parserInfo.setColumnToSourceFieldMapping(columnToSourceFieldMapping);
        HashMap<String, String> properties = new HashMap<String, String>();
        String topic = KafkaReservoirReporter.decorateTopic(subject);
        String table = KafkaReservoirReporter.sink.getTableFromSubject(subject);
        properties.put("topic", topic);
        properties.put("bootstrap.servers", sinkDesc.getTableProperties().get("bootstrap.servers"));
        streamingSourceConfig.setName(table);
        streamingSourceConfig.setProperties(properties);
        streamingSourceConfig.setParserInfo(parserInfo);
        streamingSourceConfig.updateRandomUuid();
        streamingSourceConfig.setLastModified(System.currentTimeMillis());
        return streamingSourceConfig;
    }
}

