/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.query;

import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.tool.query.ProbabilityGeneratorCLI;
import org.apache.kylin.tool.query.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGeneratorCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(QueryGeneratorCLI.class);
    private static final Option OPTION_MAX_DIM_NUM;
    private static final Option OPTION_CUBE;
    private static final Option OPTION_SIZE;
    private static final Option OPTION_OUTPUT;
    public static final String SQL_SEPARATOR = "#############";
    protected final Options options = new Options();
    private int sizeOfQueryList;
    private String outputPath;
    private int maxNumOfDim = 3;

    public QueryGeneratorCLI() {
        this.options.addOption(OPTION_MAX_DIM_NUM);
        this.options.addOption(OPTION_CUBE);
        this.options.addOption(OPTION_SIZE);
        this.options.addOption(OPTION_OUTPUT);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String temp = optionsHelper.getOptionValue(OPTION_MAX_DIM_NUM);
        if (!Strings.isNullOrEmpty((String)temp)) {
            this.maxNumOfDim = Integer.parseInt(temp);
        }
        this.outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT);
        this.sizeOfQueryList = Integer.parseInt(optionsHelper.getOptionValue(OPTION_SIZE));
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE);
        this.run(cubeName, true);
    }

    public Pair<List<String>, double[]> execute(String cubeName, int sizeOfQueryList, String outputPath) throws Exception {
        this.outputPath = outputPath;
        this.sizeOfQueryList = sizeOfQueryList;
        return this.run(cubeName, true);
    }

    public Pair<List<String>, double[]> execute(String cubeName, int sizeOfQueryList) throws Exception {
        this.sizeOfQueryList = sizeOfQueryList;
        return this.run(cubeName, false);
    }

    private Pair<List<String>, double[]> run(String cubeName, boolean needToStore) throws Exception {
        double[] pCumArray;
        CubeDesc cubeDesc = CubeDescManager.getInstance(KylinConfig.getInstanceFromEnv()).getCubeDesc(cubeName);
        List<String> queryList = QueryGenerator.generateQueryList(cubeDesc, this.sizeOfQueryList, this.maxNumOfDim);
        ProbabilityGeneratorCLI probabilityGeneratorCLI = new ProbabilityGeneratorCLI();
        if (needToStore) {
            QueryGeneratorCLI.storeQuery(queryList, this.outputPath + "/" + cubeName);
            pCumArray = probabilityGeneratorCLI.execute(queryList.size(), this.outputPath + "/" + cubeName);
        } else {
            pCumArray = probabilityGeneratorCLI.execute(queryList.size());
        }
        return new Pair<List<String>, double[]>(queryList, pCumArray);
    }

    public static void storeQuery(List<String> querySet, String outputPath) throws IOException {
        String fileName = outputPath + ".sql";
        File parentFile = new File(fileName).getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));){
            for (String query : querySet) {
                bufferedWriter.append(query);
                bufferedWriter.append("#############\n");
                logger.info(query);
            }
        }
    }

    public static void main(String[] args) {
        QueryGeneratorCLI queryGeneratorCLI = new QueryGeneratorCLI();
        queryGeneratorCLI.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"maxDimNum");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the maximum number of dimensions for generating a query");
        OPTION_MAX_DIM_NUM = OptionBuilder.create((String)"maxDimNum");
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify for which cube to generate query");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"size");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the size of query set to be generated");
        OPTION_SIZE = OptionBuilder.create((String)"size");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the output path for generated query set");
        OPTION_OUTPUT = OptionBuilder.create((String)"output");
    }
}

