/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.shaded.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import org.apache.kylin.tool.shaded.org.apache.http.Header;
import org.apache.kylin.tool.shaded.org.apache.http.HttpException;
import org.apache.kylin.tool.shaded.org.apache.http.HttpRequest;
import org.apache.kylin.tool.shaded.org.apache.http.HttpRequestInterceptor;
import org.apache.kylin.tool.shaded.org.apache.http.annotation.Immutable;
import org.apache.kylin.tool.shaded.org.apache.http.protocol.HttpContext;
import org.apache.kylin.tool.shaded.org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

