/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.util.RandomUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RootPersistentEntity
implements AclEntity,
Serializable {
    static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss z";
    static FastDateFormat format = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss z");
    @JsonProperty(value="uuid")
    protected String uuid;
    @JsonProperty(value="last_modified")
    protected long lastModified;
    protected boolean isCachedAndShared = false;
    @JsonProperty(value="version")
    protected String version = KylinVersion.getCurrentVersion().toString();

    public static String formatTime(long millis) {
        return format.format(millis);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getId() {
        return this.uuid;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void updateRandomUuid() {
        this.setUuid(RandomUtil.randomUUID().toString());
    }

    public boolean isCachedAndShared() {
        return this.isCachedAndShared;
    }

    public void setCachedAndShared(boolean isCachedAndShared) {
        this.isCachedAndShared = isCachedAndShared;
    }

    public String resourceName() {
        return this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RootPersistentEntity other = (RootPersistentEntity)obj;
        if (this.lastModified != other.lastModified || this.version != null && !this.version.equals(other.getVersion())) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

