/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kylin.dict;

import java.util.Map;

import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.ShrunkenDictionary.ValueSerializer;

import com.google.common.collect.Maps;

public class ShrunkenDictionaryBuilder<T> {

    private Map<T, Integer> valueToIdMap;

    private Dictionary<T> fullDict;

    public ShrunkenDictionaryBuilder(Dictionary<T> fullDict) {
        this.fullDict = fullDict;

        this.valueToIdMap = Maps.newHashMap();
    }

    public void addValue(T value) {
        int id = fullDict.getIdFromValue(value);
        valueToIdMap.put(value, id);
    }

    public ShrunkenDictionary<T> build(ValueSerializer<T> valueSerializer) {
        return new ShrunkenDictionary<>(valueSerializer, fullDict.getMinId(), fullDict.getMaxId(),
                fullDict.getSizeOfId(), fullDict.getSizeOfValue(), valueToIdMap);
    }
}
