/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl.util;

import java.io.Serializable;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.Engine;
import org.apache.kyuubi.client.api.v1.dto.GetBatchesResponse;
import org.apache.kyuubi.client.api.v1.dto.ServerData;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.ctl.util.DateTimeUtils$;
import org.apache.kyuubi.ctl.util.Tabulator$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Render$ {
    public static Render$ MODULE$;
    private final String[] batchColumnNames;

    static {
        new Render$();
    }

    public String renderServiceNodesInfo(String title, Iterable<ServiceNodeInfo> serviceNodeInfo) {
        String[] header = (String[])((Object[])new String[]{"Namespace", "Host", "Port", "Version"});
        String[][] rows = (String[][])((TraversableOnce)((TraversableLike)serviceNodeInfo.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.nodeName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)sn -> (String[])((Object[])new String[]{sn.namespace(), sn.host(), Integer.toString(sn.port()), (String)sn.version().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")}), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    public String renderEngineNodesInfo(Iterable<Engine> engineNodesInfo) {
        String title = new StringBuilder(25).append("Engine Node List (total ").append(engineNodesInfo.size()).append(")").toString();
        String[] header = (String[])((Object[])new String[]{"Namespace", "Instance", "Attributes"});
        String[][] rows = (String[][])((TraversableOnce)engineNodesInfo.map((Function1 & Serializable & scala.Serializable)engine -> (String[])((Object[])new String[]{new StringBuilder(1).append(engine.getNamespace()).append("\n").append(MODULE$.renderEngineNamespaceDetails((Engine)engine)).toString(), engine.getInstance(), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(engine.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\n")}), scala.collection.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    public String renderServerNodesInfo(Iterable<ServerData> serverNodesInfo) {
        String title = new StringBuilder(25).append("Server Node List (total ").append(serverNodesInfo.size()).append(")").toString();
        String[] header = (String[])((Object[])new String[]{"Namespace", "Instance", "Attributes", "Status"});
        String[][] rows = (String[][])((TraversableOnce)serverNodesInfo.map((Function1 & Serializable & scala.Serializable)server -> (String[])((Object[])new String[]{server.getNamespace(), server.getInstance(), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(server.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n"), server.getStatus()}), scala.collection.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    public String renderSessionDataListInfo(Iterable<SessionData> sessions) {
        String title = new StringBuilder(26).append("Live Session List (total ").append(sessions.size()).append(")").toString();
        String[] header = (String[])((Object[])new String[]{"Identifier", "User", "Ip Address", "Conf", "Create Time", "Duration[ms]", "Idle Time[ms]"});
        String[][] rows = (String[][])((TraversableOnce)sessions.map((Function1 & Serializable & scala.Serializable)session -> (String[])((Object[])new String[]{session.getIdentifier(), session.getUser(), session.getIpAddr(), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getConf()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\n"), DateTimeUtils$.MODULE$.millisToDateString(Predef$.MODULE$.Long2long(session.getCreateTime()), "yyyy-MM-dd HH:mm:ss"), session.getDuration().toString(), session.getIdleTime().toString()}), scala.collection.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    public String renderBatchListInfo(GetBatchesResponse batchListInfo) {
        String title = new StringBuilder(25).append("Batch List (from ").append(batchListInfo.getFrom()).append(" total ").append(batchListInfo.getTotal()).append(")").toString();
        String[][] rows = (String[][])((TraversableOnce)((TraversableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchListInfo.getBatches()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getCreateTime()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)batch -> MODULE$.buildBatchRow((Batch)batch, false), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, this.batchColumnNames(), rows);
    }

    public String renderBatchInfo(Batch batch) {
        String title = new StringBuilder(15).append("Batch Report (").append(batch.getId()).append(")").toString();
        String[] header = (String[])((Object[])new String[]{"Key", "Value"});
        String[][] rows = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.batchColumnNames())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.buildBatchRow(batch, this.buildBatchRow$default$2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return (String[])((Object[])new String[]{k, v});
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    private String[] batchColumnNames() {
        return this.batchColumnNames;
    }

    private String[] buildBatchRow(Batch batch, boolean showDiagnostic) {
        return (String[])((Object[])new String[]{batch.getId(), batch.getBatchType(), batch.getName(), batch.getUser(), batch.getState(), this.buildBatchAppInfo(batch, showDiagnostic).mkString("\n"), batch.getKyuubiInstance(), ((TraversableOnce)new .colon.colon((Object)DateTimeUtils$.MODULE$.millisToDateString(batch.getCreateTime(), "yyyy-MM-dd HH:mm:ss"), (List)new .colon.colon((Object)DateTimeUtils$.MODULE$.millisToDateString(batch.getEndTime(), "yyyy-MM-dd HH:mm:ss"), (List)Nil$.MODULE$))).mkString("\n~\n")});
    }

    private boolean buildBatchRow$default$2() {
        return true;
    }

    private List<String> buildBatchAppInfo(Batch batch, boolean showDiagnostic) {
        ListBuffer batchAppInfo;
        block0: {
            batchAppInfo = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(batch.getBatchInfo()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return batchAppInfo.$plus$eq((Object)new StringBuilder(2).append(key).append(": ").append(value).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            Object object = batch.getAppStartTime() > 0L ? batchAppInfo.$plus$eq((Object)new StringBuilder(16).append("App Start Time:").append(" ").append(DateTimeUtils$.MODULE$.millisToDateString(batch.getAppStartTime(), "yyyy-MM-dd HH:mm:ss")).toString()) : BoxedUnit.UNIT;
            Option$.MODULE$.apply((Object)batch.getAppId()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> batchAppInfo.$plus$eq((Object)new StringBuilder(8).append("App Id: ").append(batch.getAppId()).toString()));
            Option$.MODULE$.apply((Object)batch.getAppUrl()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> batchAppInfo.$plus$eq((Object)new StringBuilder(9).append("App Url: ").append(batch.getAppUrl()).toString()));
            Option$.MODULE$.apply((Object)batch.getAppState()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> batchAppInfo.$plus$eq((Object)new StringBuilder(11).append("App State: ").append(batch.getAppState()).toString()));
            if (!showDiagnostic) break block0;
            Option$.MODULE$.apply((Object)batch.getAppDiagnostic()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Render$.$anonfun$buildBatchAppInfo$5(x$6))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> batchAppInfo.$plus$eq((Object)new StringBuilder(16).append("App Diagnostic: ").append(batch.getAppDiagnostic()).toString()));
        }
        return batchAppInfo.toList();
    }

    private boolean buildBatchAppInfo$default$2() {
        return true;
    }

    private String renderEngineNamespaceDetails(Engine engine) {
        String[] header = (String[])((Object[])new String[]{"EngineType", "ShareLevel", "Subdomain"});
        return Tabulator$.MODULE$.formatTextTable(header, (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{engine.getEngineType(), engine.getSharelevel(), engine.getSubdomain()})}));
    }

    public static final /* synthetic */ boolean $anonfun$buildBatchAppInfo$5(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    private Render$() {
        MODULE$ = this;
        this.batchColumnNames = (String[])((Object[])new String[]{"Batch Id", "Type", "Name", "User", "State", "Batch App Info", "Kyuubi Instance", "Time Range"});
    }
}

