/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.kyuubi.jdbc.hive.JdbcConnectionParams;
import org.apache.kyuubi.jdbc.hive.JdbcUriParseException;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.ZooKeeperHiveClientException;
import org.apache.kyuubi.jdbc.hive.ZooKeeperHiveClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final List<String> URL_PREFIX_LIST = Arrays.asList("jdbc:hive2://", "jdbc:kyuubi://");
    static final String DEFAULT_PORT = "10000";
    static final String dummyAuthorityString = "dummyhost:00000";
    static final String DEFAULT_DATABASE = "default";
    private static final String URI_JDBC_PREFIX = "jdbc:";
    private static final String URI_HIVE_PREFIX = "hive2:";
    public static final String HIVE_SERVER2_RETRY_KEY = "hive.server2.retryserver";
    public static final String HIVE_SERVER2_RETRY_TRUE = "true";
    public static final String HIVE_SERVER2_RETRY_FALSE = "false";
    public static final Pattern KYUUBI_OPERATION_HINT_PATTERN = Pattern.compile("^__kyuubi_operation_result_(.*)__=(.*)", 2);
    public static final String KYUUBI_CLIENT_VERSION_KEY = "kyuubi.client.version";
    private static String KYUUBI_CLIENT_VERSION;

    static String getMatchedUrlPrefix(String uri) throws JdbcUriParseException {
        for (String urlPrefix : URL_PREFIX_LIST) {
            if (!uri.startsWith(urlPrefix)) continue;
            return urlPrefix;
        }
        throw new JdbcUriParseException("Bad URL format: Missing prefix " + String.join((CharSequence)" or ", URL_PREFIX_LIST));
    }

    static void verifySuccessWithInfo(TStatus status) throws SQLException {
        Utils.verifySuccess(status, true);
    }

    static void verifySuccess(TStatus status) throws SQLException {
        Utils.verifySuccess(status, false);
    }

    static void verifySuccess(TStatus status, boolean withInfo) throws SQLException {
        if (status.getStatusCode() == TStatusCode.SUCCESS_STATUS || withInfo && status.getStatusCode() == TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            return;
        }
        throw new KyuubiSQLException(status);
    }

    static List<String> splitSqlStatement(String sql) {
        ArrayList<String> parts = new ArrayList<String>();
        int apCount = 0;
        int off = 0;
        boolean skip = false;
        block5: for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (skip) {
                skip = false;
                continue;
            }
            switch (c) {
                case '\'': {
                    ++apCount;
                    continue block5;
                }
                case '\\': {
                    skip = true;
                    continue block5;
                }
                case '?': {
                    if ((apCount & 1) != 0) continue block5;
                    parts.add(sql.substring(off, i));
                    off = i + 1;
                    continue block5;
                }
            }
        }
        parts.add(sql.substring(off));
        return parts;
    }

    public static String updateSql(String sql, HashMap<Integer, String> parameters) throws SQLException {
        List<String> parts = Utils.splitSqlStatement(sql);
        StringBuilder newSql = new StringBuilder(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            if (!parameters.containsKey(i)) {
                throw new KyuubiSQLException("Parameter #" + i + " is unset");
            }
            newSql.append(parameters.get(i));
            newSql.append(parts.get(i));
        }
        return newSql.toString();
    }

    public static JdbcConnectionParams parseURL(String uri) throws JdbcUriParseException, SQLException, ZooKeeperHiveClientException {
        return Utils.parseURL(uri, new Properties());
    }

    public static JdbcConnectionParams parseURL(String uri, Properties info) throws JdbcUriParseException, SQLException, ZooKeeperHiveClientException {
        JdbcConnectionParams connParams = Utils.extractURLComponents(uri, info);
        if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(connParams.getSessionVars())) {
            Utils.configureConnParamsFromZooKeeper(connParams);
        }
        Utils.handleAllDeprecations(connParams);
        return connParams;
    }

    public static JdbcConnectionParams extractURLComponents(String uri, Properties info) throws JdbcUriParseException {
        String varStr;
        JdbcConnectionParams connParams = new JdbcConnectionParams();
        String authorityFromClientJdbcURL = Utils.getAuthorityFromJdbcURL(uri);
        if (authorityFromClientJdbcURL.isEmpty()) {
            authorityFromClientJdbcURL = "localhost:10009";
            String urlPrefix = Utils.getMatchedUrlPrefix(uri);
            uri = uri.replace(urlPrefix, urlPrefix + authorityFromClientJdbcURL);
        }
        connParams.setSuppliedURLAuthority(authorityFromClientJdbcURL);
        uri = uri.replaceFirst(authorityFromClientJdbcURL, dummyAuthorityString);
        URI jdbcURI = URI.create(uri.substring(URI_JDBC_PREFIX.length()));
        Pattern pattern = Pattern.compile("([^;]*)=([^;]*);?");
        String sessVars = jdbcURI.getPath();
        if (sessVars != null && !sessVars.isEmpty()) {
            String dbName = "";
            String catalogName = "";
            if (!(sessVars = sessVars.substring(1)).contains(";")) {
                if (sessVars.contains("/")) {
                    catalogName = sessVars.substring(0, sessVars.indexOf(47));
                    dbName = sessVars.substring(sessVars.indexOf(47) + 1);
                } else {
                    dbName = sessVars;
                }
            } else {
                String catalogAndDb = sessVars.substring(0, sessVars.indexOf(59));
                if (catalogAndDb.contains("/")) {
                    catalogName = catalogAndDb.substring(0, catalogAndDb.indexOf(47));
                    dbName = catalogAndDb.substring(catalogAndDb.indexOf(47) + 1);
                } else {
                    dbName = catalogAndDb;
                }
                sessVars = sessVars.substring(sessVars.indexOf(59) + 1);
                Matcher sessMatcher = pattern.matcher(sessVars);
                while (sessMatcher.find()) {
                    if (connParams.getSessionVars().put(sessMatcher.group(1), sessMatcher.group(2)) == null) continue;
                    throw new JdbcUriParseException("Bad URL format: Multiple values for property " + sessMatcher.group(1));
                }
            }
            if (!catalogName.isEmpty()) {
                connParams.setCatalogName(catalogName);
            }
            if (!dbName.isEmpty()) {
                connParams.setDbName(dbName);
            }
        }
        Pattern confPattern = Pattern.compile("([^;]*)([^;]*);?");
        String confStr = jdbcURI.getQuery();
        if (confStr != null) {
            Matcher confMatcher = confPattern.matcher(confStr);
            while (confMatcher.find()) {
                String connParam = confMatcher.group(1);
                if (!StringUtils.isNotBlank((CharSequence)connParam) || !connParam.contains("=")) continue;
                int n = connParam.indexOf(61);
                connParams.getHiveConfs().put(connParam.substring(0, n), connParam.substring(n + 1));
            }
        }
        if ((varStr = jdbcURI.getFragment()) != null) {
            Matcher varMatcher = pattern.matcher(varStr);
            while (varMatcher.find()) {
                connParams.getHiveVars().put(varMatcher.group(1), varMatcher.group(2));
            }
        }
        for (Map.Entry entry : info.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            if (key.startsWith("hivevar:")) {
                connParams.getHiveVars().put(key.substring("hivevar:".length()), info.getProperty(key));
                continue;
            }
            if (!key.startsWith("hiveconf:")) continue;
            connParams.getHiveConfs().put(key.substring("hiveconf:".length()), info.getProperty(key));
        }
        if (!connParams.getSessionVars().containsKey("clientProtocolVersion") && info.containsKey("clientProtocolVersion")) {
            connParams.getSessionVars().put("clientProtocolVersion", info.getProperty("clientProtocolVersion"));
        }
        if (!connParams.getSessionVars().containsKey("user")) {
            if (info.containsKey("user")) {
                connParams.getSessionVars().put("user", info.getProperty("user"));
            }
            if (info.containsKey("password")) {
                connParams.getSessionVars().put("password", info.getProperty("password"));
            }
        }
        if (!connParams.getSessionVars().containsKey("password")) {
            if (info.containsKey("user")) {
                connParams.getSessionVars().put("user", info.getProperty("user"));
            }
            if (info.containsKey("password")) {
                connParams.getSessionVars().put("password", info.getProperty("password"));
            }
        }
        if (info.containsKey("auth")) {
            connParams.getSessionVars().put("auth", info.getProperty("auth"));
        }
        String authorityStr = connParams.getSuppliedURLAuthority();
        if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(connParams.getSessionVars())) {
            uri = uri.replace(dummyAuthorityString, authorityStr);
            connParams.setZooKeeperEnsemble(authorityStr);
        } else {
            URI uRI = URI.create("hive2://" + authorityStr);
            if (uRI.getAuthority() != null) {
                String host = uRI.getHost();
                int port = uRI.getPort();
                if (host == null) {
                    throw new JdbcUriParseException("Bad URL format. Hostname not found  in authority part of the url: " + uRI.getAuthority() + ". Are you missing a '/' after the hostname ?");
                }
                if (port <= 0) {
                    port = Integer.parseInt(DEFAULT_PORT);
                }
                connParams.setHost(uRI.getHost());
                connParams.setPort(uRI.getPort());
            }
            authorityStr = connParams.getHost() + ":" + connParams.getPort();
            LOG.debug("Resolved authority: " + authorityStr);
            uri = uri.replace(dummyAuthorityString, authorityStr);
        }
        connParams.setJdbcUriString(uri);
        return connParams;
    }

    static void configureConnParamsFromZooKeeper(JdbcConnectionParams connParams) throws ZooKeeperHiveClientException, JdbcUriParseException {
        ZooKeeperHiveClientHelper.configureConnParams(connParams);
        String authorityStr = connParams.getHost() + ":" + connParams.getPort();
        LOG.debug("Resolved authority: " + authorityStr);
        String jdbcUriString = connParams.getJdbcUriString();
        connParams.setJdbcUriString(jdbcUriString.replace(Utils.getAuthorityFromJdbcURL(jdbcUriString), authorityStr));
    }

    private static void handleAllDeprecations(JdbcConnectionParams connParams) {
        String usageUrlBase = "jdbc:hive2://<host>:<port>/dbName;";
        String newUsage = usageUrlBase + "saslQop" + "=<qop_value>";
        Utils.handleParamDeprecation(connParams.getSessionVars(), connParams.getSessionVars(), "sasl.qop", "saslQop", newUsage);
        newUsage = usageUrlBase + "transportMode" + "=<transport_mode_value>";
        Utils.handleParamDeprecation(connParams.getHiveConfs(), connParams.getSessionVars(), "hive.server2.transport.mode", "transportMode", newUsage);
        newUsage = usageUrlBase + "httpPath" + "=<http_path_value>";
        Utils.handleParamDeprecation(connParams.getHiveConfs(), connParams.getSessionVars(), "hive.server2.thrift.http.path", "httpPath", newUsage);
    }

    private static void handleParamDeprecation(Map<String, String> fromMap, Map<String, String> toMap, String deprecatedName, String newName, String newUsage) {
        if (fromMap.containsKey(deprecatedName)) {
            LOG.warn("***** JDBC param deprecation *****");
            LOG.warn("The use of " + deprecatedName + " is deprecated.");
            LOG.warn("Please use " + newName + " like so: " + newUsage);
            String paramValue = fromMap.remove(deprecatedName);
            toMap.put(newName, paramValue);
        }
    }

    private static String getAuthorityFromJdbcURL(String uri) throws JdbcUriParseException {
        String toIndexChar;
        String matchedUrlPrefix = Utils.getMatchedUrlPrefix(uri);
        int fromIndex = matchedUrlPrefix.length();
        int toIndex = -1;
        ArrayList<String> toIndexChars = new ArrayList<String>(Arrays.asList("/", "?", "#"));
        Iterator<String> iterator = toIndexChars.iterator();
        while (iterator.hasNext() && (toIndex = uri.indexOf(toIndexChar = iterator.next(), fromIndex)) <= 0) {
        }
        String authorities = toIndex < 0 ? uri.substring(fromIndex) : uri.substring(fromIndex, toIndex);
        return authorities;
    }

    static boolean updateConnParamsFromZooKeeper(JdbcConnectionParams connParams) {
        connParams.getRejectedHostZnodePaths().add(connParams.getCurrentHostZnodePath());
        String oldServerHost = connParams.getHost();
        int oldServerPort = connParams.getPort();
        try {
            ZooKeeperHiveClientHelper.configureConnParams(connParams);
            connParams.setJdbcUriString(connParams.getJdbcUriString().replace(oldServerHost + ":" + oldServerPort, connParams.getHost() + ":" + connParams.getPort()));
            LOG.info("Selected HiveServer2 instance with uri: " + connParams.getJdbcUriString());
        }
        catch (ZooKeeperHiveClientException e) {
            LOG.error(e.getMessage());
            return false;
        }
        return true;
    }

    static int getVersionPart(String fullVersion, int position) {
        int version = -1;
        try {
            String[] tokens = fullVersion.split("[.-]");
            if (tokens.length > 1 && tokens[position] != null) {
                version = Integer.parseInt(tokens[position]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static String parsePropertyFromUrl(String url, String key) {
        String[] tokens;
        for (String token : tokens = url.split(";")) {
            if (!token.trim().startsWith(key.trim() + "=")) continue;
            return token.trim().substring((key.trim() + "=").length());
        }
        return null;
    }

    public static String getCanonicalHostName(String hostName) {
        try {
            InetAddress addr = InetAddress.getByName(hostName);
            String canonicalHostname = addr.getCanonicalHostName();
            if (canonicalHostname.equals(addr.getHostAddress())) {
                return hostName;
            }
            return canonicalHostname;
        }
        catch (UnknownHostException exception) {
            LOG.warn("Could not retrieve canonical hostname for " + hostName, (Throwable)exception);
            return hostName;
        }
    }

    public static boolean isKyuubiOperationHint(String hint) {
        return KYUUBI_OPERATION_HINT_PATTERN.matcher(hint).matches();
    }

    public static synchronized String getVersion() {
        if (KYUUBI_CLIENT_VERSION == null) {
            try {
                Properties prop = new Properties();
                prop.load(Utils.class.getClassLoader().getResourceAsStream("org/apache/kyuubi/version.properties"));
                KYUUBI_CLIENT_VERSION = prop.getProperty(KYUUBI_CLIENT_VERSION_KEY, "unknown");
            }
            catch (Exception e) {
                LOG.error("Error getting kyuubi client version", (Throwable)e);
                KYUUBI_CLIENT_VERSION = "unknown";
            }
        }
        return KYUUBI_CLIENT_VERSION;
    }
}

