/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.net.mock;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.logging.log4j.core.test.net.mock.MockSyslogServer;
import org.apache.logging.log4j.core.test.net.ssl.LegacyBsdTlsSyslogInputStreamReader;
import org.apache.logging.log4j.core.test.net.ssl.TlsSyslogInputStreamReader;
import org.apache.logging.log4j.core.test.net.ssl.TlsSyslogInputStreamReaderBase;
import org.apache.logging.log4j.core.test.net.ssl.TlsSyslogMessageFormat;

public class MockTlsSyslogServer
extends MockSyslogServer {
    private final SSLServerSocket serverSocket;
    private SSLSocket clientSocket;
    private final List<String> messageList = new ArrayList<String>();
    private TlsSyslogInputStreamReaderBase syslogReader;
    private volatile boolean shutdown = false;
    private Thread thread;
    private TlsSyslogMessageFormat messageFormat = TlsSyslogMessageFormat.SYSLOG;
    private final int numberOfMessageToReceive;

    public MockTlsSyslogServer(int numberOfMessagesToReceive, TlsSyslogMessageFormat format, SSLServerSocket serverSocket) {
        this.messageFormat = format;
        this.numberOfMessageToReceive = numberOfMessagesToReceive;
        this.serverSocket = serverSocket;
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception e) {
                    LOGGER.error("The {} failed to close its socket.", (Object)this.getName(), (Object)e);
                }
            }
            this.interrupt();
        }
        catch (SecurityException e) {
            LOGGER.error("Shutdown of {} failed", (Object)this.getName(), (Object)e);
        }
        if (this.thread != null) {
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Shutdown of {} thread failed.", (Object)this.getName(), (Object)e);
            }
        }
    }

    @Override
    public void run() {
        LOGGER.info("{} started on port {}.", (Object)this.getName(), (Object)this.getLocalPort());
        this.thread = Thread.currentThread();
        try {
            this.waitForConnection();
            this.processFrames();
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        finally {
            this.closeSockets();
        }
        LOGGER.info("{} stopped.", (Object)this.getName());
    }

    private void waitForConnection() throws IOException {
        this.clientSocket = (SSLSocket)this.serverSocket.accept();
        InputStream clientSocketInputStream = this.clientSocket.getInputStream();
        this.syslogReader = this.createTLSSyslogReader(clientSocketInputStream);
    }

    private TlsSyslogInputStreamReaderBase createTLSSyslogReader(InputStream inputStream) {
        switch (this.messageFormat) {
            case SYSLOG: {
                return new TlsSyslogInputStreamReader(inputStream);
            }
            case LEGACY_BSD: {
                return new LegacyBsdTlsSyslogInputStreamReader(inputStream);
            }
        }
        return null;
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void processFrames() throws IOException {
        try {
            int count = 0;
            while (!this.shutdown) {
                String message = this.syslogReader.read();
                LOGGER.debug("{} received a message: {}", (Object)this.getName(), (Object)message);
                this.messageList.add(message);
                if (!this.isEndOfMessages(++count)) continue;
                break;
            }
            this.notify();
        }
        catch (Exception e) {
            this.notify();
            throw new IOException(e);
        }
    }

    private boolean isEndOfMessages(int count) {
        return count == this.numberOfMessageToReceive;
    }

    @Override
    public List<String> getMessageList() {
        return this.messageList;
    }
}

