/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.util;

import java.io.IOException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.unsigned.UByte;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.unsigned.Unsigned;

public class LittleEndianBitConverter {
    private LittleEndianBitConverter() {
    }

    public static short ToUInt16(byte[] array, int index) throws IOException {
        LittleEndianBitConverter.checkByteArgument(array, index, 2);
        return (short)LittleEndianBitConverter.convertFromBytes(array, index, 2);
    }

    public static int toUInt32(byte[] array, int index) throws IOException {
        LittleEndianBitConverter.checkByteArgument(array, index, 4);
        return (int)LittleEndianBitConverter.convertFromBytes(array, index, 4);
    }

    public static int toInt32(byte[] array, int index) throws IOException {
        LittleEndianBitConverter.checkByteArgument(array, index, 4);
        return (int)LittleEndianBitConverter.convertFromBytes(array, index, 4);
    }

    public static short toInt16(byte[] array, int index) throws IOException {
        LittleEndianBitConverter.checkByteArgument(array, index, 4);
        return (short)LittleEndianBitConverter.convertFromBytes(array, index, 2);
    }

    public static long toUInt64(byte[] array, int index) throws IOException {
        LittleEndianBitConverter.checkByteArgument(array, index, 8);
        return LittleEndianBitConverter.convertFromBytes(array, index, 8);
    }

    public static byte[] getBytes(long value) {
        byte[] buffer = new byte[8];
        LittleEndianBitConverter.convertToBytes(value, buffer);
        return buffer;
    }

    public static byte[] getBytes(int value) {
        byte[] buffer = new byte[4];
        LittleEndianBitConverter.convertToBytes(value, buffer);
        return buffer;
    }

    private static long convertFromBytes(byte[] buffer, int startIndex, int bytesToConvert) {
        long ret = 0L;
        int bitCount = 0;
        for (int i = 0; i < bytesToConvert; ++i) {
            UByte ubyte = Unsigned.ubyte(buffer[startIndex + i]);
            ret |= ubyte.longValue() << bitCount;
            bitCount += 8;
        }
        return ret;
    }

    private static void convertToBytes(long value, byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    private static void checkByteArgument(byte[] value, int startIndex, int bytesRequired) throws IOException {
        if (value == null) {
            throw new IOException("value must be non-null");
        }
        if (startIndex < 0) {
            throw new IOException("The index cannot be less than 0.");
        }
        if (startIndex > value.length - bytesRequired) {
            throw new IOException("startIndex " + startIndex + " is less than value.length (" + value.length + ") minus bytesRequired (" + bytesRequired + ")");
        }
    }
}

