/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.generic.ImportSupport;
import org.apache.velocity.tools.generic.ValueParser;

public class ViewImportSupport
extends ImportSupport {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    protected void configure(ValueParser values) {
        ServletContext servletContext;
        HttpServletResponse response;
        super.configure(values);
        HttpServletRequest request = (HttpServletRequest)values.get("request");
        if (request != null) {
            this.setRequest(request);
        }
        if ((response = (HttpServletResponse)values.get("response")) != null) {
            this.setResponse(response);
        }
        if ((servletContext = (ServletContext)values.get("servletContext")) != null) {
            this.setServletContext(servletContext);
        }
    }

    public void setRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request should not be null");
        }
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("response should not be null");
        }
        this.response = response;
    }

    public void setServletContext(ServletContext application) {
        if (application == null) {
            throw new NullPointerException("servlet context should not be null");
        }
        this.application = application;
    }

    protected String acquireRemoteURLString(String url) throws IOException {
        if (this.isSafeMode()) {
            this.getLog().warn("safe mode prevented reading resource from remote url: {} ", (Object)url);
            return null;
        }
        return super.acquireRemoteURLString(url);
    }

    protected String acquireLocalURLString(String url) throws IOException {
        if (!(this.request instanceof HttpServletRequest) || !(this.response instanceof HttpServletResponse)) {
            throw new IOException("Local import from non-HTTP request not allowed");
        }
        if (!url.startsWith("/")) {
            String sp = this.request.getServletPath();
            url = sp.substring(0, sp.lastIndexOf(47)) + '/' + url;
        }
        url = ViewImportSupport.stripSession(url);
        url = this.mergeQueryStrings(url);
        Object parentToolbox = this.request.getAttribute(Toolbox.KEY);
        this.request.removeAttribute(Toolbox.KEY);
        RequestDispatcher rd = this.application.getRequestDispatcher(url);
        if (rd == null) {
            throw new IOException("Couldn't get a RequestDispatcher for \"" + url + "\"");
        }
        ImportResponseWrapper irw = new ImportResponseWrapper(this.response);
        try {
            rd.include((ServletRequest)this.request, (ServletResponse)irw);
        }
        catch (IOException ex) {
            throw new IOException("Problem importing the local URL \"" + url + "\": " + ex.getMessage(), ex);
        }
        catch (ServletException se) {
            throw new IOException("Problem importing the local URL \"" + url + "\": " + se.getMessage(), se);
        }
        finally {
            this.request.setAttribute(Toolbox.KEY, parentToolbox);
        }
        if (irw.getStatus() < 200 || irw.getStatus() > 299) {
            throw new IOException("Invalid response code '" + irw.getStatus() + "' for \"" + url + "\"");
        }
        return irw.getString();
    }

    protected Reader acquireRemoteURLReader(String url) throws IOException {
        if (this.isSafeMode()) {
            this.getLog().warn("safe mode prevented reading resource from remote url: {}", (Object)url);
            return null;
        }
        return super.acquireRemoteURLReader(url);
    }

    protected Reader acquireLocalURLReader(String url) throws IOException {
        return new StringReader(this.acquireLocalURLString(url));
    }

    public static String stripSession(String url) {
        int sessionStart;
        StringBuilder u = new StringBuilder(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            int sessionEnd = u.toString().indexOf(";", sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf("?", sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }

    protected String mergeQueryStrings(String url) {
        Map originalParameters = this.request.getParameterMap();
        if (originalParameters.size() > 0) {
            StringBuilder builder = new StringBuilder(url);
            HashSet<String> newParameterNames = new HashSet<String>();
            int qm = url.indexOf(63);
            if (qm != -1) {
                String[] newParameters;
                for (String newParam : newParameters = url.substring(qm + 1).split("&")) {
                    int eq = newParam.indexOf(61);
                    if (eq != -1) {
                        newParam = newParam.substring(eq);
                    }
                    newParameterNames.add(newParam);
                }
            }
            int separator = qm == -1 ? 63 : 38;
            for (Map.Entry entry : originalParameters.entrySet()) {
                String key = (String)entry.getKey();
                if (newParameterNames.contains(key)) continue;
                key = URLEncoder.encode(key);
                for (String value : (String[])entry.getValue()) {
                    builder.append((char)separator);
                    separator = 38;
                    builder.append(key).append('=').append(URLEncoder.encode(value));
                }
            }
            url = builder.toString();
        }
        return url;
    }

    protected URL getFileResource(String resource) throws Exception {
        return this.application.getResource(resource);
    }

    protected static class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw;
        private ByteArrayOutputStream bos;
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status = 200;

        public ImportResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() {
            if (this.isStreamUsed) {
                throw new IllegalStateException("Unexpected internal error during import: Target servlet called getWriter(), then getOutputStream()");
            }
            this.isWriterUsed = true;
            if (this.sw == null) {
                this.sw = new StringWriter();
            }
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException("Unexpected internal error during import: Target servlet called getOutputStream(), then getWriter()");
            }
            this.isStreamUsed = true;
            if (this.bos == null) {
                this.bos = new ByteArrayOutputStream();
            }
            ServletOutputStream sos = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    bos.write(b);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }
            };
            return sos;
        }

        public void setContentType(String x) {
        }

        public void setLocale(Locale x) {
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                return this.bos.toString(this.getCharacterEncoding());
            }
            return "";
        }
    }

    protected static class SafeClosingHttpURLConnectionReader
    extends Reader {
        private final HttpURLConnection huc;
        private final Reader wrappedReader;

        SafeClosingHttpURLConnectionReader(Reader r, HttpURLConnection huc) {
            this.wrappedReader = r;
            this.huc = huc;
        }

        @Override
        public void close() throws IOException {
            if (null != this.huc) {
                this.huc.disconnect();
            }
            this.wrappedReader.close();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.wrappedReader.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.wrappedReader.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.wrappedReader.read();
        }

        @Override
        public int read(char[] buf) throws IOException {
            return this.wrappedReader.read(buf);
        }

        @Override
        public int read(char[] buf, int off, int len) throws IOException {
            return this.wrappedReader.read(buf, off, len);
        }

        @Override
        public boolean ready() throws IOException {
            return this.wrappedReader.ready();
        }

        @Override
        public void reset() throws IOException {
            this.wrappedReader.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrappedReader.skip(n);
        }
    }
}

