/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.util.SimpleNamespaceContext;
import org.apache.calcite.util.Static;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFunctions {
    private static final ThreadLocal<@Nullable XPathFactory> XPATH_FACTORY = ThreadLocal.withInitial(() -> {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        try {
            xPathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (XPathFactoryConfigurationException e) {
            throw new IllegalStateException("XPath Factory configuration failed", e);
        }
        return xPathFactory;
    });
    private static final ThreadLocal<@Nullable TransformerFactory> TRANSFORMER_FACTORY = ThreadLocal.withInitial(() -> {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setErrorListener(new InternalErrorListener());
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Transformer Factory configuration failed", e);
        }
        return transformerFactory;
    });
    private static final ThreadLocal<@Nullable DocumentBuilderFactory> DOCUMENT_BUILDER_FACTORY = ThreadLocal.withInitial(() -> {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Document Builder configuration failed", e);
        }
        return documentBuilderFactory;
    });
    private static final Pattern VALID_NAMESPACE_PATTERN = Pattern.compile("^(([0-9a-zA-Z:_-]+=\"[^\"]*\")( [0-9a-zA-Z:_-]+=\"[^\"]*\")*)$");
    private static final Pattern EXTRACT_NAMESPACE_PATTERN = Pattern.compile("([0-9a-zA-Z:_-]+)=(['\"])((?!\\2).+?)\\2");

    private XmlFunctions() {
    }

    public static @Nullable String extractValue(@Nullable String input, @Nullable String xpath) {
        if (input == null || xpath == null) {
            return null;
        }
        try {
            Node documentNode = XmlFunctions.getDocumentNode(input);
            XPathExpression xpathExpression = ((XPathFactory)Nullness.castNonNull((Object)XPATH_FACTORY.get())).newXPath().compile(xpath);
            try {
                NodeList nodes = (NodeList)xpathExpression.evaluate(documentNode, XPathConstants.NODESET);
                ArrayList<@Nullable String> result = new ArrayList<String>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node item = (Node)Nullness.castNonNull((Object)nodes.item(i));
                    Node firstChild = Objects.requireNonNull(item.getFirstChild(), () -> "firstChild of node " + item);
                    result.add(firstChild.getTextContent());
                }
                return StringUtils.join(result, (String)" ");
            }
            catch (XPathExpressionException e) {
                return xpathExpression.evaluate(documentNode);
            }
        }
        catch (IllegalArgumentException | XPathExpressionException ex) {
            throw Static.RESOURCE.invalidInputForExtractValue(input, xpath).ex();
        }
    }

    public static @Nullable String xmlTransform(@Nullable String xml, @Nullable String xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        try {
            StreamSource xsltSource = new StreamSource(new StringReader(xslt));
            StreamSource xmlSource = new StreamSource(new StringReader(xml));
            Transformer transformer = ((TransformerFactory)Nullness.castNonNull((Object)TRANSFORMER_FACTORY.get())).newTransformer(xsltSource);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.setErrorListener(new InternalErrorListener());
            transformer.transform(xmlSource, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw Static.RESOURCE.illegalXslt(xslt).ex();
        }
        catch (TransformerException e) {
            throw Static.RESOURCE.invalidInputForXmlTransform(xml).ex();
        }
    }

    public static @Nullable String extractXml(@Nullable String xml, @Nullable String xpath) {
        return XmlFunctions.extractXml(xml, xpath, null);
    }

    public static @Nullable String extractXml(@Nullable String xml, @Nullable String xpath, @Nullable String namespace) {
        if (xml == null || xpath == null) {
            return null;
        }
        try {
            XPath xPath = ((XPathFactory)Nullness.castNonNull((Object)XPATH_FACTORY.get())).newXPath();
            if (namespace != null) {
                xPath.setNamespaceContext(XmlFunctions.extractNamespaceContext(namespace));
            }
            XPathExpression xpathExpression = xPath.compile(xpath);
            Node documentNode = XmlFunctions.getDocumentNode(xml);
            try {
                ArrayList<String> result = new ArrayList<String>();
                NodeList nodes = (NodeList)xpathExpression.evaluate(documentNode, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    result.add(XmlFunctions.convertNodeToString((Node)Nullness.castNonNull((Object)nodes.item(i))));
                }
                return StringUtils.join(result, (String)"");
            }
            catch (XPathExpressionException e) {
                Node node = (Node)xpathExpression.evaluate(documentNode, XPathConstants.NODE);
                return XmlFunctions.convertNodeToString(node);
            }
        }
        catch (IllegalArgumentException | TransformerException | XPathExpressionException ex) {
            throw Static.RESOURCE.invalidInputForExtractXml(xpath, namespace).ex();
        }
    }

    public static @Nullable Integer existsNode(@Nullable String xml, @Nullable String xpath) {
        return XmlFunctions.existsNode(xml, xpath, null);
    }

    public static @Nullable Integer existsNode(@Nullable String xml, @Nullable String xpath, @Nullable String namespace) {
        if (xml == null || xpath == null) {
            return null;
        }
        XPath xPath = ((XPathFactory)Nullness.castNonNull((Object)XPATH_FACTORY.get())).newXPath();
        if (namespace != null) {
            xPath.setNamespaceContext(XmlFunctions.extractNamespaceContext(namespace));
        }
        XPathExpression xpathExpression = xPath.compile(xpath);
        Node documentNode = XmlFunctions.getDocumentNode(xml);
        try {
            NodeList nodes = (NodeList)xpathExpression.evaluate(documentNode, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                return 1;
            }
            return 0;
        }
        catch (XPathExpressionException e) {
            try {
                Node node = (Node)xpathExpression.evaluate(documentNode, XPathConstants.NODE);
                if (node != null) {
                    return 1;
                }
                return 0;
            }
            catch (IllegalArgumentException | XPathExpressionException ex) {
                throw Static.RESOURCE.invalidInputForExistsNode(xpath, namespace).ex();
            }
        }
    }

    private static SimpleNamespaceContext extractNamespaceContext(String namespace) {
        if (!VALID_NAMESPACE_PATTERN.matcher(namespace).find()) {
            throw new IllegalArgumentException("Invalid namespace " + namespace);
        }
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        Matcher matcher = EXTRACT_NAMESPACE_PATTERN.matcher(namespace);
        while (matcher.find()) {
            namespaceMap.put((String)Nullness.castNonNull((Object)matcher.group(1)), (String)Nullness.castNonNull((Object)matcher.group(3)));
        }
        return new SimpleNamespaceContext(namespaceMap);
    }

    private static String convertNodeToString(Node node) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = ((TransformerFactory)Nullness.castNonNull((Object)TRANSFORMER_FACTORY.get())).newTransformer();
        transformer.setErrorListener(new InternalErrorListener());
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    private static Node getDocumentNode(String xml) {
        try {
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)Nullness.castNonNull((Object)DOCUMENT_BUILDER_FACTORY.get())).newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xml));
            return documentBuilder.parse(inputSource);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("XML parsing failed", e);
        }
    }

    private static class InternalErrorListener
    implements ErrorListener {
        private InternalErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

