/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class ResourcesValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightPath vPath = ctx.getValidationPath();
        if (!vPath.isEmpty()) {
            if (!vPath.isExpectedType(PDResources.class)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("8.1", "Resources validation process needs at least one PDResources object"));
            } else {
                PDResources resources = (PDResources)vPath.peek();
                this.validateFonts(ctx, resources);
                this.validateExtGStates(ctx, resources);
                this.validateShadingPattern(ctx, resources);
                this.validateTilingPattern(ctx, resources);
                this.validateXObjects(ctx, resources);
            }
        }
    }

    protected void validateFonts(PreflightContext context, PDResources resources) throws ValidationException {
        Map<String, PDFont> mapOfFonts = this.getFonts(resources.getCOSObject(), context);
        for (Map.Entry<String, PDFont> entry : mapOfFonts.entrySet()) {
            ContextHelper.validateElement(context, entry.getValue(), "font-process");
        }
    }

    private Map<String, PDFont> getFonts(COSDictionary resources, PreflightContext context) {
        HashMap<String, PDFont> fonts = new HashMap<String, PDFont>();
        COSDictionary fontsDictionary = (COSDictionary)resources.getDictionaryObject(COSName.FONT);
        if (fontsDictionary == null) {
            fontsDictionary = new COSDictionary();
            resources.setItem(COSName.FONT, (COSBase)fontsDictionary);
        }
        for (COSName fontName : fontsDictionary.keySet()) {
            COSBase font = fontsDictionary.getDictionaryObject(fontName);
            if (!(font instanceof COSDictionary)) continue;
            PDFont newFont = null;
            try {
                newFont = PDFontFactory.createFont((COSDictionary)((COSDictionary)font));
            }
            catch (IOException e) {
                this.addFontError((COSDictionary)font, context, e);
            }
            if (newFont == null) continue;
            fonts.put(fontName.getName(), newFont);
        }
        return fonts;
    }

    protected void validateExtGStates(PreflightContext context, PDResources resources) throws ValidationException {
        COSBase egsEntry = resources.getCOSObject().getItem("ExtGState");
        COSDocument cosDocument = context.getDocument().getDocument();
        COSDictionary extGState = COSUtils.getAsDictionary(egsEntry, cosDocument);
        if (egsEntry != null) {
            ContextHelper.validateElement(context, extGState, "extgstate-process");
        }
    }

    protected void validateShadingPattern(PreflightContext context, PDResources resources) throws ValidationException {
        try {
            for (COSName name : resources.getShadingNames()) {
                PDShading shading = resources.getShading(name);
                ContextHelper.validateElement(context, shading, "shading-pattern-process");
            }
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.6", e.getMessage(), e));
        }
    }

    protected void validateTilingPattern(PreflightContext context, PDResources resources) throws ValidationException {
        try {
            for (COSName name : resources.getPatternNames()) {
                PDAbstractPattern pattern = resources.getPattern(name);
                if (!(pattern instanceof PDTilingPattern)) continue;
                ContextHelper.validateElement(context, pattern, "tiling-pattern-process");
            }
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.6", e.getMessage(), e));
        }
    }

    protected void validateXObjects(PreflightContext context, PDResources resources) throws ValidationException {
        COSDocument cosDocument = context.getDocument().getDocument();
        COSDictionary mapOfXObj = COSUtils.getAsDictionary(resources.getCOSObject().getItem(COSName.XOBJECT), cosDocument);
        if (mapOfXObj == null) {
            return;
        }
        for (Map.Entry entry : mapOfXObj.entrySet()) {
            COSBase xobj = (COSBase)entry.getValue();
            if (xobj == null || !COSUtils.isStream(xobj, cosDocument)) continue;
            try {
                COSStream stream = COSUtils.getAsStream(xobj, cosDocument);
                PDXObject pdXObject = PDXObject.createXObject((COSBase)stream, (PDResources)resources);
                ContextHelper.validateElement(context, pdXObject, "graphic-process");
            }
            catch (IOException e) {
                context.addValidationError(new ValidationResult.ValidationError("2", e.getMessage() + " for entry '" + ((COSName)entry.getKey()).getName() + "'", e));
            }
        }
    }
}

