/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.Container;

public class RPCServlet
extends HttpServlet {
    protected Container container;
    Config config;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getInitParameter("config");
        JSON jSON = new JSON();
        if (string == null) {
            HashMap hashMap = new HashMap();
            Enumeration object = (Enumeration)Container.cast(servletConfig.getInitParameterNames());
            while (object.hasMoreElements()) {
                hashMap.put(object.nextElement(), servletConfig.getInitParameter((String)object.nextElement()));
            }
            string = jSON.format(hashMap);
        }
        try {
            this.config = jSON.parse((CharSequence)string, Config.class);
            if (this.config.container == null) {
                this.config.container = Container.class;
            }
            this.container = jSON.parse((CharSequence)string, this.config.container);
            this.container.init(this);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (this.config.errors == null) {
            this.config.errors = Collections.emptyMap();
        }
        if (this.config.mappings == null) {
            this.config.mappings = Collections.emptyMap();
        }
        for (Map.Entry entry : this.config.mappings.entrySet()) {
            ((RouteMapping)entry.getValue()).init((String)entry.getKey(), this.config);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRPC(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doRPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = httpServletRequest.getContextPath().equals("/") ? httpServletRequest.getRequestURI() : httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        Route route = null;
        for (RouteMapping object22 : this.config.mappings.values()) {
            route = object22.matches(httpServletRequest, string);
            if (route == null) continue;
            this.container.debug("Route found: " + httpServletRequest.getMethod() + " " + string);
            break;
        }
        if (route == null || !Container.isJSONType(httpServletRequest.getContentType())) {
            httpServletResponse.sendError(404, "Not Found");
            return;
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList(0);
        ArrayList arrayList2 = new ArrayList();
        Object object2 = null;
        JSON jSON = this.container.createJSON(httpServletRequest.getLocale());
        this.container.start(httpServletRequest, httpServletResponse);
        try {
            void var6_11;
            object = jSON.parse(httpServletRequest.getReader());
            if (object instanceof List && !((List)object).isEmpty()) {
                List list = (List)Container.cast(object);
                bl = true;
            } else if (object instanceof Map && !((Map)object).isEmpty()) {
                List<Object> list = Arrays.asList(object);
            } else {
                throw new IllegalArgumentException("Request is empty.");
            }
            for (int i = 0; i < var6_11.size(); ++i) {
                List<Object> list;
                Object object3;
                LinkedHashMap<String, Object> linkedHashMap;
                Map map = (Map)var6_11.get(i);
                String string2 = null;
                String string3 = null;
                ArrayList arrayList3 = null;
                Object v = null;
                Object object4 = null;
                LinkedHashMap<String, Object> linkedHashMap2 = null;
                try {
                    if (map.get("jsonrpc") != null && !"2.0".equals(map.get("jsonrpc"))) {
                        throw new IllegalArgumentException("jsonrpc is unrecognized version: " + map.get("jsonrpc"));
                    }
                    string2 = (String)map.get("jsonrpc");
                    if (map.get("method") instanceof String) {
                        string3 = (String)map.get("method");
                        if (string2 != null && string3.startsWith("rpc.")) {
                            this.container.warn("Method names that begin with 'rpc.' are reserved for system extensions.");
                        }
                    } else {
                        throw new IllegalArgumentException("method must " + (map.get("method") == null ? "not be null." : "be string."));
                    }
                    if (map.get("params") instanceof List || string2 != null && map.get("params") instanceof Map) {
                        arrayList3 = (ArrayList)map.get("params");
                    } else if (string2 != null && map.get("params") == null) {
                        arrayList3 = new ArrayList(0);
                    } else {
                        throw new IllegalArgumentException("params must be array" + (string2 != null ? " or object." : "."));
                    }
                    if (string2 != null && map.get("id") != null && !(map.get("id") instanceof String) && !(map.get("id") instanceof Number)) {
                        throw new IllegalArgumentException("id must be string, number or null.");
                    }
                    v = map.get("id");
                    linkedHashMap = null;
                    object3 = string3;
                    if (route.getParameter("class") == null) {
                        int n = string3.lastIndexOf(46);
                        linkedHashMap = n != -1 ? string3.substring(0, n) : null;
                        Object object5 = object3 = n != -1 ? string3.substring(n + 1) : string3;
                    }
                    if ((object2 = this.container.getComponent(route.getComponentClass(this.container, (String)((Object)linkedHashMap)))) == null) {
                        throw new NoSuchMethodException("Method not found: " + string3);
                    }
                    list = arrayList3 instanceof List ? (List<Object>)arrayList3 : Arrays.asList(arrayList3);
                    Method method = this.container.getMethod(object2, (String)object3, list);
                    if (method == null) {
                        throw new NoSuchMethodException("Method not found: " + string3);
                    }
                    jSON.setContext(object2);
                    object4 = this.container.execute(jSON, object2, method, list);
                }
                catch (Exception exception) {
                    linkedHashMap2 = new LinkedHashMap<String, Object>();
                    if (exception instanceof IllegalArgumentException) {
                        this.container.debug("Invalid Request.", exception);
                        linkedHashMap2.put("code", -32600);
                        linkedHashMap2.put("message", "Invalid Request.");
                    }
                    if (exception instanceof ClassNotFoundException) {
                        this.container.debug("Class Not Found.", exception);
                        linkedHashMap2.put("code", -32601);
                        linkedHashMap2.put("message", "Method not found.");
                    }
                    if (exception instanceof NoSuchMethodException) {
                        this.container.debug("Method Not Found.", exception);
                        linkedHashMap2.put("code", -32601);
                        linkedHashMap2.put("message", "Method not found.");
                    }
                    if (exception instanceof JSONException) {
                        this.container.debug("Invalid params.", exception);
                        linkedHashMap2.put("code", -32602);
                        linkedHashMap2.put("message", "Invalid params.");
                    }
                    if (exception instanceof InvocationTargetException) {
                        object3 = exception.getCause();
                        this.container.debug("Fails to invoke method.", (Throwable)object3);
                        if (object3 instanceof Error) {
                            throw (Error)object3;
                        }
                        if (object3 instanceof IllegalStateException || object3 instanceof UnsupportedOperationException) {
                            linkedHashMap2.put("code", -32601);
                            linkedHashMap2.put("message", "Method not found.");
                        } else if (object3 instanceof IllegalArgumentException) {
                            linkedHashMap2.put("code", -32602);
                            linkedHashMap2.put("message", "Invalid params.");
                        } else {
                            list = null;
                            for (Map.Entry<String, Integer> entry : this.config.errors.entrySet()) {
                                Class<?> clazz = ClassUtil.findClass(entry.getKey());
                                if (!clazz.isAssignableFrom(object3.getClass()) || entry.getValue() == null) continue;
                                list = entry.getValue();
                                break;
                            }
                            if (list != null) {
                                linkedHashMap2.put("code", list);
                                linkedHashMap2.put("message", object3.getClass().getSimpleName() + ": " + ((Throwable)object3).getMessage());
                                linkedHashMap2.put("data", object3);
                            } else {
                                this.container.error("Internal error occurred.", (Throwable)object3);
                                linkedHashMap2.put("code", -32603);
                                linkedHashMap2.put("message", "Internal error.");
                            }
                        }
                    }
                    this.container.error("Internal error occurred.", exception);
                    linkedHashMap2.put("code", -32603);
                    linkedHashMap2.put("message", "Internal error.");
                }
                if (string3 != null && string2 == null && v == null || string2 != null && map != null && !map.containsKey("id")) continue;
                linkedHashMap = new LinkedHashMap<String, Object>();
                if (string2 != null) {
                    linkedHashMap.put("jsonrpc", string2);
                }
                if (string2 == null || object4 != null) {
                    linkedHashMap.put("result", object4);
                }
                if (string2 == null || linkedHashMap2 != null) {
                    linkedHashMap.put("error", linkedHashMap2);
                }
                linkedHashMap.put("id", v);
                arrayList2.add(linkedHashMap);
            }
        }
        catch (Exception exception) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (exception instanceof JSONException) {
                this.container.debug("Fails to parse JSON.", exception);
                linkedHashMap.put("code", -32700);
                linkedHashMap.put("message", "Parse error.");
                linkedHashMap.put("data", exception);
            } else {
                this.container.debug("Invalid Request.", exception);
                linkedHashMap.put("code", -32600);
                linkedHashMap.put("message", "Invalid Request.");
            }
            LinkedHashMap<String, Object> linkedHashMap3 = new LinkedHashMap<String, Object>();
            linkedHashMap3.put("jsonrpc", "2.0");
            linkedHashMap3.put("error", linkedHashMap);
            linkedHashMap3.put("id", null);
            arrayList2.add(linkedHashMap3);
        }
        finally {
            this.container.end(httpServletRequest, httpServletResponse);
        }
        if (httpServletResponse.isCommitted()) {
            return;
        }
        if (arrayList2.isEmpty()) {
            httpServletResponse.setStatus(202);
            return;
        }
        httpServletResponse.setContentType("application/json");
        object = httpServletResponse.getWriter();
        ArrayList arrayList4 = bl ? arrayList2 : arrayList2.get(0);
        jSON.setContext(arrayList4);
        jSON.setPrettyPrint(this.container.isDebugMode());
        jSON.format((Object)arrayList4, (Appendable)object);
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Route {
        static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        String target;
        Map<Object, Object> params;

        public Route(String string, Map<String, Object> map) throws IOException {
            this.target = string;
            this.params = (Map)Container.cast(map);
        }

        public String getParameter(String string) {
            Object object;
            Object object2 = this.params.get(string);
            if (object2 instanceof Map && (object = (Map)object2).containsKey(null)) {
                object2 = object.get(null);
            }
            if (object2 instanceof List && !(object = (List)object2).isEmpty()) {
                object2 = object.get(0);
            }
            return object2 instanceof String ? (String)object2 : null;
        }

        public Map<?, ?> getParameterMap() {
            return this.params;
        }

        public String getComponentClass(Container container, String string) {
            Matcher matcher = REPLACE_PATTERN.matcher(this.target);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = this.getParameter(string2);
                if (string2.equals("class") && container.namingConversion) {
                    string3 = ClassUtil.toUpperCamel(string3 != null ? string3 : (string != null ? string : "?"));
                } else if (string2.equals("package")) {
                    string3 = string3.replace('/', '.');
                }
                matcher.appendReplacement(stringBuffer, string3 != null ? string3 : "");
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        public Map<?, ?> mergeParameterMap(Map<?, ?> map) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (this.params.containsKey(entry.getKey())) {
                    Object object;
                    Object object2 = this.params.get(entry.getKey());
                    if (object2 instanceof Map) {
                        object = (Map)object2;
                        if (object.containsKey(null)) {
                            object2 = object.get(null);
                            if (object2 instanceof List) {
                                ((List)object2).add(entry.getValue());
                                continue;
                            }
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            arrayList.add(object2);
                            arrayList.add(entry.getValue());
                            object.put(null, arrayList);
                            continue;
                        }
                        object.put(null, entry.getValue());
                        continue;
                    }
                    if (object2 instanceof List) {
                        ((List)object2).add(entry.getValue());
                        continue;
                    }
                    object = new ArrayList();
                    object.add(object2);
                    object.add(entry.getValue());
                    this.params.put(entry.getKey(), object);
                    continue;
                }
                this.params.put(entry.getKey(), entry.getValue());
            }
            return this.params;
        }
    }

    static class RouteMapping {
        static final Pattern PLACE_PATTERN = Pattern.compile("\\{\\s*(\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}\\.-]*)\\s*(?::\\s*((?:[^{}]|\\{[^{}]*\\})*)\\s*)?\\}");
        static final Pattern DEFAULT_PATTERN = Pattern.compile("[^/().]+");
        public String target;
        Config config;
        Pattern pattern;
        List<String> names;

        public void init(String string, Config config) {
            this.config = config;
            this.names = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer("^\\Q");
            Matcher matcher = PLACE_PATTERN.matcher(string);
            while (matcher.find()) {
                Pattern pattern;
                String string2 = matcher.group(1);
                this.names.add(string2);
                Pattern pattern2 = pattern = matcher.group(2) != null ? Pattern.compile(matcher.group(2)) : null;
                if (pattern == null && config.definitions.containsKey(string2)) {
                    pattern = config.definitions.get(string2);
                }
                if (pattern == null) {
                    pattern = DEFAULT_PATTERN;
                }
                matcher.appendReplacement(stringBuffer, "\\\\E(" + pattern.pattern().replaceAll("\\((?!\\?)", "(?:").replace("\\", "\\\\") + ")\\\\Q");
            }
            matcher.appendTail(stringBuffer);
            stringBuffer.append("\\E$");
            this.pattern = Pattern.compile(stringBuffer.toString());
        }

        public Route matches(HttpServletRequest httpServletRequest, String string) throws IOException {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (int i = 0; i < this.names.size(); ++i) {
                    String string2 = this.names.get(i);
                    String string3 = matcher.group(i + 1);
                    if (hashMap.containsKey(string2)) {
                        Object v = hashMap.get(string2);
                        if (v instanceof List) {
                            ((List)v).add(string3);
                            continue;
                        }
                        ArrayList<Object> arrayList = new ArrayList<Object>(2);
                        arrayList.add(v);
                        arrayList.add(string3);
                        continue;
                    }
                    hashMap.put(string2, string3);
                }
                return new Route(this.target, hashMap);
            }
            return null;
        }
    }

    static class Config {
        public Class<? extends Container> container;
        @JSONHint(anonym="target")
        public Map<String, RouteMapping> mappings;
        public Map<String, Pattern> definitions;
        public Map<String, Integer> errors;

        Config() {
        }
    }
}

