/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultS3BaseClientBuilder<B extends S3BaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultS3BaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "s3";
    }

    protected final String serviceName() {
        return "S3";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false).option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, S3Configuration.builder().build()));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        S3Configuration.Builder c;
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/s3/execution.interceptors");
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        c.profileFile((c = ((S3Configuration)config.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).toBuilder()).profileFile() != null ? c.profileFile() : (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName(c.profileName() != null ? c.profileName() : (String)config.option((ClientOption)SdkClientOption.PROFILE_NAME));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, c.build()).build();
    }

    private Signer defaultSigner() {
        return AwsS3V4Signer.create();
    }

    protected final String signingName() {
        return "s3";
    }

    public B serviceConfiguration(S3Configuration serviceConfiguration) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, (Object)serviceConfiguration);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public void setServiceConfiguration(S3Configuration serviceConfiguration) {
        this.serviceConfiguration(serviceConfiguration);
    }
}

