/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.signing;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.regions.providers.LazyAwsRegionProvider;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public abstract class DefaultSdkPresigner
implements SdkPresigner {
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new LazyAwsRegionProvider(DefaultAwsRegionProviderChain::new);
    private static final AwsCredentialsProvider DEFAULT_CREDENTIALS_PROVIDER = DefaultCredentialsProvider.create();
    private final Region region;
    private final URI endpointOverride;
    private final AwsCredentialsProvider credentialsProvider;

    protected DefaultSdkPresigner(Builder<?> b) {
        this.region = ((Builder)b).region != null ? ((Builder)b).region : DEFAULT_REGION_PROVIDER.getRegion();
        this.credentialsProvider = ((Builder)b).credentialsProvider != null ? ((Builder)b).credentialsProvider : DEFAULT_CREDENTIALS_PROVIDER;
        this.endpointOverride = ((Builder)b).endpointOverride;
    }

    protected Region region() {
        return this.region;
    }

    protected AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    protected URI endpointOverride() {
        return this.endpointOverride;
    }

    public void close() {
        IoUtils.closeIfCloseable((Object)this.credentialsProvider, null);
    }

    @SdkInternalApi
    public static abstract class Builder<B extends Builder<B>>
    implements SdkPresigner.Builder {
        private Region region;
        private AwsCredentialsProvider credentialsProvider;
        private URI endpointOverride;

        protected Builder() {
        }

        public B region(Region region) {
            this.region = region;
            return this.thisBuilder();
        }

        public B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this.thisBuilder();
        }

        public B endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this.thisBuilder();
        }

        private B thisBuilder() {
            return (B)this;
        }
    }
}

