/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;

public class SolrEnvironment {
    private String code = "unknown";
    private String label;
    private String color;
    private static Pattern pattern = Pattern.compile("^(prod|stage|test|dev)(,label=([\\w\\d+ _-]+))?(,color=([#\\w\\d]+))?");

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label == null ? null : this.label.replaceAll("\\+", " ");
    }

    public String getColor() {
        return this.color;
    }

    public boolean isDefined() {
        return !"unknown".equals(this.code);
    }

    public static SolrEnvironment parse(String environmentString) {
        SolrEnvironment env = new SolrEnvironment();
        if (environmentString == null || environmentString.equalsIgnoreCase("unknown")) {
            return env;
        }
        Matcher m = pattern.matcher(environmentString);
        if (!m.matches()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad environment pattern: " + environmentString);
        }
        env.code = m.group(1);
        if (m.group(3) != null) {
            env.label = m.group(3);
        }
        if (m.group(5) != null) {
            env.color = m.group(5);
        }
        return env;
    }

    public static SolrEnvironment getFromSyspropOrClusterprop(ZkStateReader zkStateReader) {
        String env = "unknown";
        if (System.getProperty("solr.environment") != null) {
            env = System.getProperty("solr.environment");
        } else if (zkStateReader != null) {
            env = (String)zkStateReader.getClusterProperty("environment", (Object)"unknown");
        }
        return SolrEnvironment.parse(env);
    }
}

