/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.util.BytesRef;

public class SubstringBytesRefFilter
implements Predicate<BytesRef> {
    private final String contains;
    private final boolean ignoreCase;

    public SubstringBytesRefFilter(String contains, boolean ignoreCase) {
        this.contains = contains;
        this.ignoreCase = ignoreCase;
    }

    public String substring() {
        return this.contains;
    }

    protected boolean includeString(String term) {
        if (this.ignoreCase) {
            return StringUtils.containsIgnoreCase((CharSequence)term, (CharSequence)this.contains);
        }
        return StringUtils.contains((CharSequence)term, (CharSequence)this.contains);
    }

    @Override
    public boolean test(BytesRef term) {
        return this.includeString(term.utf8ToString());
    }
}

