/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.GeometryCombiner;

public class UnionInteracting {
    private GeometryFactory geomFactory;
    private Geometry g0;
    private Geometry g1;
    private boolean[] interacts0;
    private boolean[] interacts1;

    public static Geometry union(Geometry g0, Geometry g1) {
        UnionInteracting uue = new UnionInteracting(g0, g1);
        return uue.union();
    }

    public UnionInteracting(Geometry g0, Geometry g1) {
        this.g0 = g0;
        this.g1 = g1;
        this.geomFactory = g0.getFactory();
        this.interacts0 = new boolean[g0.getNumGeometries()];
        this.interacts1 = new boolean[g1.getNumGeometries()];
    }

    public Geometry union() {
        this.computeInteracting();
        Geometry int0 = this.extractElements(this.g0, this.interacts0, true);
        Geometry int1 = this.extractElements(this.g1, this.interacts1, true);
        Geometry union = int0.union(int1);
        Geometry disjoint0 = this.extractElements(this.g0, this.interacts0, false);
        Geometry disjoint1 = this.extractElements(this.g1, this.interacts1, false);
        Geometry overallUnion = GeometryCombiner.combine(union, disjoint0, disjoint1);
        return overallUnion;
    }

    private void computeInteracting() {
        for (int i = 0; i < this.g0.getNumGeometries(); ++i) {
            Geometry elem = this.g0.getGeometryN(i);
            this.interacts0[i] = this.computeInteracting(elem);
        }
    }

    private boolean computeInteracting(Geometry elem0) {
        boolean interactsWithAny = false;
        for (int i = 0; i < this.g1.getNumGeometries(); ++i) {
            Geometry elem1 = this.g1.getGeometryN(i);
            boolean interacts = elem1.getEnvelopeInternal().intersects(elem0.getEnvelopeInternal());
            if (interacts) {
                this.interacts1[i] = true;
            }
            if (!interacts) continue;
            interactsWithAny = true;
        }
        return interactsWithAny;
    }

    private Geometry extractElements(Geometry geom, boolean[] interacts, boolean isInteracting) {
        ArrayList<Geometry> extractedGeoms = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry elem = geom.getGeometryN(i);
            if (interacts[i] != isInteracting) continue;
            extractedGeoms.add(elem);
        }
        return this.geomFactory.buildGeometry(extractedGeoms);
    }
}

