/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.misc.index.IndexRearranger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class BinaryDocValueSelector
implements IndexRearranger.DocumentSelector,
Serializable {
    private final String field;
    private final HashSet<String> keySet;

    public BinaryDocValueSelector(String field, HashSet<String> keySet) {
        this.field = field;
        this.keySet = keySet;
    }

    @Override
    public BitSet getFilteredLiveDocs(CodecReader reader) throws IOException {
        BinaryDocValues binaryDocValues = reader.getBinaryDocValues(this.field);
        Bits oldLiveDocs = reader.getLiveDocs();
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        for (int i = 0; i < reader.maxDoc(); ++i) {
            if (oldLiveDocs != null && !oldLiveDocs.get(i) || !binaryDocValues.advanceExact(i) || !this.keySet.contains(binaryDocValues.binaryValue().utf8ToString())) continue;
            bits.set(i);
        }
        return bits;
    }

    public static List<IndexRearranger.DocumentSelector> createFromExistingIndex(String field, Directory directory) throws IOException {
        ArrayList<IndexRearranger.DocumentSelector> selectors = new ArrayList<IndexRearranger.DocumentSelector>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            for (LeafReaderContext context : reader.leaves()) {
                HashSet<String> keySet = new HashSet<String>();
                Bits liveDocs = context.reader().getLiveDocs();
                BinaryDocValues binaryDocValues = context.reader().getBinaryDocValues(field);
                for (int i = 0; i < context.reader().maxDoc(); ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) continue;
                    if (binaryDocValues.advanceExact(i)) {
                        keySet.add(binaryDocValues.binaryValue().utf8ToString());
                        continue;
                    }
                    throw new AssertionError((Object)"Document don't have selected key");
                }
                selectors.add(new BinaryDocValueSelector(field, keySet));
            }
        }
        return selectors;
    }
}

