/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NamedThreadFactory;

public class IndexRearranger {
    protected final Directory input;
    protected final Directory output;
    protected final IndexWriterConfig config;
    protected final List<DocumentSelector> documentSelectors;

    public IndexRearranger(Directory input, Directory output, IndexWriterConfig config, List<DocumentSelector> documentSelectors) {
        this.input = input;
        this.output = output;
        this.config = config;
        this.documentSelectors = documentSelectors;
    }

    public void execute() throws Exception {
        this.config.setMergePolicy(NoMergePolicy.INSTANCE);
        try (IndexWriter writer = new IndexWriter(this.output, this.config);
             DirectoryReader reader = DirectoryReader.open((Directory)this.input);){
            ExecutorService executor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), this.documentSelectors.size()), (ThreadFactory)new NamedThreadFactory("rearranger"));
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (DocumentSelector documentSelector : this.documentSelectors) {
                Callable<Void> addSegment = () -> IndexRearranger.lambda$execute$0(writer, (IndexReader)reader, documentSelector);
                futures.add(executor.submit(addSegment));
            }
            for (Future future : futures) {
                future.get();
            }
            executor.shutdown();
        }
    }

    private static void addOneSegment(IndexWriter writer, IndexReader reader, DocumentSelector selector) throws IOException {
        CodecReader[] readers = new CodecReader[reader.leaves().size()];
        for (LeafReaderContext context : reader.leaves()) {
            readers[context.ord] = new DocSelectorFilteredCodecReader((CodecReader)context.reader(), selector);
        }
        writer.addIndexes(readers);
    }

    private static /* synthetic */ Void lambda$execute$0(IndexWriter writer, IndexReader reader, DocumentSelector record) throws Exception {
        IndexRearranger.addOneSegment(writer, reader, record);
        return null;
    }

    public static interface DocumentSelector {
        public BitSet getFilteredLiveDocs(CodecReader var1) throws IOException;
    }

    private static class DocSelectorFilteredCodecReader
    extends FilterCodecReader {
        BitSet filteredLiveDocs;
        int numDocs;

        public DocSelectorFilteredCodecReader(CodecReader in, DocumentSelector selector) throws IOException {
            super(in);
            this.filteredLiveDocs = selector.getFilteredLiveDocs(in);
            this.numDocs = this.filteredLiveDocs.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public Bits getLiveDocs() {
            return this.filteredLiveDocs;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

