/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public final class RandomWrapper
extends Random {
    private static final long STANDARD_SEED = -3819370596149511490L;
    private final RandomGenerator random;

    RandomWrapper() {
        this.random = new MersenneTwister();
        this.random.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this.random));
    }

    RandomWrapper(long seed) {
        this.random = new MersenneTwister(seed);
    }

    @Override
    public void setSeed(long seed) {
        if (this.random != null) {
            this.random.setSeed(seed);
        }
    }

    void resetToTestSeed() {
        this.setSeed(-3819370596149511490L);
    }

    public RandomGenerator getRandomGenerator() {
        return this.random;
    }

    @Override
    protected int next(int bits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return this.random.nextInt();
    }

    @Override
    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    @Override
    public long nextLong() {
        return this.random.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.random.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.random.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.random.nextGaussian();
    }
}

