/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.flavor.MatrixFlavor;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.list.IntArrayList;

public class SparseMatrix
extends AbstractMatrix {
    private Int2ObjectOpenHashMap<Vector> rowVectors = new Int2ObjectOpenHashMap();

    public SparseMatrix(int rows, int columns, Map<Integer, Vector> rowVectors) {
        this(rows, columns, rowVectors, false);
    }

    public SparseMatrix(int rows, int columns, Map<Integer, Vector> rowVectors, boolean shallow) {
        super(rows, columns);
        if (shallow) {
            for (Map.Entry<Integer, Vector> entry : rowVectors.entrySet()) {
                this.rowVectors.put(entry.getKey().intValue(), (Object)entry.getValue());
            }
        } else {
            for (Map.Entry<Integer, Vector> entry : rowVectors.entrySet()) {
                this.rowVectors.put(entry.getKey().intValue(), (Object)entry.getValue().clone());
            }
        }
    }

    public SparseMatrix(int rows, int columns) {
        super(rows, columns);
    }

    @Override
    public Matrix clone() {
        SparseMatrix clone = new SparseMatrix(this.numRows(), this.numCols());
        for (MatrixSlice slice : this) {
            clone.rowVectors.put(slice.index(), (Object)slice.clone());
        }
        return clone;
    }

    @Override
    public int numSlices() {
        return this.rowVectors.size();
    }

    @Override
    public Iterator<MatrixSlice> iterateNonEmpty() {
        final int[] keys = this.rowVectors.keySet().toIntArray();
        return new AbstractIterator<MatrixSlice>(){
            private int slice;

            protected MatrixSlice computeNext() {
                if (this.slice >= SparseMatrix.this.rowVectors.size()) {
                    return (MatrixSlice)this.endOfData();
                }
                int i = keys[this.slice];
                Vector row = (Vector)SparseMatrix.this.rowVectors.get(i);
                ++this.slice;
                return new MatrixSlice(row, i);
            }
        };
    }

    @Override
    public double getQuick(int row, int column) {
        Vector r = (Vector)this.rowVectors.get(row);
        return r == null ? 0.0 : r.getQuick(column);
    }

    @Override
    public Matrix like() {
        return new SparseMatrix(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        Vector r = (Vector)this.rowVectors.get(row);
        if (r == null) {
            r = new RandomAccessSparseVector(this.columnSize());
            this.rowVectors.put(row, (Object)r);
        }
        r.setQuick(column, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[0] = this.rowVectors.size();
        for (Vector row : this.rowVectors.values()) {
            result[1] = Math.max(result[1], row.getNumNondefaultElements());
        }
        return result;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], this.rowSize());
        }
        if (offset[0] + size[0] > this.rowSize()) {
            throw new IndexException(offset[0] + size[0], this.rowSize());
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], this.columnSize());
        }
        if (offset[1] + size[1] > this.columnSize()) {
            throw new IndexException(offset[1] + size[1], this.columnSize());
        }
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix assign(Matrix other, DoubleDoubleFunction function) {
        if (Functions.PLUS.equals(function) && other instanceof SparseMatrix) {
            int rows = this.rowSize();
            if (rows != other.rowSize()) {
                throw new CardinalityException(rows, other.rowSize());
            }
            int columns = this.columnSize();
            if (columns != other.columnSize()) {
                throw new CardinalityException(columns, other.columnSize());
            }
            SparseMatrix otherSparse = (SparseMatrix)other;
            ObjectIterator fastIterator = otherSparse.rowVectors.int2ObjectEntrySet().fastIterator();
            while (fastIterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)fastIterator.next();
                int rowIndex = entry.getIntKey();
                Vector row = (Vector)this.rowVectors.get(rowIndex);
                if (row == null) {
                    this.rowVectors.put(rowIndex, (Object)((Vector)entry.getValue()).clone());
                    continue;
                }
                row.assign((Vector)entry.getValue(), Functions.PLUS);
            }
            return this;
        }
        return super.assign(other, function);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.rowSize() != other.size()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        for (int row = 0; row < this.rowSize(); ++row) {
            double val = other.getQuick(row);
            if (val == 0.0) continue;
            Vector r = (Vector)this.rowVectors.get(row);
            if (r == null) {
                r = new RandomAccessSparseVector(this.columnSize());
                this.rowVectors.put(row, (Object)r);
            }
            r.setQuick(column, val);
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new CardinalityException(this.columnSize(), other.size());
        }
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        this.rowVectors.put(row, (Object)other);
        return this;
    }

    @Override
    public Vector viewRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        Vector res = (Vector)this.rowVectors.get(row);
        if (res == null) {
            res = new RandomAccessSparseVector(this.columnSize());
            this.rowVectors.put(row, (Object)res);
        }
        return res;
    }

    public IntArrayList nonZeroRowIndices() {
        return new IntArrayList(this.rowVectors.keySet().toIntArray());
    }

    @Override
    public MatrixFlavor getFlavor() {
        return MatrixFlavor.SPARSEROWLIKE;
    }
}

