/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.algorithms.regression;

import org.apache.commons.math3.distribution.TDistribution;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.algorithms.regression.LinearRegressorFitter;
import org.apache.mahout.math.algorithms.regression.LinearRegressorModel;
import org.apache.mahout.math.algorithms.regression.tests.FittnessTests$;
import org.apache.mahout.math.drm.DrmLike;
import org.apache.mahout.math.drm.RLikeDrmOps$;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.scalabindings.MahoutCollections$;
import org.apache.mahout.math.scalabindings.RLikeDoubleScalarOps$;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import org.apache.mahout.math.scalabindings.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public abstract class LinearRegressorFitter$class {
    public static void setStandardHyperparameters(LinearRegressorFitter $this, Map hyperparameters) {
        $this.calcCommonStatistics_$eq(BoxesRunTime.unboxToBoolean((Object)hyperparameters.getOrElse((Object)Symbol$.MODULE$.apply("calcCommonStatistics"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        $this.calcStandardErrors_$eq(BoxesRunTime.unboxToBoolean((Object)hyperparameters.getOrElse((Object)Symbol$.MODULE$.apply("calcStandardErrors"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        $this.addIntercept_$eq(BoxesRunTime.unboxToBoolean((Object)hyperparameters.getOrElse((Object)Symbol$.MODULE$.apply("addIntercept"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
    }

    public static Map setStandardHyperparameters$default$1(LinearRegressorFitter $this) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Symbol$.MODULE$.apply("foo")), (Object)None$.MODULE$)}));
    }

    public static LinearRegressorModel calculateStandardError(LinearRegressorFitter $this, DrmLike X, DrmLike drmTarget, Matrix drmXtXinv, LinearRegressorModel model) {
        DrmLike yhat = RLikeDrmOps$.MODULE$.drm2RLikeOps(X).$percent$times$percent(model.beta());
        DrmLike residuals = RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).$minus(yhat);
        LinearRegressorModel modelOut = FittnessTests$.MODULE$.calculateResidualSumOfSquares(model, residuals);
        long n = drmTarget.nrow();
        int k = org.apache.mahout.math.drm.package$.MODULE$.safeToNonNegInt(X.ncol());
        double invDegFreedomKindOf = 1.0 / (double)(n - (long)k);
        Matrix varCovarMatrix = RLikeDoubleScalarOps$.MODULE$.$times$extension0(RLikeOps$.MODULE$.double2Scalar(invDegFreedomKindOf * modelOut.rss()), drmXtXinv);
        Vector se = varCovarMatrix.viewDiagonal().assign(Functions.SQRT);
        Vector tScore = RLikeOps$.MODULE$.v2vOps(model.beta()).$div(se);
        TDistribution tDist = new TDistribution((double)(n - (long)k));
        DenseVector pval = package$.MODULE$.dvec((TraversableOnce<Object>)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(MahoutCollections$.MODULE$.v2scalaish(tScore).toArray()).map((Function1)new Serializable($this, tDist){
            public static final long serialVersionUID = 0L;
            private final TDistribution tDist$1;

            public final double apply(double t) {
                return this.apply$mcDD$sp(t);
            }

            public double apply$mcDD$sp(double t) {
                return (double)2 * (1.0 - this.tDist$1.cumulativeProbability(Math.abs(t)));
            }
            {
                this.tDist$1 = tDist$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
        modelOut.se_$eq(se);
        modelOut.tScore_$eq(tScore);
        modelOut.pval_$eq(pval);
        modelOut.degreesOfFreedom_$eq(org.apache.mahout.math.drm.package$.MODULE$.safeToNonNegInt(X.ncol()));
        modelOut.trainingExamples_$eq(org.apache.mahout.math.drm.package$.MODULE$.safeToNonNegInt(n));
        if ($this.calcCommonStatistics()) {
            modelOut = $this.calculateCommonStatistics(modelOut, drmTarget, residuals);
        }
        modelOut.summary_$eq($this.generateSummaryString(modelOut));
        return modelOut;
    }

    public static LinearRegressorModel calculateCommonStatistics(LinearRegressorFitter $this, LinearRegressorModel model, DrmLike drmTarget, DrmLike residuals) {
        LinearRegressorModel modelOut = model;
        modelOut = FittnessTests$.MODULE$.CoefficientOfDetermination(model, drmTarget, residuals);
        modelOut = FittnessTests$.MODULE$.MeanSquareError(model, residuals);
        modelOut = FittnessTests$.MODULE$.FTest(model, drmTarget);
        return modelOut;
    }

    public static LinearRegressorModel modelPostprocessing(LinearRegressorFitter $this, LinearRegressorModel model, DrmLike X, DrmLike drmTarget, Matrix drmXtXinv) {
        Object object;
        ObjectRef modelOut = ObjectRef.create((Object)model);
        if ($this.calcStandardErrors()) {
            modelOut.elem = $this.calculateStandardError(X, drmTarget, drmXtXinv, model);
            object = BoxedUnit.UNIT;
        } else {
            ((LinearRegressorModel)modelOut.elem).summary_$eq(new StringBuilder().append((Object)"Coef.\t\tEstimate\n").append((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), X.ncol()).map((Function1)new Serializable($this, modelOut){
                public static final long serialVersionUID = 0L;
                private final ObjectRef modelOut$1;

                public final String apply(int i) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToDouble((double)RLikeOps$.MODULE$.v2vOps(((LinearRegressorModel)this.modelOut$1.elem).beta()).apply(i))}));
                }
                {
                    this.modelOut$1 = modelOut$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n")).toString());
            if ($this.calcCommonStatistics()) {
                DrmLike residuals = RLikeDrmOps$.MODULE$.drm2RLikeOps(drmTarget).$minus(RLikeDrmOps$.MODULE$.drm2RLikeOps(X).$percent$times$percent(((LinearRegressorModel)modelOut.elem).beta()));
                modelOut.elem = FittnessTests$.MODULE$.calculateResidualSumOfSquares((LinearRegressorModel)modelOut.elem, residuals);
                modelOut.elem = $this.calculateCommonStatistics((LinearRegressorModel)modelOut.elem, drmTarget, residuals);
            }
            object = (LinearRegressorModel)modelOut.elem;
        }
        if ($this.addIntercept()) {
            model.summary().replace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(X.ncol() - 1))})), "(Intercept)");
            model.addIntercept_$eq(true);
        }
        return model;
    }

    /*
     * WARNING - void declaration
     */
    public static String generateSummaryString(LinearRegressorFitter $this, LinearRegressorModel model) {
        void var3_3;
        int k = RLikeOps$.MODULE$.v2vOps(model.beta()).length();
        String summaryString = new StringBuilder().append((Object)"\nCoef.\t\tEstimate\t\tStd. Error\t\tt-score\t\t\tPr(Beta=0)\n").append((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).map((Function1)new Serializable($this, model){
            public static final long serialVersionUID = 0L;
            private final LinearRegressorModel model$1;

            public final String apply(int i) {
                return new StringOps(Predef$.MODULE$.augmentString("X%-3d\t\t%+5.5f\t\t%+5.5f\t\t%+5.5f\t\t%+5.5f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToDouble((double)RLikeOps$.MODULE$.v2vOps(this.model$1.beta()).apply(i)), BoxesRunTime.boxToDouble((double)RLikeOps$.MODULE$.v2vOps(this.model$1.se()).apply(i)), BoxesRunTime.boxToDouble((double)RLikeOps$.MODULE$.v2vOps(this.model$1.tScore()).apply(i)), BoxesRunTime.boxToDouble((double)RLikeOps$.MODULE$.v2vOps(this.model$1.pval()).apply(i))}));
            }
            {
                this.model$1 = model$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
        if ($this.calcCommonStatistics()) {
            summaryString = new StringBuilder().append((Object)summaryString).append((Object)new StringBuilder().append((Object)"\nF-statistic: ").append((Object)BoxesRunTime.boxToDouble((double)model.fScore())).append((Object)" on ").append((Object)BoxesRunTime.boxToInteger((int)(model.degreesOfFreedom() - 1))).append((Object)" and ").append((Object)BoxesRunTime.boxToInteger((int)(model.trainingExamples() - model.degreesOfFreedom()))).append((Object)" DF,  p-value: ").append((Object)BoxesRunTime.boxToDouble((double)0.009545)).append((Object)"\n").toString()).toString();
            summaryString = new StringBuilder().append((Object)summaryString).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nMean Squared Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)model.mse())}))).toString();
            summaryString = new StringBuilder().append((Object)summaryString).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nR^2: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)model.r2())}))).toString();
        }
        return var3_3;
    }

    public static void $init$(LinearRegressorFitter $this) {
    }
}

