/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mahout.math.function.ObjectObjectProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.OpenHashSet;

public class OpenHashMap<K, V>
extends AbstractSet
implements Map<K, V> {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final Object NO_KEY_VALUE = null;
    protected Object[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;

    public OpenHashMap() {
        this(277);
    }

    public OpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenHashMap copy = (OpenHashMap)super.clone();
        copy.table = (Object[])copy.table.clone();
        copy.values = (Object[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public boolean forEachKey(ObjectProcedure<K> procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(ObjectObjectProcedure<K, V> procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        return (V)this.values[i];
    }

    protected int indexOfInsertion(K key) {
        Object[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && !OpenHashMap.equalsMindTheNull(key, tab[i])) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(K key) {
        Object[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (!(stat[i] == 0 || stat[i] != 2 && OpenHashMap.equalsMindTheNull(key, tab[i]))) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(V value) {
        Object[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || !OpenHashMap.equalsMindTheNull(val[i], value)) continue;
            return i;
        }
        return -1;
    }

    public void keys(List<K> list) {
        list.clear();
        Object[] tab = this.table;
        byte[] stat = this.state;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            list.add(tab[i]);
        }
    }

    @Override
    public V put(K key, V value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            Object previous = this.values[i];
            this.values[i] = value;
            return (V)previous;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return null;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        Object[] oldTable = this.table;
        Object[] oldValues = this.values;
        byte[] oldState = this.state;
        Object[] newTable = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            Object element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
            newState[index] = 1;
        }
    }

    @Override
    public V remove(Object key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        Object removed = this.values[i];
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return (V)removed;
    }

    @Override
    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new Object[capacity];
        this.values = new Object[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final OpenHashSet<Map.Entry<K, V>> entries = new OpenHashSet<Map.Entry<K, V>>();
        this.forEachPair(new ObjectObjectProcedure<K, V>(){

            @Override
            public boolean apply(K key, V value) {
                entries.add(new MapEntry(key, value));
                return true;
            }
        });
        return entries;
    }

    @Override
    public Set<K> keySet() {
        final OpenHashSet keys = new OpenHashSet();
        this.forEachKey(new ObjectProcedure<K>(){

            @Override
            public boolean apply(K element) {
                keys.add(element);
                return true;
            }
        });
        return keys;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        final ArrayList valueList = new ArrayList();
        this.forEachPair(new ObjectObjectProcedure<K, V>(){

            @Override
            public boolean apply(K key, V value) {
                valueList.add(value);
                return true;
            }
        });
        return valueList;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OpenHashMap)) {
            return false;
        }
        final OpenHashMap o = (OpenHashMap)obj;
        if (o.size() != this.size()) {
            return false;
        }
        final boolean[] equal = new boolean[]{true};
        this.forEachPair(new ObjectObjectProcedure<K, V>(){

            @Override
            public boolean apply(K key, V value) {
                Object ov = o.get(key);
                if (!value.equals(ov)) {
                    equal[0] = false;
                    return false;
                }
                return true;
            }
        });
        return equal[0];
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.forEachPair(new ObjectObjectProcedure<K, V>(){

            @Override
            public boolean apply(K key, V value) {
                sb.append('[');
                sb.append(key);
                sb.append(" -> ");
                sb.append(value);
                sb.append("] ");
                return true;
            }
        });
        sb.append('}');
        return sb.toString();
    }

    private class MapEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("Map.Entry.setValue not supported for OpenHashMap");
        }
    }
}

